package com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterImpl;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.MutableDateFilter;
import com.agilex.healthcare.utility.DateHelper;

@Ignore
public class MicroLabDataLayerExcelTest {

	private PatientIdentifier createPatientIdentifier() {
		PatientIdentifier patientIdentifier = new PatientIdentifier();
		patientIdentifier.setAssigningAuthority("dfn-500");
		patientIdentifier.setUniqueId("PATID26");
		return patientIdentifier;
	}
	
	@Test
	public void validateMicroData() {
		MicrobiologyLabDataLayerExcel dataLayer = new MicrobiologyLabDataLayerExcel();
		LabResults labResults = dataLayer.getLabResults(createPatientIdentifier(), createDateFilter());
		assertTrue(labResults.size() > 0);

		LabResult sampleMicroResult = null;
		for (LabResult labResult : labResults) {
			System.out.println("accession,testid => " + labResult.getAccessionNumber() + "," + labResult.getTestId());
			if (labResult.getAccessionNumber().contentEquals("microAccession1") && labResult.getTestId().contentEquals("AFB C&S")) {
				sampleMicroResult = labResult;
			}
		}

		assertNotNull(sampleMicroResult);
		assertEquals("M", sampleMicroResult.getLabType());
		assertEquals("this is a sample small report", sampleMicroResult.getValue());
	}

	@Test
	public void validateMicroTestsMarked() {
		MicrobiologyLabDataLayerExcel dataLayer = new MicrobiologyLabDataLayerExcel();
		LabResults labResults = dataLayer.getLabResults(createPatientIdentifier(), createDateFilter());
		assertTrue(labResults.size() > 0);

		for (LabResult labResult : labResults) {
			assertEquals("M", labResult.getLabType());
		}
	}

	private DateFilter createDateFilter() {
		MutableDateFilter dateFilter = new DateFilterImpl();
		dateFilter.setStartDate(DateHelper.parseDate("1/1/2001"));
		dateFilter.setEndDate(new Date());
		return dateFilter;
	}
}
