package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;

public class LabFilterTest {
	@Test
	public void filterEmptyList() {
		LabResults labResults = new LabResults();
		LabResults filteredList = LabFilter.filterByType(labResults, "b");
		assertEquals(0, filteredList.size());
	}

	@Test
	public void filterNullList() {
		LabResults labResults = null;
		LabResults filteredList = LabFilter.filterByType(labResults, "b");
		assertNull(filteredList);
	}

	@Test
	public void standardFilter() {
		LabResults labResults = new LabResults();
		labResults.add(labWithType("a"));
		labResults.add(labWithType("b"));
		labResults.add(labWithType("b"));
		labResults.add(labWithType("c"));
		labResults.add(labWithType("c"));
		labResults.add(labWithType("c"));

		LabResults filteredList = LabFilter.filterByType(labResults, "b");
		assertEquals(2, filteredList.size());
		for (LabResult result : filteredList) {
			assertEquals("b", result.getLabType());
		}
	}

	@Test
	public void filterListThatContainsLabWithoutType() {
		LabResults labResults = new LabResults();
		labResults.add(labWithType(""));
		labResults.add(labWithType(null));
		labResults.add(labWithType("a"));
		labResults.add(labWithType("b"));
		labResults.add(labWithType("b"));
		labResults.add(labWithType("c"));
		labResults.add(labWithType("c"));
		labResults.add(labWithType("c"));

		LabResults filteredList = LabFilter.filterByType(labResults, "b");
		assertEquals(2, filteredList.size());
		for (LabResult result : filteredList) {
			assertEquals("b", result.getLabType());
		}
	}

	@Test
	public void filterUsingBlank() {
		LabResults labResults = new LabResults();
		labResults.add(labWithType(""));
		labResults.add(labWithType(""));
		labResults.add(labWithType(""));
		labResults.add(labWithType(""));
		labResults.add(labWithType(null));
		labResults.add(labWithType("a"));
		labResults.add(labWithType("b"));
		labResults.add(labWithType("b"));
		labResults.add(labWithType("c"));
		labResults.add(labWithType("c"));
		labResults.add(labWithType("c"));

		LabResults filteredList = LabFilter.filterByType(labResults, "");
		assertEquals(4, filteredList.size());
		for (LabResult result : filteredList) {
			assertEquals("", result.getLabType());
		}
	}

	@Test
	public void filterTwoItems() {
		LabResults labResults = new LabResults();
		labResults.add(labWithType("a"));
		labResults.add(labWithType("b"));
		labResults.add(labWithType("c"));

		LabResults filteredList = LabFilter.filterByType(labResults, "b", "c");
		assertEquals(2, filteredList.size());
		for (LabResult result : filteredList) {
			assertTrue(result.getLabType().contentEquals("b") || result.getLabType().contentEquals("c"));
		}
	}

	private LabResult labWithType(String type) {
		LabResult labResult = new LabResult();
		labResult.setLabType(type);
		return labResult;
	}

}
