package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;

public class FacilityDataLayerMockTest {

	private FacilityDataLayerMock datalayer = new FacilityDataLayerMock();

	@Test
	public void verifyFetchCalifornia() {
		assertSizeByStateAbbreviation("CA", 5);
	}

	@Test
	public void verifyFetchDistrictOfColumbia() {
		assertSizeByStateAbbreviation("VA", 5);
	}

	@Test
	public void verifyFetchOhio() {
		assertSizeByStateAbbreviation("OH", 5);
	}

	@Test
	public void verifyFetchPaloAlto() {
		assertSizeByStateAbbreviation("CA", 5);
	}
	
	@Test
	public void verifyFetchWestVirginia() {
		assertSizeByStateAbbreviation("WV", 2);
	}
	
	@Test
	public void verifyFetchMaryland() {
		assertSizeByStateAbbreviation("MD", 1);
	}
	
	@Test
	public void verifyFetchTennessee() {
		assertSizeByStateAbbreviation("TN", 1);
	}
	
	@Test
	public void verifyFetchFlorida() {
		assertSizeByStateAbbreviation("FL", 1);
	}

	@Test
	public void verifyFetchNewJersey() {
		assertSizeByStateAbbreviation("NJ", 1);
	}

	@Test
	public void verifyFetchNorthCarolina() {
		assertSizeByStateAbbreviation("NC", 2);
	}

	@Test
	public void verifyFetchColorado() {
		assertSizeByStateAbbreviation("CO", 1);
	}

	@Test
	public void verifyFetchSouthCarolina() {
		assertSizeByStateAbbreviation("SC", 1);
	}
	
	@Test
	public void verifyFetchTexas() {
		assertSizeByStateAbbreviation("TX", 1);
	}	
	@Test
	public void verifyTermFilteringWithNoMatches() {
		FacilityFilter filter = new FacilityFilter();
		filter.setTerm("non-match");
		Facilities shouldBeEmpty = datalayer.fetchFacilities(filter);

		assertEquals(0, shouldBeEmpty.size());
	}

	@Test
	public void verifyFetchWithoutSiteDoesNotCrashWithUnknownState() {
		FacilityFilter filter = new FacilityFilter();
		filter.setTerm("ZZ");
		Facilities matches = datalayer.fetchFacilities(filter);

		assert(0 == matches.size());
	}

	@Test
	public void verifyFetchWithSiteDoesNotCrashWithUnknownState() {
		
		FacilityFilter filter = new FacilityFilter();
		filter.setTerm("CA non-match");
		Facilities matches = datalayer.fetchFacilities(filter);

		assert(0 == matches.size());
	}

	private void assertSizeByStateAbbreviation(String state, int size) {
		FacilityFilter filter = new FacilityFilter();
		filter.setTerm(state);
		Facilities facilities = datalayer.fetchFacilities(filter);

		assertTrue(facilities.size() >= size);
	}
}
