package com.agilex.healthcare.mobilehealthplatform.datalayer.diet;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.DietEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.DietEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.utility.DateHelper;

public class DietDataLayerMockTest {

	@Test
	public void getPrestagedMeal() {
		DietDataLayer dao = new DietDataLayerMock();
		DietEntries meals = dao.getDietEntries("PATID26");
		assertEquals(9, meals.size());
	}

	@Test
	public void get0Meals() {
		DietDataLayer dao = new DietDataLayerMock();
		DietEntries meals = dao.getDietEntries("invalid");
		assertEquals(0, meals.size());
	}

	@Test
	public void addAndRetrieveVitals() {
		DietDataLayer dao = new DietDataLayerMock();
		String patientId = "pat1";
		DietEntries meals = dao.getDietEntries(patientId);
		assertEquals(0, meals.size());

		DietEntry mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		DietEntry savedEntry = dao.saveDietEntry(mealEntry);

		meals = dao.getDietEntries(patientId);
		assertEquals(1, meals.size());
		assertEquals(savedEntry.getId(), meals.get(0).getId());
	}

	@Test
	public void retrieveWithDates() {
		String patientId = "pat3";
		Date dtA = DateHelper.parseDate("1/1/2011");
		Date dtB = DateHelper.parseDate("1/10/2011");
		Date dtC = DateHelper.parseDate("1/11/2011");
		Date dtD = DateHelper.parseDate("1/12/2011");
		Date dtE = DateHelper.parseDate("1/20/2011");

		DietDataLayer dao = new DietDataLayerMock();
		DietEntries meals = dao.getDietEntries(patientId);
		assertEquals(0, meals.size());

		DietEntry mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		mealEntry.setEntryDate(dtA);
		dao.saveDietEntry(mealEntry);

		mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		mealEntry.setEntryDate(dtB);
		dao.saveDietEntry(mealEntry);

		mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		mealEntry.setEntryDate(dtC);
		dao.saveDietEntry(mealEntry);

		mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		mealEntry.setEntryDate(dtD);
		dao.saveDietEntry(mealEntry);

		mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		mealEntry.setEntryDate(dtE);
		dao.saveDietEntry(mealEntry);

		meals = dao.getDietEntries(patientId);
		assertEquals(5, meals.size());

		DateFilter filter = DateFilterFactory.createFilterFromDate(dtB, dtD);
		meals = dao.getDietEntries(patientId, filter);
		assertEquals(3, meals.size());
	}

	@Test
	public void retieveByDay() {
		String patientId = "pat4";
		Date dtA = DateHelper.parseDate("1/1/2011");
		Date dtB = DateHelper.parseDate("1/10/2011");
		Date dtC = DateHelper.parseDate("1/11/2011");
		Date dtD = DateHelper.parseDate("1/12/2011");
		Date dtE = DateHelper.parseDate("1/20/2011");

		DietDataLayer dataLayer = new DietDataLayerMock();
		DietEntries meals = dataLayer.getDietEntries(patientId);
		assertEquals(0, meals.size());

		DietEntry mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		mealEntry.setEntryDate(dtA);
		dataLayer.saveDietEntry(mealEntry);

		mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		mealEntry.setEntryDate(dtB);
		dataLayer.saveDietEntry(mealEntry);

		mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		mealEntry.setEntryDate(dtC);
		dataLayer.saveDietEntry(mealEntry);

		mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		mealEntry.setEntryDate(dtD);
		dataLayer.saveDietEntry(mealEntry);

		mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		mealEntry.setEntryDate(dtE);
		dataLayer.saveDietEntry(mealEntry);

		mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		mealEntry.setEntryDate(dtC);
		dataLayer.saveDietEntry(mealEntry);

		mealEntry = new DietEntry();
		mealEntry.setPatientId(patientId);
		mealEntry.setEntryDate(dtC);
		dataLayer.saveDietEntry(mealEntry);

		DateFilter filter;

		dataLayer = new DietDataLayerMock();
		filter = DateFilterFactory.createEmptyFilter();
		meals = dataLayer.getDietEntries(patientId, filter);
		assertEquals(7, meals.size());

		dataLayer = new DietDataLayerMock();
		filter = DateFilterFactory.createFilterFromDate(dtC);
		meals = dataLayer.getDietEntries(patientId, filter);
		assertEquals(3, meals.size());

		dataLayer = new DietDataLayerMock();
		filter = DateFilterFactory.createFilterFromDate(dtD);
		meals = dataLayer.getDietEntries(patientId, filter);
		assertEquals(1, meals.size());
	}
}
