package com.agilex.healthcare.mobilehealthplatform.datalayer.dailyevents;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.UUID;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.event.DailyEventDataLayerExcel;
import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvents;
import com.agilex.healthcare.utility.DateHelper;

public class DailyEventDataLayerExcelTest {

	@Test
	public void readDailyEventData() {
		DailyEventDataLayerExcel dao = new DailyEventDataLayerExcel();
		DailyEvents dailyEvents = dao.getDailyEvents("D123401");
		assertNotNull(dailyEvents);
		assertTrue(dailyEvents.size() > 0);
	}

	@Test
	public void checkFirstItemPopulated() {
		DailyEventDataLayerExcel dao = new DailyEventDataLayerExcel();
		DailyEvents dailyEvents = dao.getDailyEvents("D123401");
		assertEquals("1", dailyEvents.get(0).getUniqueId());
	}

	@Test
	public void readUniqueId() {
		assertEquals("1", getDailyEvent("1").getUniqueId());
	}

	@Test
	public void readDailyEventDate() {
		assertEquals(DateHelper.parseDate("1/11/2012"), getDailyEvent("1").getEntryDate());
	}
	
	@Test
	public void readDailyEventTitle() {
		assertEquals("My dog skip", getDailyEvent("1").getTitle());
	}

	private DailyEvent getDailyEvent(String uniqueId) {
		DailyEventDataLayerExcel dao = new DailyEventDataLayerExcel();
		DailyEvents dailyEvents = dao.getDailyEvents("D123401");
		DailyEvent dailyEvent = null;
		for (DailyEvent possibleMatch : dailyEvents) {
			if (possibleMatch.getUniqueId().contentEquals(uniqueId)) {
				dailyEvent = possibleMatch;
			}
		}
		return dailyEvent;
	}
	
	@Test
	public void addAndRemoveDailyEvent() {
		DailyEventDataLayer dao = new DailyEventDataLayerExcel();
		String patientId = "pat1";
		DailyEvents dailyEvents = dao.getDailyEvents(patientId);
		assertEquals(0, dailyEvents.size());

		DailyEvent dailyEvent = new DailyEvent();
		dailyEvent.setPatientId(patientId);
		DailyEvent savedEntry = dao.saveDailyEvent(dailyEvent);

		dailyEvents = dao.getDailyEvents(patientId);
		assertEquals(1, dailyEvents.size());
		assertEquals(savedEntry.getId(), dailyEvents.get(0).getId());
		
		dao.deleteDailyEvent(dailyEvent);
		assertEquals(0, dailyEvents.size());
	}
	
	@Test 
	public void validateUpdate() {
		String patientId = generateId();
		DailyEventDataLayer dao = new DailyEventDataLayerExcel();

		DailyEvent dailyEvent = new DailyEvent();
		dailyEvent.setPatientId(patientId);
		dailyEvent.setNotes("1st");
		dailyEvent.setEntryDate(DateHelper.parseDate("1/12/2012"));
		dailyEvent.setTitle("title");
		
		DailyEvent saved = dao.saveDailyEvent(dailyEvent);
		assertNotNull(saved);
		assertEquals("1st", saved.getNotes());
		
		saved.setNotes("2nd");
		DailyEvent updated = dao.saveDailyEvent(saved);
		
		assertEquals("2nd", updated.getNotes());
	}
	
	private String generateId() {
		return UUID.randomUUID().toString();
	}
}
