package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import java.util.Date;

import org.junit.Test;
import static org.junit.Assert.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.utility.DateHelper;

public class MentalHealthAppointmentDataLayerMockTest {

	MentalHealthAppointmentDataLayer dl = new MentalHealthAppoinmentDataLayerMock();
	
	Date today = DateHelper.getToday();
	DateFilter emptyFilter = DateFilterFactory.createEmptyFilter();
	DateFilter futureFilter = DateFilterFactory.createFilterFromDate(today, DateHelper.plusDays(today, 14));
	DateFilter pastFilter = DateFilterFactory.createFilterFromDate(DateHelper.minusDays(today, (365*2)), today);

	@Test
	public void verifyGallowWithoutFilter() {
		Appointments mentalHealthAppointments = dl.fetchMentalHealthAppointments(new PatientIdentifier("EDIPI", "D123401"), DateFilterFactory.createEmptyFilter());

		assertEquals(2, mentalHealthAppointments.size());
	}

	@Test
	public void verifyGallowFutureFilter() {
		Appointments mentalHealthAppointments = dl.fetchMentalHealthAppointments(new PatientIdentifier("EDIPI", "D123401"), futureFilter);

		assertEquals(1, mentalHealthAppointments.size());
	}

	@Test
	public void verifyGallowPastFilter() {
		Appointments mentalHealthAppointments = dl.fetchMentalHealthAppointments(new PatientIdentifier("EDIPI", "D123401"), pastFilter);

		assertEquals(1, mentalHealthAppointments.size());
	}

	@Test
	public void verifyUsabilityTestPatientPastFilter() {
		Appointments mentalHealthAppointments = dl.fetchMentalHealthAppointments(new PatientIdentifier("EDIPI", "PATID65"), pastFilter);

		assertEquals(1, mentalHealthAppointments.size());
	}

	@Test
	public void verifyUsabilityTestPatientFutureFilter() {
		Appointments mentalHealthAppointments = dl.fetchMentalHealthAppointments(new PatientIdentifier("EDIPI", "PATID65"), futureFilter);

		assertEquals(0, mentalHealthAppointments.size());
	}
	
	@Test
	public void verifyAldiePastFilter() {
		Appointments mentalHealthAppointments = dl.fetchMentalHealthAppointments(new PatientIdentifier("EDIPI", "PATID26"), pastFilter);

		assertEquals(0, mentalHealthAppointments.size());
	}
	
	@Test
	public void verifyAldieWithFutureFilter() {
		Appointments mentalHealthAppointments = dl.fetchMentalHealthAppointments(new PatientIdentifier("EDIPI", "PATID26"), futureFilter);

		assertEquals(1, mentalHealthAppointments.size());
	}
	
	
}
