package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.Set;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.DetailCode;

public class DetailCodeDataLayerExcelTest {
	private DetailCodeDataLayerExcel dataLayer = new DetailCodeDataLayerExcel();
	private Set<DetailCode> detailCodes;
	
	public DetailCodeDataLayerExcelTest() {
		detailCodes = dataLayer.fetchDetailCodes();
	}
	
	@Test
	public void validateNumberOFDetailCodes() {
		assertEquals(11, detailCodes.size());
	}
	
	@Test
	public void validateDetailCodes(){
		for (DetailCode detailCode : detailCodes) {
			assertNotNull(detailCode.getCode());
			assertNotNull(detailCode.getProviderMessage());
			assertNotNull(detailCode.getVeteranMessage());
		}
	}
	
	@Test
	public void confirmGetDetailCodeByCode() throws Exception {
		DetailCode expected = new DetailCode();
		expected.setCode("DETCODE8");
		expected.setProviderMessage("Cancelled by Veteran - Pending");
		expected.setVeteranMessage("Your request to cancel this appointment has been sent."); 
		
		DetailCode fetchedDetailCode = dataLayer.fetchDetailCodeByCode(expected.getCode());
		assertNotNull(fetchedDetailCode);
		assertEquals(expected.getCode(), fetchedDetailCode.getCode());
		assertEquals(expected.getVeteranMessage(), fetchedDetailCode.getVeteranMessage());
		assertEquals(expected.getProviderMessage(), fetchedDetailCode.getProviderMessage());
	}
}
