package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import junit.framework.Assert;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class ClinicalNoteDataLayerExcelTest {

	@Test
	public void validateRetrievalValidClinicalVisitId() {
		PatientIdentifier patientIdentifier = new PatientIdentifier("mock-aa", "D123401");
		ClinicalNoteDataLayer dl = new ClinicalNoteDataLayerExcel();
		
		ProviderNote clinicalNote = dl.fetchClinicalNote(patientIdentifier, "21");
		
		Assert.assertNotNull(clinicalNote);
	}
	
	@Test
	public void validateRetrievalInvalidClinicalVisitId() {
		PatientIdentifier patientIdentifier = new PatientIdentifier("mock-aa", "D123401");
		ClinicalNoteDataLayer dl = new ClinicalNoteDataLayerExcel();
		
		ProviderNote clinicalNote = dl.fetchClinicalNote(patientIdentifier, "20");
		
		Assert.assertNull(clinicalNote);
	}
}
