package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import java.util.UUID;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestInProcess;

public class AppointmentRequestInProcessDataLayerMockTest {

	AppointmentRequestInProcessDataLayerMock dataLayer = new AppointmentRequestInProcessDataLayerMock();
	
	@Test
 	public void testSaveAppointmentRequestInProcess() {
		AppointmentRequestInProcess arInProcess = createSampleAppointmentRequestInProcess();
		
		AppointmentRequestInProcess savedRequest = dataLayer.saveAppointmentRequestInProcess(arInProcess);
		
		assertAppointmentRequestInProcess(arInProcess, savedRequest);
	}

	private void assertAppointmentRequestInProcess(AppointmentRequestInProcess arInProcess,
			AppointmentRequestInProcess savedRequest) {
		assertEquals(arInProcess.getAppointmentRequestId(), savedRequest.getAppointmentRequestId());
		assertEquals(arInProcess.getUserId(), savedRequest.getUserId());
		assertEquals(arInProcess.getFirstName(), savedRequest.getFirstName());
		assertEquals(arInProcess.getLastName(), savedRequest.getLastName());
	}
	
	@Test
	public void validateRetrievalOfAppointmentRequestInProcessById(){
		AppointmentRequestInProcess arInProcess = createSampleAppointmentRequestInProcess();
		dataLayer.saveAppointmentRequestInProcess(arInProcess);
		
		AppointmentRequestInProcess retrievedARInProcess = dataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(arInProcess.getAppointmentRequestId());

		assertAppointmentRequestInProcess(arInProcess, retrievedARInProcess);
	}

	@Test
	public void validateDeletionOfAppointmentRequestInProcessById(){
		AppointmentRequestInProcess arInProcess = createSampleAppointmentRequestInProcess();
		dataLayer.saveAppointmentRequestInProcess(arInProcess);

		dataLayer.deleteAppointmentRequestInProcessById(arInProcess.getAppointmentRequestId());
		AppointmentRequestInProcess retrievedARInProcess = dataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(arInProcess.getAppointmentRequestId());
		
		assertNull(retrievedARInProcess);
	}
	

	@Test
	public void validateDeletionOfAppointmentRequestsInProcessByUserId(){
		AppointmentRequestInProcess arInProcess1 = createSampleAppointmentRequestInProcess();
		AppointmentRequestInProcess arInProcess2 = createSampleAppointmentRequestInProcess();
		
		dataLayer.saveAppointmentRequestInProcess(arInProcess1);
		dataLayer.saveAppointmentRequestInProcess(arInProcess2);

		dataLayer.deleteAppointmentRequestInProcessByUserId(arInProcess1.getUserId());
		AppointmentRequestInProcess retrievedARInProcess1 = dataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(arInProcess1.getAppointmentRequestId());
		AppointmentRequestInProcess retrievedARInProcess2 = dataLayer.fetchAppointmentRequestInProcessByAppointmentRequestId(arInProcess2.getAppointmentRequestId());
		
		assertNull(retrievedARInProcess1);
		assertNull(retrievedARInProcess2);

	}
	

	private AppointmentRequestInProcess createSampleAppointmentRequestInProcess() {
		String appointmentRequestId = UUID.randomUUID().toString();
		AppointmentRequestInProcess arInProcess = new AppointmentRequestInProcess();
		arInProcess.setAppointmentRequestId(appointmentRequestId);
		arInProcess.setUserId("zztest.staff01");
		arInProcess.setFirstName("zztest");
		arInProcess.setLastName("staff01");
		return arInProcess;
	}
	
	

}
