package com.agilex.healthcare.mobilehealthplatform.datalayer.allergy;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.utility.DateHelper;

public class AllergyDataLayerExcelTest {

	private AllergyDataLayerExcel dataLayer;
	private String PATIENTID = "D123401";
	private String UNIQUEID = "t2";
	
	@Before
	public void setup() {
		dataLayer = new AllergyDataLayerExcel();
	}

	@Test
	public void validateAllergiesAreReturnedForYounger() {
		Allergies allergies = dataLayer.getPatientAllergies(PATIENTID);
		assertTrue(allergies.size() > 0);
		
	}

	@Test
	public void validateGetPatientAllergyLite() {
		Allergy allergy = dataLayer.getPatientAllergyLite(PATIENTID, UNIQUEID);
		assertEquals("t2",allergy.getUniqueId());
	}
	
	@Test
	public void validateSourceSys() {		
		Allergy allergy = dataLayer.getPatientAllergyLite(PATIENTID, UNIQUEID);
		assertEquals("OTHER",allergy.getSourceSystem());
	}

	@Test
	public void validateActive() {
		Allergy allergy = dataLayer.getPatientAllergyLite(PATIENTID, UNIQUEID);
		assertEquals(true,allergy.isActive());		
	}
	
	@Test
	public void validateCategory() {
		Allergy allergy = dataLayer.getPatientAllergyLite(PATIENTID, UNIQUEID);
		assertEquals("Drug allergy",allergy.getCategory());		
	}

	@Test
	public void validateOnsetDate() {
		Allergy allergy = dataLayer.getPatientAllergyLite(PATIENTID, UNIQUEID);
		assertEquals(DateHelper.parseDate("1/2/2002"),allergy.getOnsetDate());				
	}

	@Test
	public void validateReaction() {
		Allergy allergy = dataLayer.getPatientAllergyLite(PATIENTID, UNIQUEID);
		assertEquals("Rash",allergy.getReaction());				
	}

	@Test
	public void validateResolutionDate() {
		Allergy allergy = dataLayer.getPatientAllergyLite(PATIENTID, UNIQUEID);
		assertEquals(DateHelper.parseDate("1/2/2002"),allergy.getResolutionDate());				
	}
	
	@Test
	public void validateSeverity() {
		Allergy allergy = dataLayer.getPatientAllergyLite(PATIENTID, UNIQUEID);
		assertEquals("Severe",allergy.getSeverity());						
	}
	
	@Test
	public void validateSubstance() {
		Allergy allergy = dataLayer.getPatientAllergyLite(PATIENTID, UNIQUEID);
		assertEquals("Penicillin",allergy.getSubstance());								
	}
	
	@Test
	public void validateNote() {
		Allergy allergy = dataLayer.getPatientAllergyLite(PATIENTID, UNIQUEID);
		assertEquals("text",allergy.getNote());										
	}

	@Test
	public void validateZeroAllergiesAreReturnedForXYZ() {
		String patientId = "XYZ";
		Allergies allergies = dataLayer.getPatientAllergies(patientId);
		assertEquals(0, allergies.size());
	}

	@Test
	public void validateZeroAllergiesAreReturnedForNull() {
		String patientId = null;
		Allergies allergies = dataLayer.getPatientAllergies(patientId);
		assertEquals(0, allergies.size());
	}

	@Test
	public void validateAllergyDataIsNullForInvalidOrderNumber() {
		String orderNumber = "saf";
		Allergy retrievedAllergy = dataLayer.getPatientAllergyLite(PATIENTID, orderNumber);
		assertNull(retrievedAllergy);
	}

	@Test
	public void validateAllergyDataIsNullForInvalidPatientNumber() {
		String patientId = "D123401asf";
		String orderNumber = "saf";
		Allergy retrievedAllergy = dataLayer.getPatientAllergyLite(patientId, orderNumber);
		assertNull(retrievedAllergy);
	}
}
