package com.agilex.healthcare.mobilehealthplatform.datalayer.admission;

import junit.framework.Assert;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;

public class DischargeNoteDataLayerExcelTest {
	
	DischargeNoteDataLayer dl = new DischargeNoteDataLayerExcel();
	
	@Test
	public void verifyValidRetrieval() {
		PatientIdentifier patientIdentifier = new PatientIdentifier("", "D123401");
		DateFilter dateFilter = DateFilterFactory.createFilterFromDate("06/01/2011", "07/02/2011");
		
		ProviderNote dischargeNote = dl.fetchDischargeNote(patientIdentifier, dateFilter);
		Assert.assertNotNull(dischargeNote);
		Assert.assertTrue(dischargeNote.getText().startsWith("DISCHARGE DIAGNOSIS:  Atypical chest pain"));
	}
	
	@Test
	public void verifyRetrievalWithoutNotes() {
		PatientIdentifier patientIdentifier = new PatientIdentifier("", "invalid-id");
		
		DateFilter dateFilter = DateFilterFactory.createEmptyFilter();
		
		ProviderNote dischargeNote = dl.fetchDischargeNote(patientIdentifier, dateFilter);
		Assert.assertNull(dischargeNote);
	}
}
