package com.agilex.healthcare.mobilehealthplatform.datalayer.admission;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Admission;
import com.agilex.healthcare.mobilehealthplatform.domain.Admissions;
import com.agilex.healthcare.utility.DateHelper;

public class AdmissionDataLayerExcelTest {

	private static final String PATIENT_WITH_NO_DATA = "invalid";
	private static final String TESTPATIENT = "PATID40";

	@Test
	public void readAdmissionData() {
		AdmissionDataLayer dao = new AdmissionDataLayerExcel();
		Admissions admissions = dao.getAdmissions(TESTPATIENT, null, false);
		assertNotNull(admissions);
		assertTrue(admissions.size() > 0);
	}

	@Test
	public void readAdmissionDataNoDataFound() {
		AdmissionDataLayer dao = new AdmissionDataLayerExcel();
		Admissions admissions = dao.getAdmissions(PATIENT_WITH_NO_DATA, null, false);
		assertNotNull(admissions);
		assertEquals(0, admissions.size());
	}

	@Test
	public void checkFirstItemPopulated() {
		AdmissionDataLayer dao = new AdmissionDataLayerExcel();
		Admissions admissions = dao.getAdmissions(TESTPATIENT, null, false);
		assertEquals("1", admissions.get(0).getUniqueId());
	}

	@Test
	public void readUniqueId() {
		assertEquals("1", getAdmission("1").getUniqueId());
	}

	@Test
	public void readAdmissionDate() {
		assertEquals(DateHelper.parseDate("1/1/2011"), getAdmission("1").getAdmissionDate());
	}

	@Test
	public void readDischargeDate() {
		assertEquals(DateHelper.parseDate("1/7/2011"), getAdmission("1").getDischargeDate());
	}

	@Test
	public void readFacilityName() {
		assertEquals("DCVAMC", getAdmission("1").getFacilityName());
	}

	@Test
	public void readProvider() {
		assertEquals("DR. DCVAMC", getAdmission("1").getAdmittingProviderName());
	}

	private Admission getAdmission(String uniqueId) {
		AdmissionDataLayerExcel dao = new AdmissionDataLayerExcel();
		Admissions admissions = dao.getAdmissions(TESTPATIENT, null, false);
		Admission admission = null;
		for (Admission possibleMatch : admissions) {
			if (possibleMatch.getUniqueId().contentEquals(uniqueId)) {
				admission = possibleMatch;
			}
		}
		return admission;
	}
}
