package com.agilex.healthcare.mobilehealthplatform.patientcorrelation;

import java.util.Set;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.utility.collections.MutualAssocationMap;

public class PatientCorrelationProviderTestMock implements PatientCorrelationService {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(PatientCorrelationProviderTestMock.class);

	private static final String DCVAMC_AA = "dfn-688";
	private static final String CHICAGO_AA = "dfn-537";
	private static final String PALO_ALTO_AA = "dfn-640";
	private static final String CHILLICOTHE_AA = "dfn-538";	
	private static final String SITE_500_AA = "dfn-500";
	private static final String EDIPI = "EDIPI";
	private static final String ICN = "ICN";
	
	// Gallow Younger Identifiers
	public final static PatientIdentifier GallowYounger_DCVista_PI = new PatientIdentifier(DCVAMC_AA, "100844");
	public static final PatientIdentifier GallowYounger_Cdw_PI = new PatientIdentifier(ICN, "D123401");
	public static final PatientIdentifier GallowYounger_EDIPI_PI = new PatientIdentifier(EDIPI, "D123401");

	// Aldie       Identifiers
	public final static PatientIdentifier Aldie     _DCVista_PI = new PatientIdentifier(DCVAMC_AA, "PATID26");
	public static final PatientIdentifier Aldie     _Cdw_PI = new PatientIdentifier(ICN, "PATID26");
	public static final PatientIdentifier Aldie     _EDIPI_PI = new PatientIdentifier(EDIPI, "PATID26");
	
	// Mary-Kate       Identifiers
	public final static PatientIdentifier MaryKate     _DCVista_PI = new PatientIdentifier(DCVAMC_AA, "100845");
	public static final PatientIdentifier MaryKate     _Cdw_PI = new PatientIdentifier(ICN, "PATID37");
	public static final PatientIdentifier MaryKate     _EDIPI_PI = new PatientIdentifier(EDIPI, "PATID37");
	
	// Jones-      Mirka Identifiers
	public final static PatientIdentifier Jones     Mirka_DCVista_PI = new PatientIdentifier(DCVAMC_AA, "100846");
	public static final PatientIdentifier Jones     Mirka_Cdw_PI = new PatientIdentifier(ICN, "PATID49");
	public static final PatientIdentifier Jones     Mirka_EDIPI_PI = new PatientIdentifier(EDIPI, "PATID49");
	
	// ROGER,ANN MARIE Identifiers
	public final static PatientIdentifier AnnMarie     _500Vista_PI = new PatientIdentifier(SITE_500_AA, "100847");
	public static final PatientIdentifier AnnMarie     _Cdw_PI = new PatientIdentifier(ICN, "PATID47");
	public static final PatientIdentifier AnnMarie     _EDIPI_PI = new PatientIdentifier(EDIPI, "PATID47");	
	
	// One,Image Patient Identifiers
	public final static PatientIdentifier ImagePatientOne_500Vista_PI = new PatientIdentifier(SITE_500_AA, "100809");
	public static final PatientIdentifier ImagePatientOne_Cdw_PI = new PatientIdentifier(ICN, "PATID82");
	public static final PatientIdentifier ImagePatientOne_EDIPI_PI = new PatientIdentifier(EDIPI, "PATID82");		
	
	// HEALTHY,PATIENT Identifiers
	public final static PatientIdentifier PatientHealthy_ChicagoVista_PI = new PatientIdentifier(CHICAGO_AA, "100841");
	public static final PatientIdentifier PatientHealthy_Cdw_PI = new PatientIdentifier(ICN, "PATID83");
	public static final PatientIdentifier PatientHealthy_EDIPI_PI = new PatientIdentifier(EDIPI, "PATID83");	
	
	// One,OutPatient Identifiers
	public final static PatientIdentifier OutPatientOne_ChicagoVista_PI = new PatientIdentifier(CHICAGO_AA, "100608");
	public static final PatientIdentifier OutPatientOne_Cdw_PI = new PatientIdentifier(ICN, "PATID84");
	public static final PatientIdentifier OutPatientOne_EDIPI_PI = new PatientIdentifier(EDIPI, "PATID84");		

	// Ill,Patient Identifiers
	public final static PatientIdentifier PatientIll_ChillicotheVista_PI = new PatientIdentifier(CHILLICOTHE_AA, "100842");
	public static final PatientIdentifier PatientIll_Cdw_PI = new PatientIdentifier(ICN, "PATID85");
	public static final PatientIdentifier PatientIll_EDIPI_PI = new PatientIdentifier(EDIPI, "PATID85");	
	
	// One,InPatient Identifiers
	public final static PatientIdentifier InPatientOne_ChillicotheVista_PI = new PatientIdentifier(CHILLICOTHE_AA, "100708");
	public static final PatientIdentifier InPatientOne_Cdw_PI = new PatientIdentifier(ICN, "PATID86");
	public static final PatientIdentifier InPatientOne_EDIPI_PI = new PatientIdentifier(EDIPI, "PATID86");	
		
	// VeryIll,Patient Identifiers
	public final static PatientIdentifier PatientVeryIll_PaloAltoVista_PI = new PatientIdentifier(PALO_ALTO_AA, "100843");
	public static final PatientIdentifier PatientVeryIll_Cdw_PI = new PatientIdentifier(ICN, "PATID87");
	public static final PatientIdentifier PatientVeryIll_EDIPI_PI = new PatientIdentifier(EDIPI, "PATID487");
	
	// EIGHT,BCMA Identifiers
	public final static PatientIdentifier BcmaEight_PaloAltoVista_PI = new PatientIdentifier(PALO_ALTO_AA, "100022");
	public static final PatientIdentifier BcmaEight_Cdw_PI = new PatientIdentifier(ICN, "PATID88");
	public static final PatientIdentifier BcmaEight_EDIPI_PI = new PatientIdentifier(EDIPI, "PATID88");		
	
	// VAMOBILEPATIENT,ONE Identifiers
	public final static PatientIdentifier OneVAMobilePatient_DCVista_PI = new PatientIdentifier(DCVAMC_AA, "100848");
	public static final PatientIdentifier OneVAMobilePatient_Cdw_PI = new PatientIdentifier(ICN, "0010010010");
	public static final PatientIdentifier OneVAMobilePatient_EDIPI_PI = new PatientIdentifier(EDIPI, "0010010010");
	
	
	MutualAssocationMap<PatientIdentifier> map = new MutualAssocationMap<PatientIdentifier>();
	
	public PatientCorrelationProviderTestMock() {
		addMockData();
	}

	private void addMockData() {

		// Gallow Younger assignments
		associateValues(GallowYounger_EDIPI_PI, GallowYounger_DCVista_PI);
		associateValues(GallowYounger_EDIPI_PI, GallowYounger_Cdw_PI);
		associateValues(GallowYounger_Cdw_PI, GallowYounger_DCVista_PI);

		// Aldie       assignments
		associateValues(Aldie     _EDIPI_PI, Aldie     _DCVista_PI);
		associateValues(Aldie     _EDIPI_PI, Aldie     _Cdw_PI);
		associateValues(Aldie     _Cdw_PI, Aldie     _DCVista_PI);
	
		// Mary-Kate       assignments
		associateValues(MaryKate     _EDIPI_PI, MaryKate     _DCVista_PI);
		associateValues(MaryKate     _EDIPI_PI, MaryKate     _Cdw_PI);
		associateValues(MaryKate     _Cdw_PI, MaryKate     _DCVista_PI);
		
		// Jones-      Mirka assignments
		associateValues(Jones     Mirka_EDIPI_PI, Jones     Mirka_DCVista_PI);
		associateValues(Jones     Mirka_EDIPI_PI, Jones     Mirka_Cdw_PI);
		associateValues(Jones     Mirka_Cdw_PI, Jones     Mirka_DCVista_PI);

		// ROGER,ANN MARIE assignments
		associateValues(AnnMarie     _EDIPI_PI, AnnMarie     _500Vista_PI);
		associateValues(AnnMarie     _EDIPI_PI, AnnMarie     _Cdw_PI);
		associateValues(Jones     Mirka_Cdw_PI, AnnMarie     _500Vista_PI);

		// One,Image Patient assignments
		associateValues(ImagePatientOne_EDIPI_PI, ImagePatientOne_500Vista_PI);
		associateValues(ImagePatientOne_EDIPI_PI, ImagePatientOne_Cdw_PI);
		associateValues(ImagePatientOne_Cdw_PI, ImagePatientOne_500Vista_PI);

		// HEALTHY,PATIENT assignments
		associateValues(PatientHealthy_EDIPI_PI, PatientHealthy_ChicagoVista_PI);
		associateValues(PatientHealthy_EDIPI_PI, PatientHealthy_Cdw_PI);
		associateValues(PatientHealthy_Cdw_PI, PatientHealthy_ChicagoVista_PI);

		// One,OutPatient assignments
		associateValues(OutPatientOne_EDIPI_PI, OutPatientOne_ChicagoVista_PI);
		associateValues(OutPatientOne_EDIPI_PI, OutPatientOne_Cdw_PI);
		associateValues(OutPatientOne_Cdw_PI, OutPatientOne_ChicagoVista_PI);

		// Ill,Patient assignments
		associateValues(PatientIll_EDIPI_PI, PatientIll_ChillicotheVista_PI);
		associateValues(PatientIll_EDIPI_PI, PatientIll_Cdw_PI);
		associateValues(PatientIll_Cdw_PI, PatientIll_ChillicotheVista_PI);

		// One,InPatient assignments
		associateValues(InPatientOne_EDIPI_PI, InPatientOne_ChillicotheVista_PI);
		associateValues(InPatientOne_EDIPI_PI, InPatientOne_Cdw_PI);
		associateValues(InPatientOne_Cdw_PI, InPatientOne_ChillicotheVista_PI);

		// VeryIll,Patient assignments
		associateValues(PatientVeryIll_EDIPI_PI, PatientVeryIll_PaloAltoVista_PI);
		associateValues(PatientVeryIll_EDIPI_PI, PatientVeryIll_Cdw_PI);
		associateValues(PatientVeryIll_Cdw_PI, PatientVeryIll_PaloAltoVista_PI);

		// Eight,BCMA assignments
		associateValues(BcmaEight_EDIPI_PI, BcmaEight_PaloAltoVista_PI);
		associateValues(BcmaEight_EDIPI_PI, BcmaEight_Cdw_PI);
		associateValues(BcmaEight_Cdw_PI, BcmaEight_PaloAltoVista_PI);

		// VAMOBILEPATIENT,ONE assignments
		associateValues(OneVAMobilePatient_EDIPI_PI, OneVAMobilePatient_Cdw_PI);
		associateValues(OneVAMobilePatient_Cdw_PI, OneVAMobilePatient_DCVista_PI);
		associateValues(OneVAMobilePatient_DCVista_PI, OneVAMobilePatient_EDIPI_PI);
        
		
		String[] multiSiteUserIds = { "PATID58", "PATID59", "PATID60", "PATID61", "PATID62", "PATID63", "PATID64", "PATID65", "PATID66", "PATID67", "PATID68", "PATID69", "PATID70", "PATID71",
				"PATID72", "PATID73", "PATID74", "PATID75", "PATID76", "PATID78", "0010010011" };

		for (String multiSiteUserId : multiSiteUserIds) {
			associateValues(EDIPI, multiSiteUserId, DCVAMC_AA, multiSiteUserId);
			associateValues(EDIPI, multiSiteUserId, CHICAGO_AA, "CH" + multiSiteUserId);
			associateValues(EDIPI, multiSiteUserId, CHILLICOTHE_AA, "CHI" + multiSiteUserId);
			associateValues(EDIPI, multiSiteUserId, PALO_ALTO_AA, "PA" + multiSiteUserId);
			associateValues(EDIPI, multiSiteUserId, ICN, multiSiteUserId);
			associateValues(ICN, multiSiteUserId, DCVAMC_AA, multiSiteUserId);
			associateValues(ICN, multiSiteUserId, CHICAGO_AA, "CH" + multiSiteUserId);
			associateValues(ICN, multiSiteUserId, CHILLICOTHE_AA, "CHI" + multiSiteUserId);
			associateValues(ICN, multiSiteUserId, PALO_ALTO_AA, "PA" + multiSiteUserId);
		}

		String[] dcSiteUserIds = {"PATID0", "PATID1", "PATID2", "PATID3", "PATID4", "PATID5", "PATID6", "PATID7", "PATID8", "PATID9", "PATID10", "PATID11", "PATID12", "PATID13", "PATID14", "PATID15", "PATID16", "PATID17",
				"PATID18", "PATID19", "PATID20", "PATID21", "PATID22", "PATID23", "PATID24", "PATID25", "PATID27", "PATID28", "PATID29", "PATID30", "PATID31", "PATID32", "PATID33", "PATID34",
				"PATID35", "PATID36", "PATID37", "PATID38", "PATID39", "PATID40", "PATID41", "PATID42", "PATID43", "PATID44", "PATID45", "PATID46", "PATID47", "PATID48", "PATID49", "PATID50",
				"PATID51", "PATID52", "PATID53", "PATID54", "PATID55", "PATID56", "PATID57", "PATID58" };
		for (String dcSiteUserId : dcSiteUserIds) {
			associateValues(EDIPI, dcSiteUserId, DCVAMC_AA, dcSiteUserId);
			associateValues(ICN, dcSiteUserId, DCVAMC_AA, dcSiteUserId);
		}
		String[] appTestGroupUserIds = { "TSTGRP01", "TSTGRP02", "TSTGRP03", "TSTGRP04", "TSTGRP05", "TSTGRP06", "TSTGRP07", "TSTGRP08", "TSTGRP09", "TSTGRP10", "TSTGRP11", "TSTGRP12" };

		for (String appTestGroupUserId : appTestGroupUserIds) {
			associateValues(EDIPI, appTestGroupUserId, DCVAMC_AA, appTestGroupUserId);
			associateValues(EDIPI, appTestGroupUserId, CHICAGO_AA, "CH" + appTestGroupUserId);
			associateValues(EDIPI, appTestGroupUserId, CHILLICOTHE_AA, "CHI" + appTestGroupUserId);
			associateValues(EDIPI, appTestGroupUserId, PALO_ALTO_AA, "PA" + appTestGroupUserId);
			associateValues(EDIPI, appTestGroupUserId, ICN, appTestGroupUserId);
			associateValues(ICN, appTestGroupUserId, DCVAMC_AA, appTestGroupUserId);
			associateValues(ICN, appTestGroupUserId, CHICAGO_AA, "CH" + appTestGroupUserId);
			associateValues(ICN, appTestGroupUserId, CHILLICOTHE_AA, "CHI" + appTestGroupUserId);
			associateValues(ICN, appTestGroupUserId, PALO_ALTO_AA, "PA" + appTestGroupUserId);
		}
		
	}

	public void associateValues(PatientIdentifier patientIdentifier1, PatientIdentifier patientIdentifier2) {
		associateValues(patientIdentifier1.getAssigningAuthority(), patientIdentifier1.getUniqueId(), patientIdentifier2.getAssigningAuthority(), patientIdentifier2.getUniqueId());
	}

	public void associateValues(String assigningAuthority1, String patientId1, String assigningAuthority2, String patientId2) {
		PatientIdentifier patientIdentifier1 = new PatientIdentifier(assigningAuthority1, patientId1);
		PatientIdentifier patientIdentifier2 = new PatientIdentifier(assigningAuthority2, patientId2);
		map.associateValues(patientIdentifier1, patientIdentifier2);
	}

	@Override
	public PatientIdentifiers getCorrespondIdentifiers(PatientIdentifier patientIdentifier, String targetAssigningAuthority) {
		PatientIdentifiers filteredPatientIdentifiers = new PatientIdentifiers();
		for (PatientIdentifier possibleMatch : getCorrespondIdentifiers(patientIdentifier)) {
			if (possibleMatch.getAssigningAuthority().toLowerCase().contains(targetAssigningAuthority.toLowerCase())) {
				filteredPatientIdentifiers.add(possibleMatch);
			}
		}

		return filteredPatientIdentifiers;
	}

	@Override
	public PatientIdentifiers getCorrespondIdentifiers(PatientIdentifier patientIdentifier) {
		Set<PatientIdentifier> setOfIdentifiers = map.get(patientIdentifier);
		PatientIdentifiers identifiers = PatientIdentifiers.fromSet(setOfIdentifiers);
		identifiers.add(patientIdentifier);
		logger.debug(String.format("found %s identifiers associated with %s", identifiers.size(), patientIdentifier));
		return identifiers;
	}
	
}
