package com.agilex.healthcare.mobilehealthplatform.patientcorrelation;

import java.util.Set;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.utility.collections.MutualAssocationMap;

public class PatientCorrelationMock implements PatientCorrelationService {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(PatientCorrelationMock.class);

	private static final String DCVAMC_AA = "dfn-688";
	private static final String CHICAGO_AA = "dfn-537";
	private static final String PALO_ALTO_AA = "dfn-640";
	private static final String CHILLICOTHE_AA = "dfn-538";
	private static final String EDIPI = "EDIPI";
	private static final String ICN = "ICN";

	// zztest.patient01 Identifiers
	public final static PatientIdentifier patient01_DCVista_PI = new PatientIdentifier(DCVAMC_AA, "D123401");
	public final static PatientIdentifier patient01_Chicago_PI = new PatientIdentifier(CHICAGO_AA, "C123401");
	public final static PatientIdentifier patient01_PaloAlto_PI = new PatientIdentifier(PALO_ALTO_AA, "P123401");
	public final static PatientIdentifier patient01_Chillicothe_PI = new PatientIdentifier(CHILLICOTHE_AA, "CH123401");
    public static final PatientIdentifier patient01_Cdw_PI = new PatientIdentifier(ICN, "D123401");
    public static final PatientIdentifier patient01_Integration_Cdw_PI = new PatientIdentifier(ICN, "1011491687V123456");
//	public static final PatientIdentifier patient01_Cdw_PI_MentalHealthProviders = new PatientIdentifier(ICN, "1011491687V123456");
//	public static final PatientIdentifier patient01_Cdw_PI_PrimartyCareProviders = new PatientIdentifier(ICN, "1004893470v123456");
	public static final PatientIdentifier patient01_EDIPI_PI = new PatientIdentifier(EDIPI, "D123401");

	// zztest.patient26 identifiers
	public final static PatientIdentifier patient26_DCVista_PI = new PatientIdentifier(DCVAMC_AA, "PATID26");
	public final static PatientIdentifier patient26_Chicago_PI = new PatientIdentifier(CHICAGO_AA, "PATID26C");
	public final static PatientIdentifier patient26_PaloAlto_PI = new PatientIdentifier(PALO_ALTO_AA, "PATID26P");
	public final static PatientIdentifier patient26_Chillicothe_PI = new PatientIdentifier(CHILLICOTHE_AA, "PATID26CH");
	public static final PatientIdentifier patient26_Cdw_PI = new PatientIdentifier(ICN, "PATID26");
	public static final PatientIdentifier patient26_EDIPI_PI = new PatientIdentifier(EDIPI, "PATID26");
	
	public final static PatientIdentifier MKate     _DCVista_PI = new PatientIdentifier(DCVAMC_AA, "M123401");
	public static final PatientIdentifier MKate     _EDIPI_PI = new PatientIdentifier(EDIPI, "M123401");
	public static final PatientIdentifier MKate     _Cdw_PI = new PatientIdentifier(ICN, "M123401");

	public final static PatientIdentifier HealthyEnterprisePatientIdentifier = new PatientIdentifier("EDIPI", "healthy");

	public static final PatientIdentifier GallowEnterprisePatientIdentifier = new PatientIdentifier(EDIPI, "D123401");

	public static final PatientIdentifier GallowMockPatientIdentifier = new PatientIdentifier(EDIPI, "D123401");;

	public static final PatientIdentifier ResourceTestEDIPIIdentifier = new PatientIdentifier(EDIPI, "INT-TEST-MOCK");
	public static final PatientIdentifier ResourceTestICNIdentifier = new PatientIdentifier(ICN, "INT-TEST-MOCK");

	public static final PatientIdentifier ResourceTestEDIPIIdentifierNoData = new PatientIdentifier(EDIPI, "NO-DATA-MOCK");
	public static final PatientIdentifier ResourceTestICNIdentifierNoData = new PatientIdentifier(ICN, "NO-DATA-MOCK");

	MutualAssocationMap<PatientIdentifier> map = new MutualAssocationMap<PatientIdentifier>();

	public PatientCorrelationMock() {
		addMockData();
	}

	private void addMockData() {
		// Mappings for Integrationt tests
		associateValues(ResourceTestEDIPIIdentifier, ResourceTestEDIPIIdentifier);
		associateValues(ResourceTestEDIPIIdentifier, ResourceTestICNIdentifier);

		associateValues(ResourceTestEDIPIIdentifierNoData, ResourceTestEDIPIIdentifierNoData);
		associateValues(ResourceTestEDIPIIdentifierNoData, ResourceTestICNIdentifierNoData);

        // Patient 01 assignments
        associateValues(patient01_EDIPI_PI, patient01_EDIPI_PI);
        associateValues(patient01_EDIPI_PI, patient01_DCVista_PI);
        associateValues(patient01_EDIPI_PI, patient01_Chicago_PI);
        associateValues(patient01_EDIPI_PI, patient01_Chillicothe_PI);
        associateValues(patient01_EDIPI_PI, patient01_PaloAlto_PI);
        associateValues(patient01_EDIPI_PI, patient01_Cdw_PI);
        associateValues(patient01_EDIPI_PI, patient01_Integration_Cdw_PI);
        associateValues(patient01_Cdw_PI, patient01_DCVista_PI);
        associateValues(patient01_Cdw_PI, patient01_Chicago_PI);
        associateValues(patient01_Cdw_PI, patient01_Chillicothe_PI);
        associateValues(patient01_Cdw_PI, patient01_PaloAlto_PI);


		associateValues(patient26_EDIPI_PI, patient26_DCVista_PI);
		associateValues(patient26_EDIPI_PI, patient26_Chicago_PI);
		associateValues(patient26_EDIPI_PI, patient26_Chillicothe_PI);
		associateValues(patient26_EDIPI_PI, patient26_PaloAlto_PI);
		associateValues(patient26_EDIPI_PI, patient26_Cdw_PI);
		associateValues(patient26_Cdw_PI, patient26_DCVista_PI);
		associateValues(patient26_Cdw_PI, patient26_Chicago_PI);
		associateValues(patient26_Cdw_PI, patient26_Chillicothe_PI);
		associateValues(patient26_Cdw_PI, patient26_PaloAlto_PI);

		associateValues(MKate     _EDIPI_PI, MKate     _EDIPI_PI);
		associateValues(MKate     _EDIPI_PI, MKate     _DCVista_PI);
		associateValues(MKate     _EDIPI_PI, MKate     _Cdw_PI);
		associateValues(MKate     _Cdw_PI, MKate     _DCVista_PI);
	
		String[] multiSiteUserIds = { "PATID58", "PATID59", "PATID60", "PATID61", "PATID62", "PATID63", "PATID64", "PATID65", "PATID66", "PATID67", "PATID68", "PATID69", "PATID70", "PATID71",
				"PATID72", "PATID73", "PATID74", "PATID75", "PATID76", "PATID78", "0010010010", "0010010011", "0010010012", "0010010013" };

		for (String multiSiteUserId : multiSiteUserIds) {
			associateValues(EDIPI, multiSiteUserId, EDIPI, multiSiteUserId);
			associateValues(EDIPI, multiSiteUserId, DCVAMC_AA, multiSiteUserId);
			associateValues(EDIPI, multiSiteUserId, CHICAGO_AA, "CH" + multiSiteUserId);
			associateValues(EDIPI, multiSiteUserId, CHILLICOTHE_AA, "CHI" + multiSiteUserId);
			associateValues(EDIPI, multiSiteUserId, PALO_ALTO_AA, "PA" + multiSiteUserId);
			associateValues(EDIPI, multiSiteUserId, ICN, multiSiteUserId);
			associateValues(ICN, multiSiteUserId, DCVAMC_AA, multiSiteUserId);
			associateValues(ICN, multiSiteUserId, CHICAGO_AA, "CH" + multiSiteUserId);
			associateValues(ICN, multiSiteUserId, CHILLICOTHE_AA, "CHI" + multiSiteUserId);
			associateValues(ICN, multiSiteUserId, PALO_ALTO_AA, "PA" + multiSiteUserId);
		}

		String[] dcSiteUserIds = {"PATID0", "PATID1", "PATID2", "PATID3", "PATID4", "PATID5", "PATID6", "PATID7", "PATID8", "PATID9", "PATID10", "PATID11", "PATID12", "PATID13", "PATID14", "PATID15", "PATID16", "PATID17",
				"PATID18", "PATID19", "PATID20", "PATID21", "PATID22", "PATID23", "PATID24", "PATID25", "PATID27", "PATID28", "PATID29", "PATID30", "PATID31", "PATID32", "PATID33", "PATID34",
				"PATID35", "PATID36", "PATID37", "PATID38", "PATID39", "PATID40", "PATID41", "PATID42", "PATID43", "PATID44", "PATID45", "PATID46", "PATID47", "PATID48", "PATID49", "PATID50",
				"PATID51", "PATID52", "PATID53", "PATID54", "PATID55", "PATID56", "PATID57", "PATID58" };
		for (String dcSiteUserId : dcSiteUserIds) {
			associateValues(EDIPI, dcSiteUserId, EDIPI, dcSiteUserId);
			associateValues(EDIPI, dcSiteUserId, DCVAMC_AA, dcSiteUserId);
			associateValues(ICN, dcSiteUserId, DCVAMC_AA, dcSiteUserId);
		}

		String[] appTestGroupUserIds = { "TSTGRP01", "TSTGRP02", "TSTGRP03", "TSTGRP04", "TSTGRP05", "TSTGRP06", "TSTGRP07", "TSTGRP08", "TSTGRP09", "TSTGRP10", "TSTGRP11", "TSTGRP12" };

		for (String appTestGroupUserId : appTestGroupUserIds) {
			associateValues(EDIPI, appTestGroupUserId, EDIPI, appTestGroupUserId);
			associateValues(EDIPI, appTestGroupUserId, DCVAMC_AA, appTestGroupUserId);
			associateValues(EDIPI, appTestGroupUserId, CHICAGO_AA, "CH" + appTestGroupUserId);
			associateValues(EDIPI, appTestGroupUserId, CHILLICOTHE_AA, "CHI" + appTestGroupUserId);
			associateValues(EDIPI, appTestGroupUserId, PALO_ALTO_AA, "PA" + appTestGroupUserId);
			associateValues(EDIPI, appTestGroupUserId, ICN, appTestGroupUserId);
			associateValues(ICN, appTestGroupUserId, DCVAMC_AA, appTestGroupUserId);
			associateValues(ICN, appTestGroupUserId, CHICAGO_AA, "CH" + appTestGroupUserId);
			associateValues(ICN, appTestGroupUserId, CHILLICOTHE_AA, "CHI" + appTestGroupUserId);
			associateValues(ICN, appTestGroupUserId, PALO_ALTO_AA, "PA" + appTestGroupUserId);
		}
	}

	public void associateValues(PatientIdentifier patientIdentifier1, PatientIdentifier patientIdentifier2) {
		associateValues(patientIdentifier1.getAssigningAuthority(), patientIdentifier1.getUniqueId(), patientIdentifier2.getAssigningAuthority(), patientIdentifier2.getUniqueId());
	}

	public void associateValues(String assigningAuthority1, String patientId1, String assigningAuthority2, String patientId2) {
		PatientIdentifier patientIdentifier1 = new PatientIdentifier(assigningAuthority1, patientId1);
		PatientIdentifier patientIdentifier2 = new PatientIdentifier(assigningAuthority2, patientId2);
		map.associateValues(patientIdentifier1, patientIdentifier2);
	}

	@Override
	public PatientIdentifiers getCorrespondIdentifiers(PatientIdentifier patientIdentifier, String targetAssigningAuthority) {
		PatientIdentifiers filteredPatientIdentifiers = new PatientIdentifiers();
		for (PatientIdentifier possibleMatch : getCorrespondIdentifiers(patientIdentifier)) {
			if (possibleMatch.getAssigningAuthority().toLowerCase().contains(targetAssigningAuthority.toLowerCase())) {
				filteredPatientIdentifiers.add(possibleMatch);
			}
		}

		return filteredPatientIdentifiers;
	}

	@Override
	public PatientIdentifiers getCorrespondIdentifiers(PatientIdentifier patientIdentifier) {
		Set<PatientIdentifier> setOfIdentifiers = map.get(patientIdentifier);
		PatientIdentifiers identifiers = PatientIdentifiers.fromSet(setOfIdentifiers);
		logger.debug(String.format("found %s identifiers associated with %s", identifiers.size(), patientIdentifier));
		return identifiers;
	}

}
