package com.agilex.healthcare.mobilehealthplatform.patientcorrelation;

import java.util.Set;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.utility.collections.MutualAssocationMap;

public class PatientCorrelationIntegrationMock implements PatientCorrelationService {
    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(PatientCorrelationIntegrationMock.class);

    private static final String EDIPI = "EDIPI";
    private static final String ICN = "ICN";
    private static final String DFN_BAY_PINES = "DFN-516";

    private final static PatientIdentifier PriscillaDuncanEDIPI = new PatientIdentifier(EDIPI, "1244420300");
    private final static PatientIdentifier PriscillaDuncanICN = new PatientIdentifier(ICN, "1002772146V123456");

    // PCL Assessment Results
    private final static PatientIdentifier JeromeDuncanEDIPI = new PatientIdentifier(EDIPI, "1010198069");
    private final static PatientIdentifier JeromeDuncanICN = new PatientIdentifier(ICN, "1011969310v123456");

    // For RxRefill
    private final static PatientIdentifier RoyDuncanEDIPI = new PatientIdentifier(EDIPI, "1100158376");
    private final static PatientIdentifier RoyDuncanICN = new PatientIdentifier(ICN, "1002772146V123456");
    private final static PatientIdentifier RoyDuncanDfn = new PatientIdentifier("DFN-688", "3037149");

    // For HDR
    private final static PatientIdentifier Sarah       EDIPI = new PatientIdentifier(EDIPI, "1104345570");
    private final static PatientIdentifier Sarah       ICN = new PatientIdentifier(ICN, "1012591986V402329");

    // For ADR
    private final static PatientIdentifier VernonElliottEDIPI = new PatientIdentifier(EDIPI, "1284181731");
    private final static PatientIdentifier VernonElliottICN = new PatientIdentifier(ICN, "1002012057V866443");

    // MHV Integration test user 1 (SIMONSON, MHVTP)
    private static final PatientIdentifier shaneElliottEDIPI = new PatientIdentifier("EDIPI", "19560912");
    private static final PatientIdentifier shaneElliottICN = new PatientIdentifier("ICN", "1012664624V226015");

    // MHV System test user (NICOLAS, MHVTP)
    private static final PatientIdentifier kirkEvansEDIPI = new PatientIdentifier("EDIPI", "1021206853");
    private static final PatientIdentifier kirkEvansICN = new PatientIdentifier("ICN", "1012664640V815571");

    /* ------ IV&V Test Account Correlations ------ */

    // ruben.moreno
    private static final PatientIdentifier rubenMorenoEDIPI = new PatientIdentifier(EDIPI, "1099737332");
    private static final PatientIdentifier rubenMorenoICN = new PatientIdentifier(ICN, "1011491687V235101");
    private static final PatientIdentifier rubenMorenoDfn = new PatientIdentifier(DFN_BAY_PINES, "22679");

    // michael.moreno
    private static final PatientIdentifier michaelMorenoEDIPI = new PatientIdentifier(EDIPI, "1098230730");
    private static final PatientIdentifier michaelMorenoICN = new PatientIdentifier(ICN, "1016433599V285591");
    private static final PatientIdentifier michaelMorenoDfn = new PatientIdentifier(DFN_BAY_PINES, "7190668");

    // norman.morgan
    private static final PatientIdentifier norman      EDIPI = new PatientIdentifier(EDIPI, "1013599714");
    private static final PatientIdentifier norman      ICN = new PatientIdentifier(ICN, "1011491693V308296");
    private static final PatientIdentifier norman      Dfn = new PatientIdentifier(DFN_BAY_PINES, "7178750");

    // ben.morgan
    private static final PatientIdentifier ben      EDIPI = new PatientIdentifier(EDIPI, "1013599722");
    private static final PatientIdentifier ben      ICN = new PatientIdentifier(ICN, "1011491669V494787");
    private static final PatientIdentifier ben      Dfn = new PatientIdentifier(DFN_BAY_PINES, "22680");

    // jacqueline.morgan
    private static final PatientIdentifier jacqueline      EDIPI = new PatientIdentifier(EDIPI, "1013599730");
    private static final PatientIdentifier jacqueline      ICN = new PatientIdentifier(ICN, "1012136270V001123");
    private static final PatientIdentifier jacqueline      Dfn = new PatientIdentifier(DFN_BAY_PINES, "7186356");

    // chester.morgan
    private static final PatientIdentifier chester      EDIPI = new PatientIdentifier(EDIPI, "1235919008");
    private static final PatientIdentifier chester      ICN = new PatientIdentifier(ICN, "1012180058V173816");
    private static final PatientIdentifier chester      Dfn = new PatientIdentifier(DFN_BAY_PINES, "22678");

    // cecil.morgan
    private static final PatientIdentifier cecil      EDIPI = new PatientIdentifier(EDIPI, "1249652616");
    private static final PatientIdentifier cecil      ICN = new PatientIdentifier(ICN, "1011491670V440848");
    private static final PatientIdentifier cecil      Dfn = new PatientIdentifier(DFN_BAY_PINES, "43097");

    // nelson.morrison
    private static final PatientIdentifier nelsonMorrisonEDIPI = new PatientIdentifier(EDIPI, "1026348648");
    private static final PatientIdentifier nelsonMorrisonICN = new PatientIdentifier(ICN, "1015888268V919608");
    private static final PatientIdentifier nelsonMorrisonDfn = new PatientIdentifier(DFN_BAY_PINES, "7198878");

    // judy.morrison
    private static final PatientIdentifier judyMorrisonEDIPI = new PatientIdentifier(EDIPI, "1259897978");
    private static final PatientIdentifier judyMorrisonICN = new PatientIdentifier(ICN, "1011938039V642105");
    private static final PatientIdentifier judyMorrisonDfn = new PatientIdentifier(DFN_BAY_PINES, "25320");

    // john.morrison
    private static final PatientIdentifier johnMorrisonEDIPI = new PatientIdentifier(EDIPI, "1323219504");
    private static final PatientIdentifier johnMorrisonICN = new PatientIdentifier(ICN, "1012403158V478606");
    private static final PatientIdentifier johnMorrisonDfn = new PatientIdentifier(DFN_BAY_PINES, "7187565");


    MutualAssocationMap<PatientIdentifier> map = new MutualAssocationMap<PatientIdentifier>();

    public PatientCorrelationIntegrationMock() {
        addMockData();
    }

    private void addMockData() {

        /* IV&V DSLogon Account Associations */

        associateValues(rubenMorenoEDIPI, rubenMorenoEDIPI);
        associateValues(rubenMorenoDfn, rubenMorenoEDIPI);
        associateValues(rubenMorenoICN, rubenMorenoEDIPI);
        associateValues(rubenMorenoICN, rubenMorenoDfn);

        associateValues(michaelMorenoEDIPI, michaelMorenoEDIPI);
        associateValues(michaelMorenoICN, michaelMorenoEDIPI);
        associateValues(michaelMorenoDfn, michaelMorenoEDIPI);
        associateValues(michaelMorenoICN, michaelMorenoDfn);

        associateValues(norman      EDIPI, norman      EDIPI);
        associateValues(norman      ICN, norman      EDIPI);
        associateValues(norman      Dfn, norman      EDIPI);
        associateValues(norman      ICN, norman      Dfn);

        associateValues(ben      EDIPI, ben      EDIPI);
        associateValues(ben      ICN, ben      EDIPI);
        associateValues(ben      Dfn, ben      EDIPI);
        associateValues(ben      ICN, ben      Dfn);

        associateValues(jacqueline      EDIPI, jacqueline      EDIPI);
        associateValues(jacqueline      ICN, jacqueline      EDIPI);
        associateValues(jacqueline      Dfn, jacqueline      EDIPI);
        associateValues(jacqueline      ICN, jacqueline      Dfn);

        associateValues(chester      EDIPI, chester      EDIPI);
        associateValues(chester      ICN, chester      EDIPI);
        associateValues(chester      Dfn, chester      EDIPI);
        associateValues(chester      ICN, chester      Dfn);

        associateValues(cecil      EDIPI, cecil      EDIPI);
        associateValues(cecil      ICN, cecil      EDIPI);
        associateValues(cecil      Dfn, cecil      EDIPI);
        associateValues(cecil      ICN, cecil      Dfn);

        associateValues(nelsonMorrisonEDIPI, nelsonMorrisonEDIPI);
        associateValues(nelsonMorrisonICN, nelsonMorrisonEDIPI);
        associateValues(nelsonMorrisonDfn, nelsonMorrisonEDIPI);
        associateValues(nelsonMorrisonICN, nelsonMorrisonDfn);

        associateValues(judyMorrisonEDIPI, judyMorrisonEDIPI);
        associateValues(judyMorrisonICN, judyMorrisonEDIPI);
        associateValues(judyMorrisonDfn, judyMorrisonEDIPI);
        associateValues(judyMorrisonICN, judyMorrisonDfn);

        associateValues(johnMorrisonEDIPI, johnMorrisonEDIPI);
        associateValues(johnMorrisonICN, johnMorrisonEDIPI);
        associateValues(johnMorrisonDfn, johnMorrisonEDIPI);
        associateValues(johnMorrisonICN, johnMorrisonDfn);

        /* Original DSLogon Account Associations */
        associateValues(PriscillaDuncanEDIPI, PriscillaDuncanEDIPI);
        associateValues(PriscillaDuncanEDIPI, PriscillaDuncanICN);
        associateValues(JeromeDuncanEDIPI, JeromeDuncanEDIPI);
        associateValues(JeromeDuncanEDIPI, JeromeDuncanICN);
        associateValues(RoyDuncanEDIPI, RoyDuncanEDIPI);
        associateValues(RoyDuncanEDIPI, RoyDuncanICN);
        associateValues(RoyDuncanEDIPI, RoyDuncanDfn);
        associateValues(Sarah       EDIPI, Sarah       EDIPI);
        associateValues(Sarah       EDIPI, Sarah       ICN);
        associateValues(VernonElliottEDIPI, VernonElliottEDIPI);
        associateValues(VernonElliottEDIPI, VernonElliottICN);
        associateValues(shaneElliottEDIPI, shaneElliottEDIPI);
        associateValues(shaneElliottEDIPI, shaneElliottICN);
        associateValues(kirkEvansEDIPI, kirkEvansEDIPI);
        associateValues(kirkEvansEDIPI, kirkEvansICN);
    }

    public void associateValues(PatientIdentifier patientIdentifier1, PatientIdentifier patientIdentifier2) {
        associateValues(patientIdentifier1.getAssigningAuthority(), patientIdentifier1.getUniqueId(), patientIdentifier2.getAssigningAuthority(), patientIdentifier2.getUniqueId());
    }

    public void associateValues(String assigningAuthority1, String patientId1, String assigningAuthority2, String patientId2) {
        PatientIdentifier patientIdentifier1 = new PatientIdentifier(assigningAuthority1, patientId1);
        PatientIdentifier patientIdentifier2 = new PatientIdentifier(assigningAuthority2, patientId2);
        map.associateValues(patientIdentifier1, patientIdentifier2);
    }

    @Override
    public PatientIdentifiers getCorrespondIdentifiers(PatientIdentifier patientIdentifier, String targetAssigningAuthority) {
        PatientIdentifiers filteredPatientIdentifiers = new PatientIdentifiers();
        for (PatientIdentifier possibleMatch : getCorrespondIdentifiers(patientIdentifier)) {
            if (possibleMatch.getAssigningAuthority().toLowerCase().contains(targetAssigningAuthority.toLowerCase())) {
                filteredPatientIdentifiers.add(possibleMatch);
            }
        }

        return filteredPatientIdentifiers;
    }

    @Override
    public PatientIdentifiers getCorrespondIdentifiers(PatientIdentifier patientIdentifier) {
        logger.debug(String.format("Find correlations for %s", patientIdentifier));
        Set<PatientIdentifier> setOfIdentifiers = map.get(patientIdentifier);
        PatientIdentifiers identifiers = PatientIdentifiers.fromSet(setOfIdentifiers);
        logger.debug(String.format("found %s identifiers associated with %s", identifiers.size(), patientIdentifier));
        logger.debug(String.format("found %s identifiers associated with %s", identifiers, patientIdentifier));
        return identifiers;
    }

}
