package com.agilex.healthcare.mobilehealthplatform.datalayer.xls;

import java.util.Map;

public class DataElementDataStorage {
	private static DataElementDataStorage instance;
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(DataElementDataStorage.class);

	// PatientId -> DataElements associated with a domain sheet
	private static Map<String, DomainDataElements> cache;

	private DataElementDataStorage() {
	}

	public DataElements getData(String patientId, String domain) {
		LOGGER.debug(String.format("DataStorage: Request for patient %s", patientId));
		if (patientId == null)
			patientId = "";
		DomainDataElements data = null;
		if (cache == null) {
			LOGGER.debug("DataStorage: cache is not set, initializing");
			cache = getPatientCacheFromExcelRetriever(patientId);
			data = cache.get(patientId);
		} else if (cache.get(patientId) == null) {
			LOGGER.debug(String.format("DataStorage: main cache is initialized, initializing for [patient %s][domain %s]", patientId, domain));
			Map<String, DomainDataElements> patientCache = getPatientCacheFromExcelRetriever(patientId);
			data = patientCache.get(patientId);
			if (data != null) {
				cache.put(patientId, data);
			}
		} else {
			data = cache.get(patientId);
		}
		if (data == null || data.get(domain) == null) {
			LOGGER.debug(String.format("DataStorage: using empty cache [patient %s][domain %s]", patientId, domain));
			return new DataElements();
		} else {
			LOGGER.debug("DataStorage: using cache");
			return data.get(domain);
		}
	}

	public static DataElementDataStorage getInstance() {
		if (instance == null) {
			instance = new DataElementDataStorage();
		}
		return instance;
	}

	public DataElement getData(String patientId, String domain, String id, String idKey) {
		DataElements dataElements = getData(patientId, domain);
		DataElement match = null;
		for (DataElement potentialMatch : dataElements) {
			if (potentialMatch.getValue(idKey).contentEquals(id)) {
				match = potentialMatch;
			}
		}
		return match;
	}

	private Map<String, DomainDataElements> getPatientCacheFromExcelRetriever(String patientId) {
		ExcelRetriever retriever = new ExcelRetriever(patientId);
		return retriever.getSheetCache();
	}
}
