package com.agilex.healthcare.mobilehealthplatform.datalayer.xls;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;

public class DataElement extends HashMap<String, String> {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(DataElement.class);
	private static final long serialVersionUID = -4757228511250369471L;
	private static final String EXCELDATETIME_FORMAT = "MM/dd/yy HH:mm";

	public String getValue(String key) {
		if (NullChecker.isNullish(key))
			return null;
		return this.get(key.toLowerCase());
	}

	public Date getValueAsDate(String key) {
		String valueAsString = getValue(key);
		Date valueAsDate = null;
		if (NullChecker.isNotNullish(valueAsString)) {
			valueAsDate = DateHelper.parseDate(valueAsString);
		}
		return valueAsDate;
	}

	public boolean getValueAsBoolean(String key) {
		String valueAsString = getValue(key);
		boolean valueAsBoolean = false;
		if (NullChecker.isNotNullish(valueAsString)) {
			valueAsBoolean = Boolean.parseBoolean(valueAsString);
		}
		return valueAsBoolean;
	}

	public Date getValueAsDateTime(String key) {
		String valueAsString = getValue(key);
		Date valueAsDate = null;
		if (NullChecker.isNotNullish(valueAsString)) {
			
			try {
				valueAsDate = DateHelper.parse(valueAsString, EXCELDATETIME_FORMAT);
			}
			catch(RuntimeException re) {
				try {
					int numberOfDaysToAdd = Integer.parseInt(valueAsString);
					Calendar now = Calendar.getInstance();
					now.add(Calendar.DATE, numberOfDaysToAdd);
					valueAsDate = now.getTime();
				}
				catch(NumberFormatException nfe) {
					LOGGER.error("Attempted to create date string that was neither a date nor a number of days from today", nfe);
				}
			}
		}
		return valueAsDate;
	}
	
	public Integer getValueAsInteger(String key) {
		String valueAsString = getValue(key);
		Integer valueAsInteger = null;
		if (NullChecker.isNotNullish(valueAsString)) {
			valueAsInteger = Integer.parseInt(valueAsString);
		}
		return valueAsInteger;
	}
}
