package com.agilex.healthcare.mobilehealthplatform.datalayer.surgery;

import java.text.ParseException;
import java.text.SimpleDateFormat;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.utility.NullSafeStringComparer;

public class SurgeryDataLayerMock implements SurgeryDataLayer {
	private Surgeries surgeryDataStore;

	public SurgeryDataLayerMock() throws ParseException {
		surgeryDataStore = initializeSurgeryDataStore();
	}

	private Surgeries initializeSurgeryDataStore() throws ParseException {
		SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
		Surgeries surgeries = new Surgeries();
		Surgery surgery;

		surgery = new Surgery();
		surgery.setPatientId("D123401");
		surgery.setFacility("VA");
		surgery.setProcedure("Tonsillectomy");
		surgery.setProcedureDate(df.parse("01/01/2011"));
		surgeries.add(surgery);

		surgery = new Surgery();
		surgery.setPatientId("D123401");
		surgery.setFacility("VA");
		surgery.setProcedure("Knee Replacement");
		surgery.setProcedureDate(df.parse("10/03/2009"));
		surgeries.add(surgery);

		surgery = new Surgery();
		surgery.setPatientId("D123401");
		surgery.setFacility("VA");
		surgery.setProcedure("Hip Surgery");
		surgery.setProcedureDate(df.parse("08/25/2007"));
		surgeries.add(surgery);
		
		return surgeries;
	}

	@Override
	public Surgeries getPatientSurgeries(String patientId, DateFilter dateFilter) {
		Surgeries surgeries = new Surgeries();
		for (Surgery surgery : surgeryDataStore) {
			if (surgery.getPatientId().contentEquals(patientId))
				surgeries.add(surgery);
		}
		return surgeries;
	}

	@Override
	public Surgeries fetchSurgeries(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		return getPatientSurgeries(patientIdentifier.getUniqueId(), dateFilter);
	}
	
	@Override
	public Surgery fetchSurgery(PatientIdentifier patientIdentifier, String surgeryId) {
		Surgeries surgeries = fetchSurgeries(patientIdentifier, DateFilterFactory.createEmptyFilter());
		
		Surgery match = null;
		for(Surgery surgery : surgeries) {
			if(NullSafeStringComparer.areEqualIgnoreCase(surgery.getUniqueId(), surgeryId)) {
				match = surgery;
				break;
			}
		}
		
		return match;
	}

}
