package com.agilex.healthcare.mobilehealthplatform.datalayer.surgery;

import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElement;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElementDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElements;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.utility.NullSafeStringComparer;

public class SurgeryDataLayerExcel implements SurgeryDataLayer {

	private static final String COLUMN_UNIQUEID = "UniqueId";
	private static final String COLUMN_FACILITY = "Facility";
	private static final String COLUMN_PROCEDURE = "Procedure";
	private static final String COLUMN_PROCEDUREDATE = "ProcedureDate";
	
	private static final String domain = "Surgeries";

	@Override
	public Surgeries getPatientSurgeries(String patientId, DateFilter dateFilter) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();;
		DataElements dataElements = storage.getData(patientId, domain);
		return createSurgeries(dataElements, dateFilter);
	}

	private Surgeries createSurgeries(DataElements dataElements, DateFilter dateFilter) {
		Surgeries surgeries = new Surgeries();
		for (DataElement dataElement : dataElements) {
			surgeries.add(createSurgery(dataElement));
		}
		
		surgeries = DateFilterer.filterByDate(surgeries, dateFilter);
		
		return surgeries;
	}

	private Surgery createSurgery(DataElement dataElement) {
		Surgery surgery = new Surgery();
		surgery.setUniqueId(dataElement.getValue(COLUMN_UNIQUEID));
		surgery.setFacility(dataElement.getValue(COLUMN_FACILITY));
		surgery.setProcedureDate(dataElement.getValueAsDate(COLUMN_PROCEDUREDATE));
		surgery.setProcedure(dataElement.getValue(COLUMN_PROCEDURE));
		
		return surgery;
	}
	
	@Override
	public Surgery fetchSurgery(PatientIdentifier patientIdentifier, String surgeryId) {
		Surgeries surgeries = fetchSurgeries(patientIdentifier, DateFilterFactory.createEmptyFilter());
		
		Surgery match = null;
		for(Surgery surgery : surgeries) {
			if(NullSafeStringComparer.areEqualIgnoreCase(surgery.getUniqueId(), surgeryId)) {
				match = surgery;
				break;
			}
		}
		
		return match;
	}

	@Override
	public Surgeries fetchSurgeries(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		return getPatientSurgeries(patientIdentifier.getUniqueId(), dateFilter);
	}
	
}
