package com.agilex.healthcare.mobilehealthplatform.datalayer.staffdirectory;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;

import com.agilex.healthcare.mobilehealthplatform.domain.Provider;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffDirectorySearchResult;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffDirectorySearchResults;
import com.agilex.healthcare.mobilehealthplatform.utils.StringUtil;

public class StaffDirectoryDataLayerMock implements StaffDirectoryDataLayer {
	private List<Provider> users;

	@Override
	public StaffDirectorySearchResults searchByFirstAndLastname(String facilitySiteCode, String firstNamePrefix, String lastNamePrefix) {
		List<Provider> users = new ArrayList<Provider>();

		for(Provider user : getUsers())
			if (user.getVistaLocations().contains(facilitySiteCode) &&
					StringUtil.startsWithIgnoreCase(firstNamePrefix, user.getFirstName()) &&
					StringUtil.startsWithIgnoreCase(lastNamePrefix, user.getLastName())) {
				users.add(user);
			}

		return translate(users);
	}

	@Override
	public StaffDirectorySearchResults searchByFirstOrLastname(String facilitySiteCode, String firstNamePrefix, String lastNamePrefix) {
		List<Provider> users = new ArrayList<Provider>();

		for(Provider user : getUsers()) {
			if (user.getVistaLocations().contains(facilitySiteCode) &&
					(StringUtil.startsWithIgnoreCase(firstNamePrefix, user.getFirstName()) ||
					StringUtil.startsWithIgnoreCase(lastNamePrefix, user.getLastName()))) {
				users.add(user);
			}
		}
		return translate(users);
	}

	@Override
	public StaffDirectorySearchResults searchByEmail(String facilitySiteCode, String emailPrefix) {
		List<Provider> users = new ArrayList<Provider>();
		
		if (!StringUtil.isEmpty(emailPrefix)) {
			for(Provider user : getUsers()) {
				if (user.getVistaLocations().contains(facilitySiteCode) &&
						StringUtil.startsWithIgnoreCase(emailPrefix,user.getEmailAddress())) {
					users.add(user);
				}
			}
		}
		return translate(users);
	}

	@Override
	public StaffDirectorySearchResults searchByPhoneNumber(String facilitySiteCode, String phoneNumberPrefix) {
		List<Provider> users = new ArrayList<Provider>();
		
		if (!StringUtil.isEmpty(phoneNumberPrefix)) {
			for(Provider user : getUsers()) {
				if (user.getVistaLocations().contains(facilitySiteCode) &&
						(StringUtil.startsWithIgnoreCase(phoneNumberPrefix, user.getCellPhone()) ||
						StringUtil.startsWithIgnoreCase(phoneNumberPrefix, user.getOfficePhone()) ||
						StringUtil.startsWithIgnoreCase(phoneNumberPrefix, user.getDigitalPager()) ||
						StringUtil.startsWithIgnoreCase(phoneNumberPrefix, user.getVoicePager()))) {
					users.add(user);
				}
			}
		}
		return translate(users);
	}
	
	public void setUsers(List<Provider> users) {
		this.users = new LinkedList<Provider>(users);
	}
	
	private StaffDirectorySearchResults translate(List<Provider> users) {
		StaffDirectorySearchResults staffDirectorySearchResults = new StaffDirectorySearchResults();
		for (Provider user : users) {
			staffDirectorySearchResults.add(ProviderToStaffDirectorySearchResult(user));
		}
		return staffDirectorySearchResults;
	}
	
	private StaffDirectorySearchResult ProviderToStaffDirectorySearchResult(Provider user) {
		StaffDirectorySearchResult staffDirectorySearchResult = new StaffDirectorySearchResult();
		staffDirectorySearchResult.setName(user.getDisplayName());
		staffDirectorySearchResult.setEmailAddress(user.getEmailAddress());
		staffDirectorySearchResult.setVoicePager(user.getVoicePager());
		staffDirectorySearchResult.setDigitalPager(user.getDigitalPager());
		staffDirectorySearchResult.setOfficePhone(user.getOfficePhone());
		staffDirectorySearchResult.setCellPhone(user.getCellPhone());
		staffDirectorySearchResult.setTitle(user.getTitle());
		staffDirectorySearchResult.setOfficeLocation(user.getOfficeLocation());
		
		
		return staffDirectorySearchResult;
	}
	
	public List<Provider> getUsers(){
		if (users == null) {
			users = getUserDatabase();
		}
		return users;
	}
	
	public List<Provider> getUserDatabase() {
		List<Provider> users = new LinkedList<Provider>();
		
		Provider user = null;
		
		user = new Provider();
		user.setFirstName("zztest");
		user.setLastName("staff01");
		user.setTitle("Doctor");
		user.addVistaLocation("688");
		user.addVistaLocation("652");
		user.setCellPhone("1394792837466");
		user.setOfficePhone("13423423444");
		user.setDigitalPager("13429889935");
		user.setVoicePager("13423423884");
		user.setOfficeLocation("Test VA Hospital");
		user.setEmailAddress("staff01@test.domain");
		users.add(user);
		
		user = new Provider();
		user.setFirstName("zztest");
		user.setLastName("staff02");
		user.setTitle("Doctor");
		user.addVistaLocation("688");
		user.setCellPhone("23940028374");
		user.setOfficePhone("234234234");
		user.setDigitalPager("258565674234");
		user.setVoicePager("23423567834");
		user.setOfficeLocation("Test VA Hospital");
		user.setEmailAddress("staff02@test.domain");
		users.add(user);

		user = new Provider();
		user.setFirstName("zztest");
		user.setLastName("staff03");
		user.setTitle("Doctor");
		user.addVistaLocation("652");
		user.setCellPhone("33947928374");
		user.setOfficePhone("33424464234");
		user.setDigitalPager("334534534");
		user.setVoicePager("334277757");
		user.setOfficeLocation("Test VA Hospital");
		user.setEmailAddress("staff03@test.domain");
		users.add(user);

		user = new Provider();
		user.setFirstName("zztest");
		user.setLastName("staff04");
		user.setTitle("Doctor");
		user.addVistaLocation("688");
		user.setCellPhone("43947928374");
		user.setOfficePhone("4342334534");
		user.setDigitalPager("434267834");
		user.setVoicePager("4342569004");
		user.setOfficeLocation("Test VA Hospital");
		user.setEmailAddress("staff04@test.domain");
		users.add(user);

		user = new Provider();
		user.setFirstName("zztest");
		user.setLastName("staff05");
		user.setTitle("Doctor");
		user.addVistaLocation("688");
		user.setCellPhone("53947928374");
		user.setOfficePhone("532474234");
		user.setDigitalPager("534258834");
		user.setVoicePager("5342358334");
		user.setOfficeLocation("Test VA Hospital");
		user.setEmailAddress("staff05@test.domain");
		users.add(user);

		user = new Provider();
		user.setFirstName("zztest");
		user.setLastName("staff06");
		user.setTitle("Doctor");
		user.addVistaLocation("688");
		user.setCellPhone("63947928374");
		user.setOfficePhone("6342364574234");
		user.setDigitalPager("629384234");
		user.setVoicePager("63423445674");
		user.setOfficeLocation("Test VA Hospital");
		user.setEmailAddress("staff06@test.domain");
		users.add(user);
		
        return users;
	}

}
