package com.agilex.healthcare.mobilehealthplatform.datalayer.rightofaccess;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.agilex.healthcare.mobilehealthplatform.domain.RightOfAccessInfo;

public class RightOfAccessDataLayerMock implements RightOfAccessDataLayer {
	private static Map<String, RightOfAccessInfo> RightOfAccessInfoStorage = new HashMap<String, RightOfAccessInfo>();

	
	public RightOfAccessDataLayerMock() {
		initializeDataStorage();
	}
	
	private void initializeDataStorage() {

        addUserRightOfAccessAccepted("D123401");
        addUserRightOfAccessAccepted("PATID78");
        addUserRightOfAccessAccepted("PATID76");
        addUserRightOfAccessAccepted("NO-DATA-MOCK");
        addUserRightOfAccessAccepted("PATID26");
        addUserRightOfAccessAccepted("INT-TEST-MOCK");
        addUserRightOfAccessAccepted("PATID65");
        addUserRightOfAccessAccepted("noidentity");
	}

    private void addUserRightOfAccessAccepted(String userId) {
        RightOfAccessInfo info;
        info = new RightOfAccessInfo(userId, true, new Date());
        RightOfAccessInfoStorage.put(userId, info);
    }


    @Override
	public boolean hasAcceptedRightOfAccess(String userId) {
		boolean hasAccepted = false;
		if (RightOfAccessInfoStorage.containsKey(userId)) {
			hasAccepted = RightOfAccessInfoStorage.get(userId).isRightOfAccessAccepted();
		}
		return hasAccepted;
	}

	@Override
	public RightOfAccessInfo getRightOfAccessInfo(String userId) {
		return RightOfAccessInfoStorage.get(userId);
	}

	@Override
	public RightOfAccessInfo saveRightOfAccessInfo(RightOfAccessInfo rightOfAccessInfo) {
		String userId = rightOfAccessInfo.getUserId();
		RightOfAccessInfoStorage.put(userId, rightOfAccessInfo);
		return RightOfAccessInfoStorage.get(userId);
	}
}
