package com.agilex.healthcare.mobilehealthplatform.datalayer.radiology;

import java.text.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

public class RadiologyDataLayerMock implements RadiologyDataLayer {
	private RadiologyResults radiologyDataStore;

	public RadiologyDataLayerMock() throws ParseException {
		radiologyDataStore = initializeRadiologyDataStore();
	}

	private RadiologyResults initializeRadiologyDataStore() throws ParseException {
		SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
		RadiologyResults examResults = new RadiologyResults();
		RadiologyResult examResult;

		examResult = new RadiologyResult();
		examResult.setUniqueId("1");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-RAY)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("06/03/2009"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  MYOCARDIAL PERFUSION SCAN W/PHARM STRESS\n" + 
				"     \n" + 
				"  Exm Date: MAY 24, 2008@11:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: NUCLEAR MEDICINE (Req'g Loc)\n" + 
				"                                           Img Loc: NUCLEAR MEDICINE\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 46 WAITING )   MYOCARDIAL PERFUSION SCAN W/PHARM(NM   Broad   )\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        dyspnea on exertion for past few months GXT \n" + 
				"      Report Status: Verified                   Date Reported: MAY 24, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        Myocardial perfusion scan, May 24, 2008.  \n" + 
				"              Radiopharmaceutical: 3 mCi of thallium-201 and 35.4 mCi \n" + 
				"              technetium 99m myoview.  \n" + 
				"              Findings: Patient underwent pharmacological stress utilizing 38.9 \n" + 
				"              mg of adenosine. Patient reported no chest pain and EKG was \n" + 
				"              negative for inducible ischemia at stress.  \n" + 
				"              A small mild to moderate defect is present in the inferior wall \n" + 
				"              at stress. This area undergoes near complete perfusion at rest.  \n" + 
				"              There is a question of a large mild defect in the lateral wall at \n" + 
				"              stress. This appears to undergo complete perfusion at rest. \n" + 
				"              Gated study demonstrates hypokinetic wall motion of the septum, \n" + 
				"              proximal inferior wall, and apex. Left ventricular ejection \n" + 
				"              fraction is decreased to 41%.  End-diastolic volume is 84 cc and \n" + 
				"              end-systolic volume is 49 cc.  \n" + 
				"      Impression:\n" + 
				"        Pharmacological stress with adenosine.  \n" + 
				"              Findings suggest a small area of mild to moderate ischemia of the \n" + 
				"              inferior wall.  \n" + 
				"              Question mild ischemia of the lateral wall.  \n" + 
				"              Decreased left ventricular ejection fraction of 41%.  \n" + 
				"              Hypokinetic wall motion of the septum, proximally inferior wall, and apex.  \n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"     \n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("2");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-RAY)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("07/01/2011"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  CHEST SINGLE VIEW\n" + 
				"  Exm Date: NOV 30, 2007@09:00\n" + 
				"  Req Phys: PROVIDER,ONE                   Pat Loc: GENERAL MEDICINE (Req'g Loc)\n" + 
				"                                           Img Loc: RADIOLOGY MAIN FLOOR\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 43 WAITING )   CHEST SINGLE VIEW                (RAD  Detailed) CPT:71010\n" + 
				"       Reason for Study: CHEST PAIN\n" + 
				"      Clinical History:\n" + 
				"        CHEST PAIN \n" + 
				"      Report Status: Verified                   Date Reported: NOV 30, 2007\n" + 
				"                                                Date Verified: APR 28, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"      Impression:\n" + 
				"        PA chest shows clear lung fields bilaterally.  \n" + 
				"              Cardiovascular and mediastinal structures show tenting of\n" + 
				"        the left cardiac margin suggesting old scar. Minimal\n" + 
				"        atherosclerosis is noted.  Enlargement of the cardiomediastinal silhouette\n" + 
				"        suggesting early cardiomyopathy \n" + 
				"              Bony thorax and surrounding soft tissues show degenerative\n" + 
				"        change of the mid and lower thoracic spine.  \n" + 
				"      Primary Diagnostic Code: MINOR ABNORMALITY\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("3");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-RAY)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("07/01/2001"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Abnormal");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                Longitudinal and transverse real-time \n" + 
				"                sonongraphic images of the kidneys and urinary bladder are \n" + 
				"                obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                The right kidney measures 10.2 cm in length\n" + 
				"        and the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"        Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("4");
		examResult.setTestId("chestmri");
		examResult.setTestShortName("Chest (MRI)");
		examResult.setTestName("Chest MRI");
		examResult.setResultedDate(df.parse("07/01/2010"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("5");
		examResult.setTestId("chestmri");
		examResult.setTestShortName("Chest (MRI)");
		examResult.setTestName("Chest MRI");
		examResult.setResultedDate(df.parse("07/01/2011"));
		examResult.setFacilityName("WV");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("REPORT");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("6");
		examResult.setTestId("chestscan");
		examResult.setTestShortName("Chest (CT Scan)");
		examResult.setTestName("Chest CT Scan");
		examResult.setResultedDate(df.parse("08/05/2008"));
		examResult.setFacilityName("SDVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("7");
		examResult.setTestId("abdomenxray");
		examResult.setTestShortName("Abdomen (X-Ray)");
		examResult.setTestName("Abdomen X-Ray");
		examResult.setResultedDate(df.parse("07/01/2000"));
		examResult.setFacilityName("SDVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("8");
		examResult.setTestId("abdomenxray");
		examResult.setTestShortName("Abdomen (X-Ray)");
		examResult.setTestName("Abdomen X-Ray");
		examResult.setResultedDate(df.parse("08/12/2006"));
		examResult.setFacilityName("CAVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("9");
		examResult.setTestId("pelvisctscan");
		examResult.setTestShortName("Pelvis(CT Scan)");
		examResult.setTestName("Pelvis CT Scan");
		examResult.setResultedDate(df.parse("12/01/2002"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("10");
		examResult.setTestId("pelvisctscan");
		examResult.setTestShortName("Pelvis(CT Scan)");
		examResult.setTestName("Pelvis CT Scan");
		examResult.setResultedDate(df.parse("11/01/2001"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("11");
		examResult.setTestId("pelvisctscan");
		examResult.setTestShortName("Pelvis(CT Scan)");
		examResult.setTestName("Pelvis CT Scan");
		examResult.setResultedDate(df.parse("01/01/1999"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("12");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-Ray)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("06/03/2009"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("13");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-Ray)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("09/01/2004"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("14");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-Ray)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("01/01/1998"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("15");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-Ray)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("07/04/2007"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("16");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-Ray)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("09/05/2001"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("17");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-Ray)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("09/05/2002"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("18");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-Ray)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("09/05/2003"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("19");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-Ray)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("09/05/2004"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("20");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-Ray)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("09/05/2005"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("21");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-Ray)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("04/12/2012"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		examResult = new RadiologyResult();
		examResult.setUniqueId("22");
		examResult.setTestId("chestxray");
		examResult.setTestShortName("Chest (X-Ray)");
		examResult.setTestName("Chest X-Ray PA and Lateral");
		examResult.setResultedDate(df.parse("05/01/2011"));
		examResult.setFacilityName("DCVAMC");
		examResult.setInterpretation("Normal Chest");
		examResult.setReport("Detailed Report\n" + 
				"  ECHOGRAM ABDOMEN LTD\n" + 
				"  Exm Date: APR 08, 2008@09:00\n" + 
				"  Req Phys: RADIOLOGIST,ONE                Pat Loc: ULTRASOUND (Req'g Loc)\n" + 
				"                                           Img Loc: SBK ULTRASOUND\n" + 
				"                                           Service: Unknown\n" + 
				"  (Case 45 WAITING )   ECHOGRAM ABDOMEN LTD             (US   Detailed) CPT:76705\n" + 
				"       Reason for Study: SEE CLINICAL HISTORY\n" + 
				"      Clinical History:\n" + 
				"        Stomach Pain \n" + 
				"      Report Status: Verified                   Date Reported: APR 08, 2008\n" + 
				"                                                Date Verified: APR 30, 2010\n" + 
				"      Verifier E-Sig:/ES/ONE RADIOLOGIST\n" + 
				"      Report:\n" + 
				"        TECHNIQUE: \n" + 
				"                 Longitudinal and transverse real-time \n" + 
				"              sonongraphic images of the kidneys and urinary bladder are \n" + 
				"              obtained.  \n" + 
				"        FINDINGS: \n" + 
				"                 The right kidney measures 10.2 cm in length and \n" + 
				"              the left kidney measures 10 cm in length.  The kidneys are\n" + 
				"        normal in size, shape, contour and position.  The cortices are\n" + 
				"        normal in thickness and echogenicity.   There is no evidence of \n" + 
				"        hydronephrosis.   Within the mid pole of the right kidney a 5.6 x \n" + 
				"        5.2 cm (L, AP) cyst is seen.  A smaller cyst is demonstrated \n" + 
				"        within the left mid pole that measures 1.8 x 1.6 cm (AP,W).  \n" + 
				"                 Scanning through the pelvis demonstrates a\n" + 
				"        partially distended bladder with anechoic urine.  The bladder grossly \n" + 
				"              appears normal.  \n" + 
				"      Impression:\n" + 
				"        1.  BILATERAL MID POLE KIDNEY CYST.  \n" + 
				"      Primary Diagnostic Code: ABNORMALITY, ATTN. NEEDED\n" + 
				"  Primary Interpreting Staff:\n" + 
				"    ONE RADIOLOGIST, Staff Physician (Verifier)\n" + 
				"  /SDR\n" + 
				"Facility: CAMP MASTER\n" + 
				"===============================================================================");
		
		return examResults;

	}

	public RadiologyResults getResults(String patientId, DateFilter dateFilter) {
		RadiologyResults examResults = new RadiologyResults();
		for (RadiologyResult examResult : radiologyDataStore) {
			if (examResult.getPatientId().contentEquals(patientId))
				examResults.add(examResult);
		}
		return examResults;
	}

	public RadiologyResult getResult(String patientId, String resultId) {
		return null;
	}

	@Override
	public RadiologyResults getResults(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		return getResults(patientIdentifier.getUniqueId(), dateFilter);
	}
	
	@Override
	public RadiologyResult fetchResult(PatientIdentifier patientIdentifier, String resultId) {
		return getResult(patientIdentifier.getUniqueId(), resultId);
	}

}
