package com.agilex.healthcare.mobilehealthplatform.datalayer.radiology;

import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElement;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElementDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElements;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;

public class RadiologyDataLayerExcel implements RadiologyDataLayer {

	private static final String COLUMN_UNIQUEID = "UniqueId";
	private static final String COLUMN_TESTID = "testId";
	private static final String COLUMN_TESTSHORTNAME = "testShortName";
	private static final String COLUMN_TESTNAME = "testname";
	private static final String COLUMN_RESULTEDDATE = "resultDate";
	private static final String COLUMN_FACILITYNAME = "facilityname";
	private static final String COLUMN_INTERPRETATION = "interpretation";
	private static final String COLUMN_REPORT = "report";
	private static final String domain = "RadiologyResults";

	public RadiologyResults getResults(String patientId, DateFilter filter) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();
		DataElements dataElements = storage.getData(patientId, domain);
		RadiologyResults results = createRadiologyResults(dataElements);
		RadiologyResults filteredResults = DateFilterer.filterByDate(results, filter);
		return filteredResults;
	}

	public RadiologyResult getResult(String patientId, String resultId) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();
		DataElement dataElement = storage.getData(patientId, domain, resultId, COLUMN_UNIQUEID);
		return createRadiologyResult(dataElement);
	}

	private RadiologyResults createRadiologyResults(DataElements dataElements) {
		RadiologyResults results = new RadiologyResults();
		for (DataElement dataElement : dataElements)
			results.add(createRadiologyResult(dataElement));
		return results;
	}

	private RadiologyResult createRadiologyResult(DataElement dataElement) {
		RadiologyResult radiologyResult = new RadiologyResult();
		radiologyResult.setUniqueId(dataElement.getValue(COLUMN_UNIQUEID));
		radiologyResult.setTestId(dataElement.getValue(COLUMN_TESTID));
		radiologyResult.setTestShortName(dataElement.getValue(COLUMN_TESTSHORTNAME));
		radiologyResult.setTestName(dataElement.getValue(COLUMN_TESTNAME));
		radiologyResult.setResultedDate(dataElement.getValueAsDate(COLUMN_RESULTEDDATE));
		radiologyResult.setFacilityName(dataElement.getValue(COLUMN_FACILITYNAME));
		radiologyResult.setSourceSystem(dataElement.getValue(COLUMN_FACILITYNAME));
		radiologyResult.setInterpretation(dataElement.getValue(COLUMN_INTERPRETATION));
		radiologyResult.setReport(dataElement.getValue(COLUMN_REPORT));
		return radiologyResult;
	}

	@Override
	public RadiologyResults getResults(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		return getResults(patientIdentifier.getUniqueId(), dateFilter);
	}

	@Override
	public RadiologyResult fetchResult(PatientIdentifier patientIdentifier, String resultId) {
		return getResult(patientIdentifier.getUniqueId(), resultId);
	}

}
