package com.agilex.healthcare.mobilehealthplatform.datalayer.provider;

import com.agilex.healthcare.mobilehealthplatform.MockDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElement;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElementDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElements;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProvider;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProviders;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import com.agilex.healthcare.utility.NullChecker;

public class ProviderDataLayerExcel implements ProviderDataLayer {
	
    private static final String DOMAIN = "Providers";
    private static final String COLUMN_UNIQUEID = "UniqueId";
    private static final String COLUMN_PATIENTID = "PatientId";
    private static final String COLUMN_PROVIDERID = "ProviderId";
    private static final String COLUMN_PROVIDERNAME = "ProviderName";
    private static final String COLUMN_PERSONCLASS = "PersonClass";
    private static final String COLUMN_VISITDATE = "VisitDate";
    private static final String COLUMN_FACILITYCODE = "FacilityCode";

    private MockDataStorage<PatientProviders, PatientProvider> data = null;

    private MockDataStorage<PatientProviders, PatientProvider> initMockDataStorage() {
        return new MockDataStorage<PatientProviders, PatientProvider>() {
            @Override
            protected PatientProviders createDataCollection() {
                return new PatientProviders();
            }
        };
    }

    private MockDataStorage<PatientProviders, PatientProvider> init(String patientId, String facilityCodeFilter) {
        MockDataStorage<PatientProviders, PatientProvider> data = initMockDataStorage();

        if (facilityCodeFilter == null) facilityCodeFilter = "";

        DataElementDataStorage storage = DataElementDataStorage.getInstance();
        DataElements dataElements = storage.getData(patientId, DOMAIN);
        data.setDataElements(createProviders(dataElements, facilityCodeFilter));
        return data;
    }

    private PatientProviders createProviders(DataElements dataElements, String facilityCodeFilter) {
        PatientProviders providers = new PatientProviders();

        for (DataElement dataElement : dataElements) {
            PatientProvider provider = createProvider(dataElement, facilityCodeFilter);
            if (provider != null) {
                providers.add(provider);
            }
        }

        return providers;
    }

    private PatientProvider createProvider(DataElement dataElement, String facilityCodeFilter) {

        String providerFacilityCode = dataElement.getValue(COLUMN_FACILITYCODE);

        Boolean returnProvider = false;

        //if facilityCodeFilter is specified
        if (facilityCodeFilter != null && !facilityCodeFilter.equals("")) {
            //and facility codes match
            if (facilityCodeFilter.equals(providerFacilityCode)) {
                returnProvider = true;
            } else {
                returnProvider = false;
            }
        } else {
            returnProvider = true;
        }

        if (!returnProvider) {
            return null;
        }

        PatientProvider provider = new PatientProvider();
        provider.setUniqueId(dataElement.getValue(COLUMN_UNIQUEID));
        provider.setPatientId(dataElement.getValue(COLUMN_PATIENTID));
        provider.setProviderId(dataElement.getValue(COLUMN_PROVIDERID));
        provider.setProviderName(dataElement.getValue(COLUMN_PROVIDERNAME));
        provider.setPersonClass(dataElement.getValue(COLUMN_PERSONCLASS));
        provider.setVisitDate(dataElement.getValueAsDate(COLUMN_VISITDATE));

        return provider;
    }

    @Override
    public PatientProviders fetchPrimaryCareProviders(PatientIdentifier patientIdentifier) {
        return fetchPrimaryCareProviders(patientIdentifier.getUniqueId());
    }

    @Override
    public PatientProviders fetchMentalHealthProviders(PatientIdentifier patientIdentifier, DateFilter filter, String facilitySiteCode) {
        return fetchMentalHealthProviders(patientIdentifier.getUniqueId(), filter, facilitySiteCode);
    }

    public PatientProviders fetchPrimaryCareProviders(String patientId) {
        MockDataStorage<PatientProviders, PatientProvider> data = init(patientId, null);

        PatientProviders providers = data.getDataForPatient(patientId);
        PatientProviders filteredProviders = new PatientProviders();

        for (PatientProvider provider : providers) {
            if (NullChecker.isNullish(provider.getPersonClass())) {
                filteredProviders.add(provider);
            }
        }

        return filteredProviders;
    }

    public PatientProviders fetchMentalHealthProviders(String patientId, DateFilter filter, String facilitySiteCode) {
        MockDataStorage<PatientProviders, PatientProvider> data1 = init(patientId, facilitySiteCode);

        PatientProviders providers = data1.getDataForPatient(patientId);
        PatientProviders filteredProviders1 = new PatientProviders();

        for (PatientProvider provider : providers) {
            if (NullChecker.isNotNullish(provider.getPersonClass())) {
                filteredProviders1.add(provider);
            }
        }
        PatientProviders filteredProviders = filteredProviders1;

        return DateFilterer.filterByDate(filteredProviders, filter);
    }

	@Override
	public PatientProviders fetchPrimaryCareProviders(PatientIdentifier patientIdentifier, String siteCode) {
//		if(siteCode == null)
//			throw new RuntimeException("Your code has a bug; site/facility code must be provided");
		
		PatientProviders providers = fetchPrimaryCareProviders(patientIdentifier.getUniqueId());
		
		// TODO filter by site code
		
		return providers;
	}

}
