package com.agilex.healthcare.mobilehealthplatform.datalayer.problem;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.utility.DateHelper;

public class ProblemDataLayerMock implements ProblemDataLayer {
	private Problems problemDataStore = null;

	public ProblemDataLayerMock() {
		problemDataStore = initializeProblemDataStore();
	}

	private Problems initializeProblemDataStore() {
		Problems problems = new Problems();
		
		Problem p;
		p = new Problem();
		p.setPatientId("D123401");
		p.setProblemId("1");
		p.setDescription("ankle joint pain");
		p.setActive(true);
		p.setOnsetDate(DateHelper.parseDate("10/29/2010"));
		problems.add(p);

		p = new Problem();
		p.setPatientId("D123401");
		p.setProblemId("2");
		p.setDescription("accident caused by earth moving machine");
		p.setOnsetDate(DateHelper.parseDate("10/29/2010"));
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("D123401");
		p.setProblemId("3");
		p.setDescription("UPPER RESPIRATORY INFECTION ACUTE");
		p.setOnsetDate(DateHelper.parseDate("1/5/2011"));
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("D123401");
		p.setProblemId("4");
		p.setDescription("ACUTE ABDOMEN");
		p.setOnsetDate(DateHelper.parseDate("1/1/2010"));
		p.setActive(false);
		p.setComments("meds given");
		problems.add(p);

		p = new Problem();
		p.setPatientId("D123401");
		p.setProblemId("4");
		p.setDescription("DRUG TOXICITY RESPIRATORY MEDS ANTI-COMMON COLD MEDICATIONS");
		p.setOnsetDate(DateHelper.parseDate("1/1/2010"));
		p.setActive(false);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID2"); // mike jones
		p.setProblemId("3");
		p.setDescription("ACUTE AND CHRONIC RESPIRATORY FAILURE");
		// p.setOnsetDate(DateHelper.parse("12/25/2010"));
		p.setComments("Breathing problems");
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID2"); // mike jones
		p.setProblemId("4");
		p.setDescription("ACUTE BRONCHITIS SEPTIC");
		p.setActive(true);
		p.setOnsetDate(DateHelper.parseDate("1/27/2011"));
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID2"); // mike jones
		p.setProblemId("5");
		p.setDescription("sore throat");
		// p.setOnsetDate(DateHelper.parse("12/25/2010"));
		p.setComments(null);
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID3"); // mike ashford
		p.setProblemId("6");
		p.setDescription("ankle joint pain");
		p.setOnsetDate(DateHelper.parseDate("11/29/2010"));
		p.setComments(null);
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID3"); // mike ashford
		p.setProblemId("7");
		p.setDescription("accident caused by earth moving machine");
		p.setOnsetDate(DateHelper.parseDate("11/29/2010"));
		p.setComments("serious accident");
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID3"); // mike ashford
		p.setProblemId("8");
		p.setDescription("UPPER RESPIRATORY INFECTION ACUTE");
		p.setOnsetDate(DateHelper.parseDate("1/5/2011"));
		p.setComments(null);
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID3"); // mike ashford
		p.setProblemId("9");
		p.setDescription("ACUTE ABDOMEN");
		p.setOnsetDate(DateHelper.parseDate("1/1/2010"));
		p.setComments("Meds given");
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID3"); // mike ashford
		p.setProblemId("10");
		p.setDescription("DRUG TOXICITY RESPIRATORY MEDS ANTI-COMMON COLD MEDICATIONS");
		p.setOnsetDate(DateHelper.parseDate("1/1/2010"));
		p.setComments(null);
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID3"); // mike ashford
		p.setProblemId("11");
		p.setDescription("ACUTE AND CHRONIC RESPIRATORY FAILURE");
		// p.setOnsetDate(DateHelper.parse("1/1/2010"));
		p.setComments("Breathing problems");
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID3"); // mike ashford
		p.setProblemId("12");
		p.setDescription("ACUTE BRONCHITIS SEPTIC");
		p.setOnsetDate(DateHelper.parseDate("1/27/2011"));
		p.setComments(null);
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID3"); // mike ashford
		p.setProblemId("13");
		p.setDescription("sore throat");
		// p.setOnsetDate(DateHelper.parse("1/1/2010"));
		p.setComments(null);
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID3"); // mike ashford
		p.setProblemId("14");
		p.setDescription("ANEMIA HEMOLYTIC ACQUIRED WARM ANTIBODY IMMUNOHEMOLYTIC");
		p.setOnsetDate(DateHelper.parseDate("12/18/2000"));
		p.setComments(null);
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID3"); // mike ashford
		p.setProblemId("15");
		p.setDescription("BACTERIAL PNEUMONIA LEGIONNAIRE'S DISEASE");
		p.setOnsetDate(DateHelper.parseDate("1/27/2011"));
		p.setComments(null);
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID3"); // mike ashford
		p.setProblemId("16");
		p.setDescription("COMMON COLD");
		// p.setOnsetDate(DateHelper.parse("1/1/2010"));
		p.setComments(null);
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID44"); // Dillon      
		p.setProblemId("17");
		p.setDescription("ANEMIA HEMOLYTIC ACQUIRED WARM ANTIBODY IMMUNOHEMOLYTIC");
		p.setOnsetDate(DateHelper.parseDate("07/18/2005"));
		p.setComments(null);
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID43"); // Mary      
		p.setProblemId("18");
		p.setDescription("Common Cold");
		p.setOnsetDate(DateHelper.parseDate("12/10/2009"));
		p.setComments(null);
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID26");
		p.setProblemId("PATID26.1");
		p.setDescription("Hypertension");
		p.setOnsetDate(DateHelper.parseDate("1/1/2010"));
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID26");
		p.setProblemId("PATID26.2");
		p.setDescription("Diabetes");
		p.setOnsetDate(DateHelper.parseDate("1/1/2010"));
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID26");
		p.setProblemId("PATID26.3");
		p.setDescription("Coronary Artery Disease");
		p.setOnsetDate(DateHelper.parseDate("1/1/2010"));
		p.setActive(true);
		problems.add(p);

		p = new Problem();
		p.setPatientId("PATID56");
		p.setProblemId("PATID56.1");
		p.setDescription("Hypertension");
		p.setOnsetDate(DateHelper.parseDate("1/1/2010"));
		p.setActive(true);
		problems.add(p);
        
		p = new Problem();
		p.setPatientId("PATID31");
		p.setProblemId("PATID31.1");
		p.setDescription("Hypertension");
		p.setOnsetDate(DateHelper.parseDate("1/1/2010"));
		p.setActive(true);
		problems.add(p);
        
		p = new Problem();
		p.setPatientId("PATID31");
		p.setProblemId("PATID31.2");
		p.setDescription("Diabetes");
		p.setOnsetDate(DateHelper.parseDate("1/1/2010"));
		p.setActive(true);
		problems.add(p);
        
		p = new Problem();
		p.setPatientId("PATID31");
		p.setProblemId("PATID31.3");
		p.setDescription("Coronary Artery Disease");
		p.setOnsetDate(DateHelper.parseDate("1/1/2010"));
		p.setActive(true);
		problems.add(p);
		
		p = new Problem();
		p.setPatientId("PATID33");
		p.setProblemId("PATID33.1");
		p.setDescription("Hypertension");
		p.setOnsetDate(DateHelper.parseDate("1/1/2010"));
		p.setActive(true);
		problems.add(p);
        
		for (Problem problem : problems) {
			problem.setSourceSystem("mock");
		}

		return problems;
	}

	public Problems fetchProblems(String patientId) {
		Problems patientProblems = new Problems();
		for (Problem problem : problemDataStore) {
			if (problem.getPatientId().contentEquals(patientId) && problem.isActive())
				patientProblems.add(problem);
		}
		return patientProblems;
	}

	public Problems fetchProblems(String patientId, DateFilter dateFilter) {
		Problems problems = fetchProblems(patientId);
		return DateFilterer.filterByDate(problems, dateFilter);
	}

	@Override
	public Problems fetchProblems(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		return fetchProblems(patientIdentifier.getUniqueId(), dateFilter);
	}
	
	
}
