package com.agilex.healthcare.mobilehealthplatform.datalayer.problem;

import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElement;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElementDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElements;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;

public class ProblemDataLayerExcel implements ProblemDataLayer {

	private static final String COLUMN_PATIENTID = "PatientID";
	private static final String COLUMN_PROBLEMID = "ProblemID";
	private static final String COLUMN_DESCRIPTION = "Description";
	private static final String COLUMN_ACTIVE = "Active";
	private static final String COLUMN_ONSETDATE = "OnsetDate";
	private static final String COLUMN_COMMENTS = "Comments";
	private static final String domain = "Problems";

	
	public Problems fetchProblems(String patientId) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();
		DataElements dataElements = storage.getData(patientId, domain);
		return createActiveProblems(dataElements);
	}
	
	public Problems fetchProblems(String patientId, DateFilter dateFilter) {
		Problems problems = fetchProblems(patientId);
		return DateFilterer.filterByDate(problems, dateFilter);
	}

	private Problems createActiveProblems(DataElements dataElements) {
		Problems problems = new Problems();
		for (DataElement dataElement : dataElements) {
			Problem problem = createProblem(dataElement);
			if (problem.isActive()) {
				problems.add(problem);
			}
		}
		return problems;
	}

	private Problem createProblem(DataElement dataElement) {
		Problem problem = new Problem();
		problem.setPatientId(dataElement.getValue(COLUMN_PATIENTID));
		problem.setProblemId(dataElement.getValue(COLUMN_PROBLEMID));
		problem.setDescription(dataElement.getValue(COLUMN_DESCRIPTION));
		problem.setActive(dataElement.getValueAsBoolean(COLUMN_ACTIVE));
		problem.setOnsetDate(dataElement.getValueAsDate(COLUMN_ONSETDATE));
		problem.setComments(dataElement.getValue(COLUMN_COMMENTS));
		problem.getDataIdentifier().setSystemId("mock");
		return problem;
	}

	@Override
	public Problems fetchProblems(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		return fetchProblems(patientIdentifier.getUniqueId(), dateFilter);
	}

}
