package com.agilex.healthcare.mobilehealthplatform.datalayer.patient.excel;

import jxl.Sheet;

import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.utility.NullChecker;

public class PatientExcelParser extends ExcelCollectionParser<Patients, Patient> {

	@Override
	protected Patients createNewCollection() {
		return new Patients();
	}

	@Override
	protected Patient createNewItem(Sheet sheet, int row) {
		Patient p = new Patient();
		p.setId(super.getValue(sheet, "id", row));
		p.setLastName(super.getValue(sheet, "lastname", row));
		p.setFirstName(super.getValue(sheet, "firstname", row));
		p.setMiddleName(super.getValue(sheet, "middlename", row));
		p.setGender(super.getValue(sheet, "gender", row));
		p.setSsn(super.getValue(sheet, "ssn", row));

		String dob = super.getValue(sheet, "dateOfBirth", row);
		if (NullChecker.isNotNullish(dob)) {
			DOBDate dobDate = new DOBDate("MM/dd/yyyy", dob);
			p.setDateOfBirth(dobDate);
		}
		return p;
	}

}
