package com.agilex.healthcare.mobilehealthplatform.datalayer.patient.excel;

import jxl.Sheet;

import com.agilex.healthcare.mobilehealthplatform.domain.Address;
import com.agilex.healthcare.mobilehealthplatform.domain.NextOfKin;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.utility.NullChecker;

public class PatientDemographicsExcelParser extends ExcelDataParser<PatientDemographics> {

	@Override
	protected PatientDemographics createNewItem(Sheet sheet, int row) {
		PatientDemographics d = new PatientDemographics();

		d.setAddress(parseDemographics(sheet, row));
		d.setNextOfKin(parseNextOfKin(sheet, row));
		
		d.setPhoneNumberHome(getValue(sheet, "phoneNumberHome", row));
		d.setPhoneNumberWork(getValue(sheet, "phoneNumberWork", row));
		d.setPhoneNumberPager(getValue(sheet, "phoneNumberPager", row));
		d.setPhoneNumberMobile(getValue(sheet, "phoneNumberMobile", row));

		
		return d;

	}

	private NextOfKin parseNextOfKin(Sheet sheet, int row) {
		NextOfKin nok = null;
		String nokName = getValue(sheet,"NextOfKinName", row);
		String nokPhone = getValue(sheet,"NextOfKinPhone", row);
		String nokRelationship = getValue(sheet,"NextOfKinRelationship", row);
		if (isValid(nokName,nokPhone,nokRelationship)) { 
			nok = new NextOfKin();
			nok.setName(nokName);
			nok.setPhoneNumber(nokPhone);nok.setRelationship(nokRelationship);
		}
		return nok;
	}

	private Address parseDemographics(Sheet sheet, int row) {
		Address address = null;
		String streetAddressLine1 = getValue(sheet, "streetAddressLine1", row);
		String streetAddressLine2 = getValue(sheet, "streetAddressLine2", row);
		String streetAddressLine3 = getValue(sheet, "streetAddressLine3", row);
		String city = getValue(sheet, "city", row);
		String state = getValue(sheet, "state", row);
		String zip = getValue(sheet, "zip", row);
		if (isValid(streetAddressLine1, streetAddressLine2, streetAddressLine3, city, state, zip)) {
			address = new Address();
			address.setStreetAddressLine1(streetAddressLine1);
			address.setStreetAddressLine2(streetAddressLine2);
			address.setStreetAddressLine3(streetAddressLine3);
			address.setCity(city);
			address.setState(state);
			address.setZipCode(zip);
		}
		return address;
	}

	private boolean isValid(String... value) {
		boolean isValid = true;
		for (int i = 0; i < value.length; i++)
			isValid = isValid && NullChecker.isNotNullish(value[i]);
		return isValid;
	}

}
