package com.agilex.healthcare.mobilehealthplatform.datalayer.patient.excel;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.MemoryPatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

public class PatientDataLayerExcel extends MemoryPatientDataLayer {
	private static final String PATIENT_RESOURCE_FILE = "patients.xls";

	@Override
	protected Patients initializePatientStore() {
		PatientExcelParser parser = new PatientExcelParser();
		Patients patients = parser.getDataCollection(PATIENT_RESOURCE_FILE);
		return patients;
	}

	@Override
	public PatientDemographics getDemographics(PatientIdentifier patientIdentifier) {
		PatientDemographicsExcelParser parser = new PatientDemographicsExcelParser();
		PatientDemographics demographics = parser.getData(PATIENT_RESOURCE_FILE, patientIdentifier.getUniqueId());
		return demographics;
	}

}
