package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class PatientSupplementalDemographicsDataLayerMock implements PatientSupplementalDemographicsDataLayer {

	Map<String, PatientDemographics> demographicStorage = new ConcurrentHashMap<String, PatientDemographics>();
	
	public PatientSupplementalDemographicsDataLayerMock() {
		init(new PatientIdentifier("EDIPI", "D123401"));
		init(new PatientIdentifier("EDIPI", "PATID26"));
		init(new PatientIdentifier("EDIPI", "PATID65"));
		init(new PatientIdentifier("EDIPI", "PATID76"));
		init(new PatientIdentifier("EDIPI", "TSTGRP01"));
		init(new PatientIdentifier("EDIPI", "TSTGRP02"));
		init(new PatientIdentifier("EDIPI", "TSTGRP03"));
		init(new PatientIdentifier("EDIPI", "TSTGRP04"));
		init(new PatientIdentifier("EDIPI", "TSTGRP05"));
		init(new PatientIdentifier("EDIPI", "TSTGRP06"));
		init(new PatientIdentifier("EDIPI", "TSTGRP07"));
		init(new PatientIdentifier("EDIPI", "TSTGRP08"));
		init(new PatientIdentifier("EDIPI", "TSTGRP09"));
		init(new PatientIdentifier("EDIPI", "TSTGRP10"));
		init(new PatientIdentifier("EDIPI", "TSTGRP11"));
		init(new PatientIdentifier("EDIPI", "TSTGRP12"));
		init(new PatientIdentifier("EDIPI", "0010010010"));
		init(new PatientIdentifier("EDIPI", "0010010011"));
	}
	
	private void init(PatientIdentifier patientIdentifier) {
		PatientDemographics demographics = new PatientDemographics();
		demographics.setPatientIdentifier(patientIdentifier);
		
		NextOfKin nextOfKin = new NextOfKin();
		
		nextOfKin.setName("Kin, Next "+patientIdentifier);
		nextOfKin.setStreetAddressLine1("123 Supplemental Demo St");
		nextOfKin.setStreetAddressLine2("Mock, CA 99999");
		nextOfKin.setPhoneNumber("(000)000-0000");
		nextOfKin.setPhoneNumberWork("(111)111-1111");
		nextOfKin.setRelationship("Third Cousin");
		demographics.setNextOfKin(nextOfKin);
		
		Addresses addresses = new Addresses();
		Address address = new Address();
		for(int i = 0; i < 3; i++) {
			address.setAddressType("Temporary");
			address.setStreetAddressLine1(String.format("%s Street Address", Integer.toString(i)));
			address.setStreetAddressLine2(String.format("Suite %s000", Integer.toString(i)));
			address.setStreetAddressLine3(String.format("Box %s0000", Integer.toString(i)));
			address.setZipCode(String.format("%s00000-0000", Integer.toString(i)));
			addresses.add(address);
		}
        address.setStreetAddressLine1("0 Street Address");
        address.setStreetAddressLine2("Suite 500");
        address.setStreetAddressLine3("Box 1234");
        address.setCity("Mock");
        address.setState("CA");
        address.setZipCode("20151-4657");
		address.setAddressType("Permanent");
		demographics.setAddress(address);
		
		demographics.setAddresses(addresses);
		
		PhoneNumbers phoneNumbers = new PhoneNumbers();
		PhoneNumber phoneNumber1 = new PhoneNumber();
		phoneNumber1.setNumber("(000)000-0000");
		phoneNumber1.setType("Home");
		phoneNumbers.add(phoneNumber1);
		demographics.setPhoneNumberHome(phoneNumber1.getNumber());
		
		PhoneNumber phoneNumber2 = new PhoneNumber();
		phoneNumber2.setNumber("(111)111-1111");
		phoneNumber2.setType("Business");
		phoneNumbers.add(phoneNumber2);
		demographics.setPhoneNumberWork(phoneNumber2.getNumber());
		
		PhoneNumber phoneNumber3 = new PhoneNumber();
		phoneNumber3.setNumber("(222)222-2222");
		phoneNumber3.setType("Business");
		phoneNumbers.add(phoneNumber3);
		demographics.setPhoneNumberMobile(phoneNumber3.getNumber());
		
		
		PhoneNumber phoneNumber4 = new PhoneNumber();
		phoneNumber4.setNumber("(333)333-3333");
		phoneNumber4.setType("Pager");
		phoneNumbers.add(phoneNumber4);
		demographics.setPhoneNumberPager(phoneNumber4.getNumber());
		
		demographics.setPhoneNumbers(phoneNumbers);
		
		demographicStorage.put(patientIdentifier.getUniqueId(), demographics);
	}
	
	@Override
	public PatientDemographics fetchDemographics(PatientIdentifier patientIdentifier) {
		PatientDemographics demographics = demographicStorage.get(patientIdentifier.getUniqueId());
		
		if(demographics == null) 
			demographics = new PatientDemographics();
		
		return demographics;
	}

	@Override
	public NextOfKin fetchPatientNextOfKin(PatientIdentifier patientIdentifier) {
		PatientDemographics demographics = fetchDemographics(patientIdentifier);
		return demographics.getNextOfKin();
	}

	@Override
	public PatientDemographics fetchPatientContactInformation(PatientIdentifier patientIdentifier) {
		return fetchDemographics(patientIdentifier);
	}

}
