package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElement;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElementDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElements;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientMetadata;

public class PatientMetadataDataLayerExcel implements PatientMetadataDataLayer {
	private static final String DOMAIN = "PatientMetadata";
	private static final String COLUMN_PATIENTID = "PatientId";
	private static final String COLUMN_APPTREQACCESSDATE = "LastApptReqAccessDate";


	private static List<PatientMetadata> patientMetadataList;

	public PatientMetadataDataLayerExcel() {
		synchronized (this) {
			if (patientMetadataList == null) {
				patientMetadataList = new LinkedList<PatientMetadata>();
				DataElementDataStorage storage = DataElementDataStorage.getInstance();;
				DataElements dataElements = storage.getData(DOMAIN, DOMAIN);
				createPatientMetadataList(dataElements);
			}
		}
	}

	private void createPatientMetadataList(DataElements dataElements) {
		for (DataElement dataElement : dataElements) {
			patientMetadataList.add(createPatientMetadata(dataElement));
		}
	}
	
	private PatientMetadata createPatientMetadata(DataElement dataElement){
		PatientMetadata patientMetadata = new PatientMetadata();
		patientMetadata.setPatientId(dataElement.getValue(COLUMN_PATIENTID));
		patientMetadata.setLastAppointmentRequestAccessDate(dataElement.getValueAsDateTime(COLUMN_APPTREQACCESSDATE));
		return patientMetadata;
	}
	
	@Override
	public List<PatientMetadata> fetchPatientMetadataList() {
		return patientMetadataList;
	}

	@Override
	public PatientMetadata savePatientMetadata(PatientMetadata patientMetadata) {
		if (patientMetadata.getPatientId() != null) {
			Iterator<PatientMetadata> iterator = patientMetadataList.iterator();
			while (iterator.hasNext()) {
				PatientMetadata metadata = iterator.next();
				if (patientMetadata.getPatientId().equals(metadata.getPatientId())) {
					iterator.remove();
					break;
				}
			}
			patientMetadataList.add(patientMetadata);
		}
		
		return patientMetadata;
	}

	@Override
	public PatientMetadata fetchPatientMetadataByPatientId(String patientId) {
		PatientMetadata result = null;
		for (PatientMetadata patientMetadata : patientMetadataList) {
			if (patientId != null && patientId.equals(patientMetadata.getPatientId())) {
				result = patientMetadata;
				break;
			}
		}
		
		if (result == null) {
			throw new WebApplicationException(Status.NOT_FOUND);
		}
		
		return result;
	}
}
