package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElement;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElementDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElements;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientEdipiIcn;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

public class PatientInternalDataLayerExcel implements PatientInternalDataLayer{
	
	private static final String domain = "Patients";
	private static final String COLUMN_PATIENTID = "PatientId";
	private static final String COLUMN_FIRSTNAME = "FirstName";
	private static final String COLUMN_LASTNAME = "LastName";
	private static final String COLUMN_TEXTMESSAGINGALLOWED = "TextMessagingAllowed";
	private static final String COLUMN_TEXTMESSAGINGPHONENUMBER = "TextMessagingPhoneNumber";

	private static Patients patients;

	public PatientInternalDataLayerExcel() {
		synchronized (this) {
			if (patients == null) {
				patients = new Patients();
				DataElementDataStorage storage = DataElementDataStorage.getInstance();;
				DataElements dataElements = storage.getData(domain, domain);
				createPatients(dataElements);
			}
		}
	}

	private void createPatients(DataElements dataElements) {
		for (DataElement dataElement : dataElements) {
			patients.add(createPatient(dataElement));
		}
	}
	
	private Patient createPatient(DataElement dataElement){
		Patient patient = new Patient();
		patient.setId(dataElement.getValue(COLUMN_PATIENTID));
		patient.setFirstName(dataElement.getValue(COLUMN_FIRSTNAME));
		patient.setLastName(dataElement.getValue(COLUMN_LASTNAME));
		patient.setTextMessagingAllowed(dataElement.getValueAsBoolean(COLUMN_TEXTMESSAGINGALLOWED));
		patient.setTextMessagingPhoneNumber(dataElement.getValue(COLUMN_TEXTMESSAGINGPHONENUMBER));
		return patient;
	}

	@Override
	public Patients fetchPatients() {
		return patients;
	}

	@Override
	public Patient fetchPatientById(String patientId) {
		Patient match = null;

		for (Patient patient : patients) {
			if (patient.getId().equals(patientId)) {
				match = patient;
				break;
			}
		}
		
		if (match == null) {
			throw new WebApplicationException(Status.NOT_FOUND);
		}
		
		return match;
	}

	@Override
	public Patient savePatient(Patient patient) {
		Patient existingPatient = fetchPatientById(patient.getId());
		
		if (existingPatient != null) {
			existingPatient.setFirstName(patient.getFirstName());
			existingPatient.setLastName(patient.getLastName());
			existingPatient.setTextMessagingAllowed(patient.isTextMessagingAllowed());
			existingPatient.setTextMessagingPhoneNumber(patient.getTextMessagingPhoneNumber());
			
			return existingPatient;
		} else {
			Patient newPatient = new Patient();
			newPatient.setFirstName(patient.getFirstName());
			newPatient.setLastName(patient.getLastName());
			newPatient.setTextMessagingAllowed(patient.isTextMessagingAllowed());
			newPatient.setTextMessagingPhoneNumber(patient.getTextMessagingPhoneNumber());
			
			patients.add(newPatient);
			
			return newPatient;
		}
	}
	

	@Override
	public void removePatient(String patientId) {
		Iterator<Patient> iterator = patients.iterator();
		
		while (iterator.hasNext()) {
			Patient patient = iterator.next();
			if (patient.getId().equals(patientId)) {
				iterator.remove();
				break;
			}
		}
	}

	@Override
	public List<PatientEdipiIcn> savePatientICN(Collection<PatientEdipiIcn> patientEdipiIcns) {
		// TODO Auto-generated method stub
		return null;
	}
}
