package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.Map;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.utility.NullChecker;

public class PatientDataLayerMock extends MemoryPatientDataLayer {

	@Override
	public PatientDemographics getDemographics(PatientIdentifier patientIdentifier) {
		if (NullChecker.isNullish(patientIdentifier.getUniqueId())) {
			return null;
		}

		return readPatientDemographicsFromAppContext().get(patientIdentifier.getUniqueId());
	}

	@Override
	protected Patients initializePatientStore() {
		return readPatientsFromAppContext();
	}

	private static Patients readPatientsFromAppContext() {
		ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext(new String[] { "mockData.xml" });
		BeanFactory factory = (BeanFactory) appContext;
		Patients patientsFromAppContext = (Patients) factory.getBean("patients");
		return patientsFromAppContext;
	}

	private Map<String, PatientDemographics> readPatientDemographicsFromAppContext() {
		ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext(new String[] { "mockData.xml" });
		BeanFactory factory = (BeanFactory) appContext;
		@SuppressWarnings("unchecked")
		Map<String, PatientDemographics> extendedData = (Map<String, PatientDemographics>) factory.getBean("patientDemographics");
		return extendedData;
	}

	@Override
	public Patient getPatient(PatientIdentifier patientIdentifier) {
		Patient patient = super.getPatient(patientIdentifier);
		if (patient == null) {
			// in dev/mock mode, we often need to create patients on the fly. If
			// no patient found, just return a new one
			patient = new Patient();
			patient.setLastName(patientIdentifier.getUniqueId());
			patient.setFirstName("Mock");
			patient.setId(patientIdentifier.getUniqueId());
		}
		return patient;
	}
}