package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.regex.Pattern;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.utility.NullChecker;

public class MockPatientUtility {
	public static boolean isDifferent(Patient potentialMatch, PatientSearchCriteria criteria) {
		boolean isDifferentValue = false;

		Patient prototype = criteria.getPrototype();

		if (prototype != null) {
			isDifferentValue = isDifferentValue || isDifferent(potentialMatch.getLastName(), prototype.getLastName());
			isDifferentValue = isDifferentValue || isDifferent(potentialMatch.getFirstName(), prototype.getFirstName());
			isDifferentValue = isDifferentValue || isDifferent(potentialMatch.getId(), prototype.getId());
			isDifferentValue = isDifferentValue || isDifferent(formatSsn(potentialMatch.getSsn()), formatSsn(prototype.getSsn()));
		}
		isDifferentValue = isDifferentValue || isDifferent(extractLastInitialLastFourOfSsn(potentialMatch), criteria.getLastInitialPlusLastFourOfSsn());
		isDifferentValue = isDifferentValue || isDifferent(extractLastFourOfSsn(potentialMatch), criteria.getLastFourOfSsn());

		return isDifferentValue;
	}
	
	private static boolean isDifferent(String potentialMatch, String prototype) {
		boolean isDifferentValue;
		if (prototype == null) {
			isDifferentValue = false;
		} else if (potentialMatch == null) {
			isDifferentValue = true;
		} else {
			isDifferentValue = !(potentialMatch.equalsIgnoreCase(prototype));
		}
		return isDifferentValue;
	}
	
	private static String extractLastInitialLastFourOfSsn(Patient patient) {
		Pattern isValidSsnPattern = Pattern.compile("[0-9]{9}|([0-9]{3}-[0-9]{2}-[0-9]{4})", Pattern.CASE_INSENSITIVE);
		String ssn = patient.getSsn();
		String key = null;
		if (NullChecker.isNotNullish(patient.getLastName()) && NullChecker.isNotNullish(ssn) && isValidSsnPattern.matcher(ssn).matches()) {
			String lastFour = ssn.substring(ssn.length() - 4);
			String initial = patient.getLastName().substring(0, 1);
			key = initial + lastFour;
		}
		return key;
	}

	private static String extractLastFourOfSsn(Patient patient) {
		Pattern isValidSsnPattern = Pattern.compile("[0-9]{9}|([0-9]{3}-[0-9]{2}-[0-9]{4})", Pattern.CASE_INSENSITIVE);
		String ssn = patient.getSsn();
		String lastFour = null;
		if (NullChecker.isNotNullish(patient.getLastName()) && NullChecker.isNotNullish(ssn) && isValidSsnPattern.matcher(ssn).matches()) {
			lastFour = ssn.substring(ssn.length() - 4);
		}
		return lastFour;
	}

	private static String formatSsn(String ssn) {
		if (NullChecker.isNotNullish(ssn))
			ssn = ssn.replace("-", "");
		return ssn;
	}

}
