package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.utility.NullChecker;

public abstract class MemoryPatientDataLayer implements PatientDataLayer {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(MemoryPatientDataLayer.class);

	private static Patients patientRepository;

	protected abstract Patients initializePatientStore();

	protected synchronized Patients getPatientRepository() {
		if (patientRepository == null)
			patientRepository = initializePatientStore();
		return patientRepository;
	}

	@Override
	public Patients patientSearch(PatientSearchCriteria criteria) {
		LOGGER.debug("begin patient search");
		// Timing t = Timing.getInstance("mockdatalayer.patientsearch");

		Patients matchingPatients = new Patients();

		if (criteria == null) {
			// Insufficient input
			LOGGER.debug("insufficient input criteria [null]");
		} else if (!sufficientInput(criteria)) {
			// Insufficient input
			LOGGER.debug("insufficient input criteria");
		} else {
			if (NullChecker.isNotNullish(criteria.getSearchString()) && criteria.getSearchString().contentEquals("ERROR"))
				throw new RuntimeException("Returning an error that can be used in testing.");

			findMatchingPatients(criteria, matchingPatients);
		}

		// t.markComplete(ClosingStatus.Success);
		LOGGER.debug("end patient search");
		return matchingPatients;
	}

	private void findMatchingPatients(PatientSearchCriteria criteria, Patients matchingPatients) {
		LOGGER.debug("finding matching patients");
		for (Patient potentialMatch : getPatientRepository()) {
			if (!MockPatientUtility.isDifferent(potentialMatch, criteria)) {
				LOGGER.debug("found match, " + potentialMatch.toString());
				matchingPatients.add(potentialMatch);
			}
		}
	}

	private boolean sufficientInput(PatientSearchCriteria criteria) {
		boolean sufficientInputValue = false;

		Patient prototype = criteria.getPrototype();
		if (prototype != null) {
			sufficientInputValue = sufficientInputValue || NullChecker.isNotNullish(prototype.getId());
			sufficientInputValue = sufficientInputValue || NullChecker.isNotNullish(prototype.getLastName());
			sufficientInputValue = sufficientInputValue || NullChecker.isNotNullish(prototype.getFirstName());
			sufficientInputValue = sufficientInputValue || NullChecker.isNotNullish(prototype.getSsn());
		}
		sufficientInputValue = sufficientInputValue || NullChecker.isNotNullish(criteria.getLastInitialPlusLastFourOfSsn());
		sufficientInputValue = sufficientInputValue || NullChecker.isNotNullish(criteria.getLastFourOfSsn());
		return sufficientInputValue;
	}

	@Override
	public Patient getPatient(PatientIdentifier patientIdentifier) {
		Patient prototype = new Patient();
		prototype.setId(patientIdentifier.getUniqueId());
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setPrototype(prototype);

		Patients searchResults = this.patientSearch(criteria);
		Patient result = null;
		if ((searchResults != null) && (searchResults.size() > 0)) {
			result = searchResults.get(0);
		}
		return result;
	}
}