package com.agilex.healthcare.mobilehealthplatform.datalayer.paingoal;

import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.datalayer.paingoals.PainGoalsDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.utility.*;

public class PainGoalsDataLayerMock implements PainGoalsDataLayer {
	private PainGoals painGoalsDataStore = null;

	public PainGoalsDataLayerMock() {
		painGoalsDataStore = initializeDataStore();
	}

	private PainGoals initializeDataStore() {
		PainGoals goals = new PainGoals();
		PainGoal g;

		g = new PainGoal();
		g.setUniqueId("1");
		g.setPatientId("D123401");
		g.setName("Swim a mile.");
		g.setStatus(PainGoalStatus.PainGoalStatusComplete);
		g.setDateStarted(DateHelper.parseDate("06/21/2011"));
		g.setPercentComplete("100");
		g.setGoalType("Veteran");
		g.setDetails("Swim a continous mile.");
		g.setNextActionStep("Swim a lap");
		g.setTargetDate(DateHelper.parseDate("10/31/2012"));

		goals.add(g);

		g = new PainGoal();
		g.setUniqueId("2");
		g.setPatientId("D123401");
		g.setName("Lose 10 lbs");
		g.setStatus(PainGoalStatus.PainGoalStatusActive);
		g.setDateStarted(DateHelper.parseDate("08/31/2012"));
		g.setPercentComplete("20");
		g.setGoalType("Veteran");
		g.setDetails("Eat less and exercise more.");
		g.setNextActionStep("Drank health smoothie for lunch today");
		g.setTargetDate(DateHelper.parseDate("11/15/2012"));

		PainGoalEntries painGoalEntries = new PainGoalEntries();
		PainGoalEntry entry = new PainGoalEntry();
		entry.setComments("Drank health smoothie for lunch today");
		entry.setPercentComplete("5");
		entry.setEntryDate(DateHelper.parseDate("09/05/2012"));
		painGoalEntries.add(entry);

		entry = new PainGoalEntry();
		entry.setComments("Did not eat dessert today");
		entry.setPercentComplete("10");
		entry.setEntryDate(DateHelper.parseDate("09/02/2012"));
		painGoalEntries.add(entry);

		g.setPainGoalEntries(painGoalEntries);

		goals.add(g);

		g = new PainGoal();
		g.setUniqueId("3");
		g.setPatientId("D123401");
		g.setName("Run a marathon");
		g.setStatus(PainGoalStatus.PainGoalStatusActive);
		g.setDateStarted(DateHelper.parseDate("09/01/2012"));
		g.setPercentComplete("20");
		g.setGoalType("Veteran");
		g.setDetails("Train for 3 months. Run 50 miles a week.");
		g.setNextActionStep("Run 4 miles");
		g.setTargetDate(DateHelper.parseDate("11/15/2012"));

		painGoalEntries = new PainGoalEntries();
		entry = new PainGoalEntry();
		entry.setComments("Buy running shoes");
		entry.setPercentComplete("5");
		entry.setEntryDate(DateHelper.parseDate("09/01/2012"));
		painGoalEntries.add(entry);

		entry = new PainGoalEntry();
		entry.setComments("Run 4 miles");
		entry.setPercentComplete("10");
		entry.setEntryDate(DateHelper.parseDate("09/02/2012"));
		painGoalEntries.add(entry);

		g.setPainGoalEntries(painGoalEntries);

		goals.add(g);

		g = new PainGoal();
		g.setUniqueId("4");
		g.setPatientId("D123401");
		g.setName("Do 10 pullups");
		g.setStatus(PainGoalStatus.PainGoalStatusComplete);
		g.setDateStarted(DateHelper.parseDate("08/01/2012"));
		g.setPercentComplete("100");
		g.setGoalType("Veteran");
		g.setDetails("Train upper body strength.");
		g.setNextActionStep("");
		g.setTargetDate(DateHelper.parseDate("12/10/2012"));

		goals.add(g);

		return goals;
	}

	@Override
	public PainGoals fetchPainGoals(String patientId) {

		PainGoals processedPainGoals = new PainGoals();

		for (PainGoal goal : painGoalsDataStore) {
			if (goal.getPatientId().contentEquals(patientId) && goal.getStatus() != PainGoalStatus.PainGoalStatusDeleted) {
				processedPainGoals.add(goal);
			}
		}
		return processedPainGoals;
	}

	@Override
	public PainGoals fetchPainGoals(String patientId, DateFilter dateFilter) {
		PainGoals painGoals = fetchPainGoals(patientId);
		return DateFilterer.filterByDate(painGoals, dateFilter);
	}

	@Override
	public PainGoal createNewPainGoal(PainGoal data) {
		data.setUniqueId(UUID.randomUUID().toString());
		data.setDateStarted(DateHelper.getToday());

		painGoalsDataStore.add(data);

		return data;
	}

	@Override
	public PainGoal updatePainGoal(PainGoal data) {
		PainGoal match = null;

		for (PainGoal g : painGoalsDataStore) {
			if (g.getUniqueId().equalsIgnoreCase(data.getUniqueId())) {
				match = g;
				break;
			}
		}

		PainGoalEntries goalEntries = match.getPainGoalEntries();

		if (NullChecker.isNotNullish(goalEntries)) {
			goalEntries.sortDescending("entryDate");

			PainGoalEntry goalEntryFromNextAction = new PainGoalEntry();
			goalEntryFromNextAction.setComments(data.getNextActionStep());
			goalEntryFromNextAction.setEntryDate(DateHelper.getToday());

			goalEntries.add(goalEntryFromNextAction);
		}

		data.setPainGoalEntries(goalEntries);

		if (match != null) {
			painGoalsDataStore.remove(match);
			painGoalsDataStore.add(data);
		}

		return null;
	}

	@Override
	public PainGoals fetchAllPainGoals(String patientId) {
		PainGoals processedPainGoals = new PainGoals();

		for (PainGoal goal : painGoalsDataStore) {
			if (goal.getPatientId().contentEquals(patientId)) {
				processedPainGoals.add(goal);
			}
		}
		return processedPainGoals;
	}

	@Override
	public PainGoals fetchAllPainGoals(String patientId, DateFilter dateFilter) {
		PainGoals painGoals = fetchAllPainGoals(patientId);
		return DateFilterer.filterByDate(painGoals, dateFilter);
	}

	@Override
	public PainGoalEntries fetchAllPainGoalEntries(String patientId, DataIdentifier dataIdentifier) {

		PainGoal match = new PainGoal();

		for (PainGoal goal : painGoalsDataStore) {
			if (goal.getDataIdentifier().getUniqueId().equalsIgnoreCase(dataIdentifier.getUniqueId())) {
				match = goal;
			}
		}

		return match.getPainGoalEntries();
	}

	@Override
	public PainGoalEntry createNewPainGoalEntry(PainGoalEntry data, String goalId) {
		return null;
	}

	@Override
	public PainGoalEntry updatePainGoalEntry(PainGoalEntry data, String goalId) {
		return null;
	}

	@Override
	public void deletePainGoalEntry(PainGoalEntry data, String goalId) {

	}

	@Override
	public PainGoal getPainGoal(String patientId, String dataId) {
		return null;
	}

	@Override
	public void deletePainGoal(PainGoal data) {

	}
}
