package com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary;

import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryReport;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import com.agilex.healthcare.utility.DateHelper;

public class PainDiaryDataLayerMock implements PainDiaryDataLayer {
	private PainDiaryEntries painDiaryEntryDataStore = null;
	
	public PainDiaryDataLayerMock() {
		painDiaryEntryDataStore = initializeDataStore();
	}
	
	private PainDiaryEntries initializeDataStore() {
		PainDiaryEntries entries = new PainDiaryEntries();
		PainDiaryEntry e;
		
		e = new PainDiaryEntry();
		e.setUniqueId("1");
		e.setPatientId("D123401");
		e.setDateCreated(DateHelper.parseDate("08/21/2012"));
		e.setDateCompleted(DateHelper.parseDate("08/22/2012"));
		
		PainDiaryReport report = new PainDiaryReport();
		report.setPainType("Chronic (greater than 3 months)");
		report.setImpactOnWalking("7");
		report.setAveragePainIntensity("3");
		e.setPainQuestionValues(report);		
		e.setCompleted(true);
		
		entries.add(e);
		
		
		e = new PainDiaryEntry();
		e.setUniqueId("2");
		e.setPatientId("D123401");
		e.setDateCreated(DateHelper.parseDate("08/20/2012"));
		
		report = new PainDiaryReport();
		report.setPainType("Chronic (greater than 3 months)");
		report.setDepressionLevel("4");
		report.setAveragePainIntensity("7");
		e.setPainQuestionValues(report);	
		e.setCompleted(false);
		
		entries.add(e);
		
		return entries;
	}
	
	@Override
	public PainDiaryEntries fetchPainDiaryEntries(String patientId) {
		PainDiaryEntries matches = new PainDiaryEntries();
		
		for (PainDiaryEntry e : painDiaryEntryDataStore) {
			if (e.getPatientId().contentEquals(patientId)) {
				matches.add(e);
			}
		}
		
		return matches;
	}

	@Override
	public PainDiaryEntries fetchPainDiaryEntries(String patientId,	DateFilter dateFilter) {
		PainDiaryEntries matches = fetchPainDiaryEntries(patientId);
		
		return DateFilterer.filterByDate(matches, dateFilter);
	}

	@Override
	public PainDiaryEntry fetchPainDiaryEntry(String patientId, String dataId) {
		
		PainDiaryEntry match = new PainDiaryEntry();
		
		for (PainDiaryEntry e : painDiaryEntryDataStore) {
			if (e.getPatientId().contentEquals(patientId) && e.getUniqueId().contentEquals(dataId)) {
				match = e;
				break;
			}
		}
		
		return match;
	}

	@Override
	public PainDiaryEntry createNewPainDiaryEntry(PainDiaryEntry data) {
		data.setDateCreated(DateHelper.getToday());
		data.setUniqueId(UUID.randomUUID().toString());
		
		if (data.isCompleted()) {
			data.setDateCompleted(DateHelper.getToday());
		}
		
		painDiaryEntryDataStore.add(data);
		
		return data;
	}

	@Override
	public PainDiaryEntry updatePainDiaryEntry(PainDiaryEntry data) {
		PainDiaryEntry match = null;
		
		for (PainDiaryEntry e : painDiaryEntryDataStore) {
			if (e.getUniqueId().equalsIgnoreCase(data.getUniqueId())) {
				match = e;
				break;
			}
		}
		
		if (match != null) {
			painDiaryEntryDataStore.remove(match);
			painDiaryEntryDataStore.add(data);
		}
		
		return null;
	}


}
