package com.agilex.healthcare.mobilehealthplatform.datalayer.notification;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.StringTruncator;

public class NotificationCommunicationDataLayerMock implements NotificationCommunicationDataLayer {

	private static final Logger LOGGER = Logger.getLogger(NotificationCommunicationDataLayerMock.class);
	private List<String> invalidTokens = new LinkedList<String>();

	public NotificationCommunicationDataLayerMock() {
		invalidTokens.add("fffffd904f7a06b52904cefe3ccc3df8f0a2e88bea9ab62939b5d3b2dd52710b");
	}

	/** {@inheritDoc}} */
	public List<String> send(String deviceToken, String message) {
		return send(new String[] { deviceToken }, message);
	}
	
	/** {@inheritDoc}} */
	public List<String> send(String[] deviceTokens, String message) {
		assert deviceTokens != null;
		assert deviceTokens.length > 0;
		assert NullChecker.isNotNullish(message);
		
		String truncatedMessage = StringTruncator.truncate(message, 160);
		
		LOGGER.info(String.format("Sending message [%s]", message));
		
		List<String> rejectedTokens = new LinkedList<String>();
		
		for (String deviceToken : deviceTokens) {
			if (invalidTokens.contains(deviceToken)){
				rejectedTokens.add(deviceToken);
				LOGGER.info(String.format("Invalid device token [%s]", deviceToken));
			}else{
				LOGGER.info(String.format("Sending truncated message [%s] to device token [%s]", truncatedMessage, deviceToken));
			}
		}
		
		return rejectedTokens;
	}

	/** {@inheritDoc}} */
	public List<String> fetchInvalidDeviceTokens() {
		LOGGER.info("Fetching invalid device tokens!  Mock data is returning empty list.");
		return new LinkedList<String>();
	}

}
