package com.agilex.healthcare.mobilehealthplatform.datalayer.mygoals;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import org.joda.time.DateTime;

import com.agilex.healthcare.mobilehealthplatform.domain.Mygoals;
import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsList;
import com.agilex.healthcare.mobilehealthplatform.enumeration.MygoalsInventoryType;

public class MygoalsDataLayerMock implements MygoalsDataLayer {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MygoalsDataLayerMock.class);
	private Map<String, MygoalsList> mockStorage = new HashMap<String, MygoalsList>();
	private Map<String, MygoalsList> questionKeyMygoalsMap = new HashMap<String, MygoalsList>();
	
	public MygoalsDataLayerMock() {
		initMap();
	}

	private void initMap() {
		String patientId;
		DateTime today = new DateTime();
		Date twoWeeksAgo = today.minusDays(14).toDate();
		
		// ALDIE DATA
		patientId = "PATID26";
		MygoalsList mygoalsList = new MygoalsList();
		Mygoals fs_FirstQuestion = createMygoals(patientId, "FS_Q1", MygoalsInventoryType.FEELINGS.name(), "4", twoWeeksAgo, 20);
		mygoalsList.add(fs_FirstQuestion);
		Mygoals fs_SecondQuestion = createMygoals(patientId, "FS_Q2", MygoalsInventoryType.FEELINGS.name(), "6", twoWeeksAgo, 20);
		mygoalsList.add(fs_SecondQuestion);
		Mygoals fs_ThirdQuestion = createMygoals(patientId, "FS_Q3",MygoalsInventoryType.FEELINGS.name(), "10", twoWeeksAgo, 20);
		mygoalsList.add(fs_ThirdQuestion);
	
		addMygoalsToMockStorage(patientId, mygoalsList);

		mygoalsList = new MygoalsList();
		Mygoals cds_FirstQuestion = createMygoals(patientId, "CD_Q1", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "4", twoWeeksAgo, 30);
		mygoalsList.add(cds_FirstQuestion);
		Mygoals cds_SecondQuestion = createMygoals(patientId, "CD_Q2", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2|Text3", twoWeeksAgo, 30);
		mygoalsList.add(cds_SecondQuestion);
		Mygoals cds_ThirdQuestion = createMygoals(patientId, "CD_Q3", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "6", twoWeeksAgo, 30);
		mygoalsList.add(cds_ThirdQuestion);
		Mygoals cds_FourthQuestion = createMygoals(patientId, "CD_Q4", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2|Text3|Text4", twoWeeksAgo, 30);
		mygoalsList.add(cds_FourthQuestion);
		Mygoals cds_FifthQuestion = createMygoals(patientId, "CD_Q5", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "7", twoWeeksAgo, 30);
		mygoalsList.add(cds_FifthQuestion);
		Mygoals cds_SixthQuestion = createMygoals(patientId, "CD_Q6", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2", twoWeeksAgo, 30);
		mygoalsList.add(cds_SixthQuestion);
		Mygoals cds_SeventhQuestion = createMygoals(patientId, "CD_Q7", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "3", twoWeeksAgo, 30);
		mygoalsList.add(cds_SeventhQuestion);
		Mygoals cds_EighthQuestion = createMygoals(patientId, "CD_Q8", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2", twoWeeksAgo, 30);
		mygoalsList.add(cds_EighthQuestion);	
		addMygoalsToMockStorage(patientId, mygoalsList);

		mygoalsList = new MygoalsList();
		Mygoals ref_FirstQuestion = createMygoals(patientId, "RF_Q1", MygoalsInventoryType.REFLECTIONS.name(),  "TextArea1", twoWeeksAgo, 20);
		mygoalsList.add(ref_FirstQuestion);
		Mygoals ref_SecondQuestion = createMygoals(patientId, "RF_Q2", MygoalsInventoryType.REFLECTIONS.name(), "TextArea2", twoWeeksAgo, 20);
		mygoalsList.add(ref_SecondQuestion);
		Mygoals ref_ThirdQuestion = createMygoals(patientId, "RF_Q3", MygoalsInventoryType.REFLECTIONS.name(), "TextArea3", twoWeeksAgo, 20);
		mygoalsList.add(ref_ThirdQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);
		
		mygoalsList = new MygoalsList();
		Mygoals priority_FirstQuestion = createMygoals(patientId, "PR1_A1", MygoalsInventoryType.PRIORITIES.name(),  "TestGoal1", twoWeeksAgo, 10);
		mygoalsList.add(priority_FirstQuestion);
		Mygoals priority_SecondQuestion = createMygoals(patientId, "PR2_A2", MygoalsInventoryType.PRIORITIES.name(), "TestGoal2", twoWeeksAgo, 10);
		mygoalsList.add(priority_SecondQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);

		// GALLOW DATA
		patientId = "D123401";
		mygoalsList = new MygoalsList();
		fs_FirstQuestion = createMygoals(patientId, "FS_Q1", MygoalsInventoryType.FEELINGS.name(), "5", twoWeeksAgo, 20);
		mygoalsList.add(fs_FirstQuestion);
		fs_SecondQuestion = createMygoals(patientId, "FS_Q2", MygoalsInventoryType.FEELINGS.name(), "7", twoWeeksAgo, 20);
		mygoalsList.add(fs_SecondQuestion);
		fs_ThirdQuestion = createMygoals(patientId, "FS_Q3", MygoalsInventoryType.FEELINGS.name(), "9", twoWeeksAgo, 20);
		mygoalsList.add(fs_ThirdQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);

		mygoalsList = new MygoalsList();
		cds_FirstQuestion = createMygoals(patientId, "CD_Q1", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "4", twoWeeksAgo, 30);
		mygoalsList.add(cds_FirstQuestion);
		cds_SecondQuestion = createMygoals(patientId, "CD_Q2", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2|Text3", twoWeeksAgo, 30);
		mygoalsList.add(cds_SecondQuestion);
		cds_ThirdQuestion = createMygoals(patientId, "CD_Q3", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "6", twoWeeksAgo, 30);
		mygoalsList.add(cds_ThirdQuestion);
		cds_FourthQuestion = createMygoals(patientId, "CD_Q4", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2|Text3|Text4", twoWeeksAgo, 30);
		mygoalsList.add(cds_FourthQuestion);
		cds_FifthQuestion = createMygoals(patientId, "CD_Q5", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "7", twoWeeksAgo, 30);
		mygoalsList.add(cds_FifthQuestion);
		cds_SixthQuestion = createMygoals(patientId, "CD_Q6", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2", twoWeeksAgo, 30);
		mygoalsList.add(cds_SixthQuestion);
		cds_SeventhQuestion = createMygoals(patientId, "CD_Q7", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "3", twoWeeksAgo, 30);
		mygoalsList.add(cds_SeventhQuestion);
		cds_EighthQuestion = createMygoals(patientId, "CD_Q8", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2", twoWeeksAgo, 30);
		mygoalsList.add(cds_EighthQuestion);	
		addMygoalsToMockStorage(patientId, mygoalsList);

		mygoalsList = new MygoalsList();
		ref_FirstQuestion = createMygoals(patientId, "1", MygoalsInventoryType.REFLECTIONS.name(), "TextArea1", twoWeeksAgo, 20);
		mygoalsList.add(ref_FirstQuestion);
		ref_SecondQuestion = createMygoals(patientId, "2", MygoalsInventoryType.REFLECTIONS.name(), "TextArea2", twoWeeksAgo, 20);
		mygoalsList.add(ref_SecondQuestion);
		ref_ThirdQuestion = createMygoals(patientId, "3", MygoalsInventoryType.REFLECTIONS.name(), "TextArea3", twoWeeksAgo, 20);
		mygoalsList.add(ref_ThirdQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);
		
		mygoalsList = new MygoalsList();
		priority_FirstQuestion = createMygoals(patientId, "PR1_A1", MygoalsInventoryType.PRIORITIES.name(), "TestGoal1", twoWeeksAgo, 10);
		mygoalsList.add(priority_FirstQuestion);
		priority_SecondQuestion = createMygoals(patientId, "PR2_A2", MygoalsInventoryType.PRIORITIES.name(), "TestGoal2", twoWeeksAgo, 10);
		mygoalsList.add(priority_SecondQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);

		// OTHER DATA
		patientId = "testPatientId";
		mygoalsList = new MygoalsList();
		fs_FirstQuestion = createMygoals(patientId, "FS_Q1", MygoalsInventoryType.FEELINGS.name(), "4", twoWeeksAgo, 20);
		mygoalsList.add(fs_FirstQuestion);
		fs_SecondQuestion = createMygoals(patientId, "FS_Q2", MygoalsInventoryType.FEELINGS.name(), "6", twoWeeksAgo, 20);
		mygoalsList.add(fs_SecondQuestion);
		fs_ThirdQuestion = createMygoals(patientId, "FS_Q3", MygoalsInventoryType.FEELINGS.name(), "10", twoWeeksAgo, 20);
		mygoalsList.add(fs_ThirdQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);

		mygoalsList = new MygoalsList();
		cds_FirstQuestion = createMygoals(patientId, "CD_Q1", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "4", twoWeeksAgo, 30);
		mygoalsList.add(cds_FirstQuestion);
		cds_SecondQuestion = createMygoals(patientId, "CD_Q2", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2|Text3", twoWeeksAgo, 30);
		mygoalsList.add(cds_SecondQuestion);
		cds_ThirdQuestion = createMygoals(patientId, "CD_Q3", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "6", twoWeeksAgo, 30);
		mygoalsList.add(cds_ThirdQuestion);
		cds_FourthQuestion = createMygoals(patientId, "CD_Q4", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2|Text3|Text4", twoWeeksAgo, 30);
		mygoalsList.add(cds_FourthQuestion);
		cds_FifthQuestion = createMygoals(patientId, "CD_Q5", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "7", twoWeeksAgo, 30);
		mygoalsList.add(cds_FifthQuestion);
		cds_SixthQuestion = createMygoals(patientId, "CD_Q6", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2", twoWeeksAgo, 30);
		mygoalsList.add(cds_SixthQuestion);
		cds_SeventhQuestion = createMygoals(patientId, "CD_Q7", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "3", twoWeeksAgo, 30);
		mygoalsList.add(cds_SeventhQuestion);
		cds_EighthQuestion = createMygoals(patientId, "CD_Q8", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2", twoWeeksAgo, 30);
		mygoalsList.add(cds_EighthQuestion);	
		addMygoalsToMockStorage(patientId, mygoalsList);

		mygoalsList = new MygoalsList();
		ref_FirstQuestion = createMygoals(patientId, "1", MygoalsInventoryType.REFLECTIONS.name(), "TextArea1", twoWeeksAgo, 20);
		mygoalsList.add(ref_FirstQuestion);
		ref_SecondQuestion = createMygoals(patientId, "2", MygoalsInventoryType.REFLECTIONS.name(), "TextArea2", twoWeeksAgo, 20);
		mygoalsList.add(ref_SecondQuestion);
		ref_ThirdQuestion = createMygoals(patientId, "3", MygoalsInventoryType.REFLECTIONS.name(), "TextArea3", twoWeeksAgo, 20);
		mygoalsList.add(ref_ThirdQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);
		
		mygoalsList = new MygoalsList();
		priority_FirstQuestion = createMygoals(patientId, "PR1_A1", MygoalsInventoryType.PRIORITIES.name(), "TestGoal1", twoWeeksAgo, 10);
		mygoalsList.add(priority_FirstQuestion);
		priority_SecondQuestion = createMygoals(patientId, "PR2_A2", MygoalsInventoryType.PRIORITIES.name(), "TestGoal2", twoWeeksAgo, 10);
		mygoalsList.add(priority_SecondQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);

		// ALDIE DATA
		patientId = "PATID26";
		mygoalsList = new MygoalsList();
		fs_FirstQuestion = createMygoals(patientId, "FS_Q1", MygoalsInventoryType.FEELINGS.name(), "4", today.toDate(), 20);
		mygoalsList.add(fs_FirstQuestion);
		fs_SecondQuestion = createMygoals(patientId, "FS_Q2", MygoalsInventoryType.FEELINGS.name(), "6", today.toDate(), 20);
		mygoalsList.add(fs_SecondQuestion);
		fs_ThirdQuestion = createMygoals(patientId, "FS_Q3", MygoalsInventoryType.FEELINGS.name(), "10", today.toDate(), 20);
		mygoalsList.add(fs_ThirdQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);

		mygoalsList = new MygoalsList();
		cds_FirstQuestion = createMygoals(patientId, "CD_Q1", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "4", twoWeeksAgo, 30);
		mygoalsList.add(cds_FirstQuestion);
		cds_SecondQuestion = createMygoals(patientId, "CD_Q2", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2|Text3", twoWeeksAgo, 30);
		mygoalsList.add(cds_SecondQuestion);
		cds_ThirdQuestion = createMygoals(patientId, "CD_Q3", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "6", twoWeeksAgo, 30);
		mygoalsList.add(cds_ThirdQuestion);
		cds_FourthQuestion = createMygoals(patientId, "CD_Q4", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2|Text3|Text4", twoWeeksAgo, 30);
		mygoalsList.add(cds_FourthQuestion);
		cds_FifthQuestion = createMygoals(patientId, "CD_Q5", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "7", twoWeeksAgo, 30);
		mygoalsList.add(cds_FifthQuestion);
		cds_SixthQuestion = createMygoals(patientId, "CD_Q6", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2", twoWeeksAgo, 30);
		mygoalsList.add(cds_SixthQuestion);
		cds_SeventhQuestion = createMygoals(patientId, "CD_Q7", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "3", twoWeeksAgo, 30);
		mygoalsList.add(cds_SeventhQuestion);
		cds_EighthQuestion = createMygoals(patientId, "CD_Q8", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2", twoWeeksAgo, 30);
		mygoalsList.add(cds_EighthQuestion);	
		addMygoalsToMockStorage(patientId, mygoalsList);

		mygoalsList = new MygoalsList();
		ref_FirstQuestion = createMygoals(patientId, "1", MygoalsInventoryType.REFLECTIONS.name(), "TextArea1", today.toDate(), 20);
		mygoalsList.add(ref_FirstQuestion);
		ref_SecondQuestion = createMygoals(patientId, "2", MygoalsInventoryType.REFLECTIONS.name(), "TextArea2", today.toDate(), 20);
		mygoalsList.add(ref_SecondQuestion);
		ref_ThirdQuestion = createMygoals(patientId, "3", MygoalsInventoryType.REFLECTIONS.name(), "TextArea3", today.toDate(), 20);
		mygoalsList.add(ref_ThirdQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);
		
		mygoalsList = new MygoalsList();
		priority_FirstQuestion = createMygoals(patientId, "PR1_A1", MygoalsInventoryType.PRIORITIES.name(), "TestGoal1", today.toDate(), 10);
		mygoalsList.add(priority_FirstQuestion);
		priority_SecondQuestion = createMygoals(patientId, "PR2_A2", MygoalsInventoryType.PRIORITIES.name(), "TestGoal2", today.toDate(), 10);
		mygoalsList.add(priority_SecondQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);

		// GALLOW DATA
		patientId = "D123401";
		mygoalsList = new MygoalsList();
		fs_FirstQuestion = createMygoals(patientId, "FS_Q1", MygoalsInventoryType.FEELINGS.name(), "4", today.toDate(), 20);
		mygoalsList.add(fs_FirstQuestion);
		fs_SecondQuestion = createMygoals(patientId, "FS_Q2", MygoalsInventoryType.FEELINGS.name(), "6", today.toDate(), 20);
		mygoalsList.add(fs_SecondQuestion);
		fs_ThirdQuestion = createMygoals(patientId, "FS_Q3", MygoalsInventoryType.FEELINGS.name(), "10", today.toDate(), 20);
		mygoalsList.add(fs_ThirdQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);

		mygoalsList = new MygoalsList();
		cds_FirstQuestion = createMygoals(patientId, "CD_Q1", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "4", twoWeeksAgo, 30);
		mygoalsList.add(cds_FirstQuestion);
		cds_SecondQuestion = createMygoals(patientId, "CD_Q2", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2|Text3", twoWeeksAgo, 30);
		mygoalsList.add(cds_SecondQuestion);
		cds_ThirdQuestion = createMygoals(patientId, "CD_Q3", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "6", twoWeeksAgo, 30);
		mygoalsList.add(cds_ThirdQuestion);
		cds_FourthQuestion = createMygoals(patientId, "CD_Q4", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2|Text3|Text4", twoWeeksAgo, 30);
		mygoalsList.add(cds_FourthQuestion);
		cds_FifthQuestion = createMygoals(patientId, "CD_Q5", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "7", twoWeeksAgo, 30);
		mygoalsList.add(cds_FifthQuestion);
		cds_SixthQuestion = createMygoals(patientId, "CD_Q6", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2", twoWeeksAgo, 30);
		mygoalsList.add(cds_SixthQuestion);
		cds_SeventhQuestion = createMygoals(patientId, "CD_Q7", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "3", twoWeeksAgo, 30);
		mygoalsList.add(cds_SeventhQuestion);
		cds_EighthQuestion = createMygoals(patientId, "CD_Q8", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2", twoWeeksAgo, 30);
		mygoalsList.add(cds_EighthQuestion);	
		addMygoalsToMockStorage(patientId, mygoalsList);

		mygoalsList = new MygoalsList();
		ref_FirstQuestion = createMygoals(patientId, "1", MygoalsInventoryType.REFLECTIONS.name(), "TextArea1", today.toDate(), 20);
		mygoalsList.add(ref_FirstQuestion);
		ref_SecondQuestion = createMygoals(patientId, "2", MygoalsInventoryType.REFLECTIONS.name(), "TextArea2", today.toDate(), 20);
		mygoalsList.add(ref_SecondQuestion);
		ref_ThirdQuestion = createMygoals(patientId, "3", MygoalsInventoryType.REFLECTIONS.name(), "TextArea3", today.toDate(), 20);
		mygoalsList.add(ref_ThirdQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);
		
		mygoalsList = new MygoalsList();
		priority_FirstQuestion = createMygoals(patientId, "PR1_A1", MygoalsInventoryType.PRIORITIES.name(), "TestGoal1", today.toDate(), 10);
		mygoalsList.add(priority_FirstQuestion);
		priority_SecondQuestion = createMygoals(patientId, "PR2_A2", MygoalsInventoryType.PRIORITIES.name(), "TestGoal2", today.toDate(), 10);
		mygoalsList.add(priority_SecondQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);

		// OTHER DATA
		patientId = "testPatientId";
		mygoalsList = new MygoalsList();
		fs_FirstQuestion = createMygoals(patientId, "FS_Q1", MygoalsInventoryType.FEELINGS.name(), "4", today.toDate(), 20);
		mygoalsList.add(fs_FirstQuestion);
		fs_SecondQuestion = createMygoals(patientId, "FS_Q2", MygoalsInventoryType.FEELINGS.name(), "6", today.toDate(), 20);
		mygoalsList.add(fs_SecondQuestion);
		fs_ThirdQuestion = createMygoals(patientId, "FS_Q3", MygoalsInventoryType.FEELINGS.name(), "10", today.toDate(), 20);
		mygoalsList.add(fs_ThirdQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);

		mygoalsList = new MygoalsList();
		cds_FirstQuestion = createMygoals(patientId, "CD_Q1", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "4", twoWeeksAgo, 30);
		mygoalsList.add(cds_FirstQuestion);
		cds_SecondQuestion = createMygoals(patientId, "CD_Q2", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2|Text3", twoWeeksAgo, 30);
		mygoalsList.add(cds_SecondQuestion);
		cds_ThirdQuestion = createMygoals(patientId, "CD_Q3", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "6", twoWeeksAgo, 30);
		mygoalsList.add(cds_ThirdQuestion);
		cds_FourthQuestion = createMygoals(patientId, "CD_Q4", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2|Text3|Text4", twoWeeksAgo, 30);
		mygoalsList.add(cds_FourthQuestion);
		cds_FifthQuestion = createMygoals(patientId, "CD_Q5", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "7", twoWeeksAgo, 30);
		mygoalsList.add(cds_FifthQuestion);
		cds_SixthQuestion = createMygoals(patientId, "CD_Q6", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2", twoWeeksAgo, 30);
		mygoalsList.add(cds_SixthQuestion);
		cds_SeventhQuestion = createMygoals(patientId, "CD_Q7", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "3", twoWeeksAgo, 30);
		mygoalsList.add(cds_SeventhQuestion);
		cds_EighthQuestion = createMygoals(patientId, "CD_Q8", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Text1|Text2", twoWeeksAgo, 30);
		mygoalsList.add(cds_EighthQuestion);	
		addMygoalsToMockStorage(patientId, mygoalsList);

		mygoalsList = new MygoalsList();
		ref_FirstQuestion = createMygoals(patientId, "1", MygoalsInventoryType.REFLECTIONS.name(), "TextArea1", today.toDate(), 20);
		mygoalsList.add(ref_FirstQuestion);
		ref_SecondQuestion = createMygoals(patientId, "2", MygoalsInventoryType.REFLECTIONS.name(), "TextArea2", today.toDate(), 20);
		mygoalsList.add(ref_SecondQuestion);
		ref_ThirdQuestion = createMygoals(patientId, "3", MygoalsInventoryType.REFLECTIONS.name(), "TextArea3", today.toDate(), 20);
		mygoalsList.add(ref_ThirdQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);
		
		mygoalsList = new MygoalsList();
		priority_FirstQuestion = createMygoals(patientId, "PR1_A1", MygoalsInventoryType.PRIORITIES.name(), "TestGoal1", today.toDate(), 10);
		mygoalsList.add(priority_FirstQuestion);
		priority_SecondQuestion = createMygoals(patientId, "PR2_A2", MygoalsInventoryType.PRIORITIES.name(), "TestGoal2", today.toDate(), 10);
		mygoalsList.add(priority_SecondQuestion);
		addMygoalsToMockStorage(patientId, mygoalsList);
		
	}

	@Override
	public MygoalsList fetchLatestMygoalsListByType(String patientId, String inventoryType) {
		MygoalsList responsesForPatient = new MygoalsList();
		if (inventoryType.equalsIgnoreCase(MygoalsInventoryType.FEELINGS.name()) 
				|| inventoryType.equals(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name()) 
				|| inventoryType.equals(MygoalsInventoryType.REFLECTIONS.name())
				|| inventoryType.equals(MygoalsInventoryType.PRIORITIES.name())) {
			responsesForPatient = mockStorage.get(patientId);
		} else {
			throw new RuntimeException("Inventory Type is not found");
		}
		return getMygoalsByInventoryType(responsesForPatient,inventoryType);
	}

	@Override
	public Mygoals saveMygoals(Mygoals mygoals) {
		mygoals.setId(generateRandomMygoalsId());
		generateMygoalsId(mygoals);
		MygoalsList mygoalsNew = new MygoalsList();
		mygoalsNew.add(mygoals);
		mockStorage.put(mygoals.getPatientIdentifier().getUniqueId(), mygoalsNew);	
		return mygoals;
	}

	private void generateMygoalsId(
			Mygoals response) {
		
		response.setId(generateRandomMygoalsId());
	}
	
	@Override
	public MygoalsList fetchLatestMygoalsList(String patientId) {
		logger.debug(String.format("fetching Latest MygoalsList by patient [patient=%s]", patientId));
		MygoalsList mygoalsList = fetchLatestMygoalsListByPatientId(patientId);
		for (Mygoals mygoals : mygoalsList) {
			logger.debug(String.format("Mygoals  [%s]", mygoals.getId()));
		}
		logger.debug(String.format("fetch latest mygoalsList by patient [patient=%s] returned %s row(s)", patientId, mygoalsList.size()));
		return mygoalsList;
	}
	
	@Override
	public Mygoals fetchMygoalsById(String inputPatientId, String responseId) {
		Set<String> patientIds = mockStorage.keySet();
		Mygoals retrievedMygoals = null;;
		for (String patientId : patientIds) {
			MygoalsList mygoalsListForPatientId = mockStorage.get(patientId);
			for (Mygoals mygoals : mygoalsListForPatientId) {
				if (mygoals.getId().equals(responseId)) {
					retrievedMygoals = mygoals;
				}
			}
		}
		return retrievedMygoals;
	}
	
	@Override
	public MygoalsList fetchMygoalsListByPatient(String patientId) {
		logger.debug(String.format("fetching MygoalsList by patient [patient=%s]", patientId));
		MygoalsList mygoalsList = fetchMygoalsList(patientId);
		for (Mygoals mygoals : mygoalsList) {
			logger.debug(String.format("mygoals  [%s]", mygoals.getId()));
		}
		logger.debug(String.format("fetch mygoalsList by patient [patient=%s] returned %s row(s)", patientId, mygoalsList.size()));
		return mygoalsList;
	}
	
	private MygoalsList getMygoalsByInventoryType(MygoalsList mygoalsListForPatient, String inventoryType) {
		
		MygoalsList mygoalsList = new MygoalsList();
		for (Mygoals mygoals : mygoalsListForPatient) {
			if (inventoryType.equalsIgnoreCase(mygoals.getInventoryType())) {
				mygoalsList.add(mygoals);
			}
		}
		return mygoalsList;
	}

	private String generateRandomMygoalsId() {
		String randomResultId = UUID.randomUUID().toString();
		return randomResultId;
	}

	public MygoalsList fetchLatestMygoalsListByPatientId(String inputPatientId) {
		MygoalsList mygoalsListForPatient = mockStorage.get(inputPatientId);
		MygoalsList latestMygoalsList = new MygoalsList();
		
		MygoalsList feelScaleInvResps =  getSameInventoryTypeMygoalsList(mygoalsListForPatient, MygoalsInventoryType.FEELINGS.name());
		Set<String> feelScaleQuestionKeys = getDistinctQuestionKeys(feelScaleInvResps);
		loadQuestionKeyMygoalsMap(feelScaleInvResps, feelScaleQuestionKeys);
		MygoalsList latestFeelScaleQuestionResps = getMygoalsListWithMaxDateByQuestionkey(feelScaleQuestionKeys);
		
		MygoalsList currAndDesireInvResps =  getSameInventoryTypeMygoalsList(mygoalsListForPatient, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		Set<String> currAndDesireQuestionKeys = getDistinctQuestionKeys(currAndDesireInvResps);
		loadQuestionKeyMygoalsMap(currAndDesireInvResps, currAndDesireQuestionKeys);
		MygoalsList latestCurrAndDesireQuestionResps = getMygoalsListWithMaxDateByQuestionkey(currAndDesireQuestionKeys);
		
		MygoalsList reflectionInvResps =  getSameInventoryTypeMygoalsList(mygoalsListForPatient, MygoalsInventoryType.REFLECTIONS.name());
		Set<String> reflectionQuestionKeys = getDistinctQuestionKeys(reflectionInvResps);
		loadQuestionKeyMygoalsMap(reflectionInvResps, reflectionQuestionKeys);
		MygoalsList latestReflectionQuestionResps = getMygoalsListWithMaxDateByQuestionkey(reflectionQuestionKeys);
		
		MygoalsList priorityInvResps =  getSameInventoryTypeMygoalsList(mygoalsListForPatient, MygoalsInventoryType.PRIORITIES.name());
		Set<String> priorityQuestionKeys = getDistinctQuestionKeys(priorityInvResps);
		loadQuestionKeyMygoalsMap(priorityInvResps, priorityQuestionKeys);
		MygoalsList latestPriorityQuestionResps = getMygoalsListWithMaxDateByQuestionkey(priorityQuestionKeys);
		
		
		if (latestFeelScaleQuestionResps.size() > 0) {
			latestMygoalsList.addAll(latestFeelScaleQuestionResps);
		} 
		if (latestCurrAndDesireQuestionResps.size() > 0) {
			latestMygoalsList.addAll(latestCurrAndDesireQuestionResps);
		} 
		if (latestReflectionQuestionResps.size() > 0) {
			latestMygoalsList.addAll(latestReflectionQuestionResps);
		}
		if (latestPriorityQuestionResps.size() > 0) {
			latestMygoalsList.addAll(latestPriorityQuestionResps);
		}
		return latestMygoalsList;
	}

	private MygoalsList getMygoalsListWithMaxDateByQuestionkey(Set<String> questionKeys) {
		MygoalsList latestMygoalsList = new MygoalsList();
		for (String questionKey : questionKeys) {
			MygoalsList sameQuestionkeyMygoals = questionKeyMygoalsMap.get(questionKey);
			Collections.sort(sameQuestionkeyMygoals, new MygoalsSortByUpdatedDate());
			latestMygoalsList.add(sameQuestionkeyMygoals.get(0));
		}
		return latestMygoalsList;
	}

	public class MygoalsSortByUpdatedDate implements Comparator<Mygoals>{

		public int compare(Mygoals o1, Mygoals o2) {
		return o1.getDateUpdated().compareTo(o2.getDateUpdated());
		}
	}
	
	private void loadQuestionKeyMygoalsMap(MygoalsList mygoalsList, Set<String> questionKeys) {
		
		questionKeyMygoalsMap.clear();
		for (String questionKey : questionKeys) {
			MygoalsList sameQuestionkeyMygoals = new MygoalsList();
			for (Mygoals mygoals : mygoalsList) {
				if(questionKey.equalsIgnoreCase(mygoals.getQuestionKey())) {
					sameQuestionkeyMygoals.add(mygoals);
				}
			}
			questionKeyMygoalsMap.put(questionKey, sameQuestionkeyMygoals);	
		}
		
	}
	
	private Set<String> getDistinctQuestionKeys(MygoalsList mygoalsList) {
		String prevQuestionKey = null;
		Set<String> questionKeys = new HashSet<String>();
		for (Mygoals mygoals : mygoalsList) {
			if (!mygoals.getQuestionKey().equalsIgnoreCase(prevQuestionKey)) {
				questionKeys.add(mygoals.getQuestionKey());
			} else {
				prevQuestionKey = mygoals.getQuestionKey();
			}
		}
		return questionKeys;
	}
	
	private MygoalsList getSameInventoryTypeMygoalsList(MygoalsList mygoalsList, String invType ) {
		
		MygoalsList sameInventoryTypeMygoals = new MygoalsList();
		for (Mygoals mygoals : mygoalsList) {
			if (invType.equalsIgnoreCase(mygoals.getInventoryType())) {
				sameInventoryTypeMygoals.add(mygoals);
			}
		}
		return sameInventoryTypeMygoals;
	}
	
	private MygoalsList fetchMygoalsList(String inputPatientId) {
		MygoalsList mygoalsListForPatientId = mockStorage.get(inputPatientId);
		if (mygoalsListForPatientId == null) {
			mygoalsListForPatientId = new MygoalsList();
		}
		return mygoalsListForPatientId;
	}
	
	private void addMygoalsToMockStorage(String patientId, MygoalsList mygoalsList) {
		MygoalsList existingMygoalsList = mockStorage.get(patientId);
		if (existingMygoalsList == null) {
			existingMygoalsList = new MygoalsList();
		}
		existingMygoalsList.addAll(mygoalsList);
		mockStorage.put(patientId, existingMygoalsList);
	}

	public Mygoals generateMygoalsForType(String userId, Date dateUpdated, String type, String version) {
		Mygoals mygoals = new Mygoals();
		mygoals.setId(UUID.randomUUID().toString());
		mygoals.setPatientId(userId);
		mygoals.setDateUpdated(dateUpdated);
		mygoals.setInventoryType(type);
		return mygoals;
	}

    private Mygoals createMygoals(String patientId, String questionKey, String invType,  String answer, Date dateUpdated, int elapsedTime) {
    	Mygoals mygoals = new Mygoals();
    	mygoals.setId(UUID.randomUUID().toString());
    	mygoals.setQuestionKey(questionKey);
    	mygoals.setInventoryType(invType);
    	mygoals.setPatientId(patientId);
		mygoals.setAnswer(answer);
		mygoals.setDateUpdated(dateUpdated);
		mygoals.setElapsedTime(elapsedTime);
        return mygoals;
    }

	@Override
	public void deleteMygoals(Mygoals mygoals) {
		mockStorage.remove(mygoals.getPatientIdentifier().getUniqueId());
		
	}


}