package com.agilex.healthcare.mobilehealthplatform.datalayer.mygoals;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElement;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElementDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElements;
import com.agilex.healthcare.mobilehealthplatform.domain.Mygoals;
import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsList;
import com.agilex.healthcare.mobilehealthplatform.enumeration.MygoalsInventoryType;

public class MygoalsDataLayerExcel implements MygoalsDataLayer {

	private static final String domain = "mygoals";
	private static final String COLUMN_PATIENTID = "PatientId";
	private static final String COLUMN_QRESPID = "Id";
	private static final String COLUMN_TYPE = "Type";
	private static final String COLUMN_QKEY = "questionKey";
	private static final String COLUMN_ANSWER = "answer";
	private static final String COLUMN_DATEUPDATED = "dateUpdated";
	private static final String COLUMN_ELAPSEDTIME = "elapsedTime";
	
	private MygoalsList mygoalsList;
	private Map<String, MygoalsList> questionKeyMygoalsListMap = new HashMap<String, MygoalsList>();

	private MygoalsList createMygoalsList(DataElements dataElements) {
		if (mygoalsList == null) {
			mygoalsList = new MygoalsList();
		
			for (DataElement dataElement : dataElements) {
				mygoalsList.add(createMygoals(dataElement));
			}
		}
		return mygoalsList;
	}
	
	private Mygoals createMygoals(DataElement dataElement){
		Mygoals mygoals = new Mygoals();
		mygoals.setPatientId(dataElement.getValue(COLUMN_PATIENTID));
		mygoals.setId(dataElement.getValue(COLUMN_QRESPID));
		mygoals.setInventoryType(dataElement.getValue(COLUMN_TYPE));
		mygoals.setQuestionKey(dataElement.getValue(COLUMN_QKEY));
		mygoals.setAnswer(dataElement.getValue(COLUMN_ANSWER));
		mygoals.setDateUpdated(dataElement.getValueAsDate(COLUMN_DATEUPDATED));
		mygoals.setElapsedTime(Integer.valueOf(dataElement.getValue(COLUMN_ELAPSEDTIME)));

		return mygoals;
	}
	
	@Override
	public MygoalsList fetchLatestMygoalsListByType(String patientId, String inventoryType) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();;
		DataElements dataElements = storage.getData(patientId, domain);
		MygoalsList latestInventoryResponses = new MygoalsList();
		if (!dataElements.isEmpty()) {
			createMygoalsList(dataElements);
			for (Mygoals response : mygoalsList) {
				if (response.getInventoryType().equalsIgnoreCase(inventoryType)) {
					latestInventoryResponses.add(response);
				}
			}			
		}

		return getLatestMygoalsList(latestInventoryResponses);
	}
	
	@Override
	public Mygoals fetchMygoalsById(String patientId, String responseId) {
		Mygoals response = null;
		DataElementDataStorage storage = DataElementDataStorage.getInstance();;
		DataElement dataElement = storage.getData(patientId, domain, responseId, COLUMN_QRESPID);
		if (dataElement != null) {
			response = createMygoals(dataElement);
		} else {
			for (Mygoals invResp : mygoalsList) {
				if (invResp.getId().equalsIgnoreCase(responseId)) {
					response = invResp;
				}
			}
		}
		return response;	
	}

	@Override
	public MygoalsList fetchMygoalsListByPatient(String patientId) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();;
		DataElements dataElements = storage.getData(patientId, domain);
		return createMygoalsList(dataElements);	
	}

	@Override
	public void deleteMygoals(Mygoals inventoryResponse) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();;
		DataElements dataElements = storage.getData(inventoryResponse.getPatientId(), domain);
		createMygoalsList(dataElements);	
		mygoalsList.remove(inventoryResponse);
	}

	@Override
	public Mygoals saveMygoals(Mygoals inventoryResponse) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();;
		DataElements dataElements = storage.getData(inventoryResponse.getPatientId(), domain);
		createMygoalsList(dataElements);	
		inventoryResponse.setId(UUID.randomUUID().toString());
		mygoalsList.add(inventoryResponse);
		return inventoryResponse;
	}

	@Override
	public MygoalsList fetchLatestMygoalsList(String patientId) {
		DataElementDataStorage storage = DataElementDataStorage.getInstance();;
		DataElements dataElements = storage.getData(patientId, domain);
		if (dataElements.isEmpty()) {
			return new MygoalsList();
		}
		createMygoalsList(dataElements);
		return getLatestMygoalsList(mygoalsList);	
	}
	
	private MygoalsList getLatestMygoalsList(MygoalsList mygoalsList) {

		MygoalsList latestMygoalsList = new MygoalsList();
		
		MygoalsList feelingsMygoalsList =  getSameInventoryTypeMygoalsList(mygoalsList, MygoalsInventoryType.FEELINGS.name());
		Set<String> feelingsQuestionKeys = getDistinctQuestionKeys(feelingsMygoalsList);
		loadQuestionKeyMygoalsListMap(feelingsMygoalsList, feelingsQuestionKeys);
		MygoalsList latestFeelingsMygoalsList = getMygoalsListWithMaxDateByQuestionkey(feelingsQuestionKeys);
		
		MygoalsList currAndDesireMygoalsList =  getSameInventoryTypeMygoalsList(mygoalsList, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		Set<String> currAndDesireQuestionKeys = getDistinctQuestionKeys(currAndDesireMygoalsList);
		loadQuestionKeyMygoalsListMap(currAndDesireMygoalsList, currAndDesireQuestionKeys);
		MygoalsList latestCurrAndDesireMygoalsList = getMygoalsListWithMaxDateByQuestionkey(currAndDesireQuestionKeys);
		
		MygoalsList reflectionMygoalsList =  getSameInventoryTypeMygoalsList(mygoalsList, MygoalsInventoryType.REFLECTIONS.name());
		Set<String> reflectionQuestionKeys = getDistinctQuestionKeys(reflectionMygoalsList);
		loadQuestionKeyMygoalsListMap(reflectionMygoalsList, reflectionQuestionKeys);
		MygoalsList latestReflectionMygoalsList = getMygoalsListWithMaxDateByQuestionkey(reflectionQuestionKeys);
		
		MygoalsList priorityMygoalsList =  getSameInventoryTypeMygoalsList(mygoalsList, MygoalsInventoryType.PRIORITIES.name());
		Set<String> priorityQuestionKeys = getDistinctQuestionKeys(priorityMygoalsList);
		loadQuestionKeyMygoalsListMap(priorityMygoalsList, priorityQuestionKeys);
		MygoalsList latestPriorityMygoalsList = getMygoalsListWithMaxDateByQuestionkey(priorityQuestionKeys);
		
		if (latestFeelingsMygoalsList.size() > 0) {
			latestMygoalsList.addAll(latestFeelingsMygoalsList);
		} 
		if (latestCurrAndDesireMygoalsList.size() > 0) {
			latestMygoalsList.addAll(latestCurrAndDesireMygoalsList);
		} 
		if (latestReflectionMygoalsList.size() > 0) {
			latestMygoalsList.addAll(latestReflectionMygoalsList);
		}
		if (latestPriorityMygoalsList.size() > 0) {
			latestMygoalsList.addAll(latestPriorityMygoalsList);
		}
		return latestMygoalsList;
	}

	private MygoalsList getMygoalsListWithMaxDateByQuestionkey(Set<String> questionKeys) {
		MygoalsList latestMygoalsList = new MygoalsList();
		for (String questionKey : questionKeys) {
			MygoalsList sameQuestionkeyMygoalsList = questionKeyMygoalsListMap.get(questionKey);
			Collections.sort(sameQuestionkeyMygoalsList, new MygoalsSortByUpdatedDate());
			latestMygoalsList.add(sameQuestionkeyMygoalsList.get(0));
		}
		return latestMygoalsList;
	}

	private void loadQuestionKeyMygoalsListMap(MygoalsList mygoalsList, Set<String> questionKeys) {
		
		questionKeyMygoalsListMap.clear();
		for (String questionKey : questionKeys) {
			MygoalsList sameQuestionkeyMygoalsList = new MygoalsList();
			for (Mygoals mygoals : mygoalsList) {
				if(questionKey.equalsIgnoreCase(mygoals.getQuestionKey())) {
					sameQuestionkeyMygoalsList.add(mygoals);
				}
			}
			questionKeyMygoalsListMap.put(questionKey, sameQuestionkeyMygoalsList);	
		}
		
	}
	
	private Set<String> getDistinctQuestionKeys(MygoalsList mygoalsList) {
		String prevQuestionKey = null;
		Set<String> questionKeys = new HashSet<String>();
		for (Mygoals mygoals : mygoalsList) {
			if (!mygoals.getQuestionKey().equalsIgnoreCase(prevQuestionKey)) {
				questionKeys.add(mygoals.getQuestionKey());
			} else {
				prevQuestionKey = mygoals.getQuestionKey();
			}
		}
		return questionKeys;
	}
	
	private MygoalsList getSameInventoryTypeMygoalsList(MygoalsList mygoalsList, String invType ) {
		
		MygoalsList sameInventoryTypeMygoalsList = new MygoalsList();
		for (Mygoals mygoals : mygoalsList) {
			if (invType.equalsIgnoreCase(mygoals.getInventoryType())) {
				sameInventoryTypeMygoalsList.add(mygoals);
			}
		}
		return sameInventoryTypeMygoalsList;
	}
	
	public class MygoalsSortByUpdatedDate implements Comparator<Mygoals>{

		public int compare(Mygoals o1, Mygoals o2) {
			return o2.getDateUpdated().compareTo(o1.getDateUpdated());
		}
	}	
	
}
