package com.agilex.healthcare.mobilehealthplatform.datalayer.medication.rxrefill;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.MedicationRefillCode;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.NullSafeStringComparer;

public class MedicationRefillDataLayerMock implements MedicationRefillDataLayer {

	Map<String, Medications> medicationStorage = new HashMap<String, Medications>();
	MedicationRefillHelper logicHelper = new MedicationRefillHelper();
	public final String ERROR_MESSAGE = "The request was either made too early or the system is not taking requests at this time. Please try again later.";
	
	public void init() {
		PatientIdentifier gallow = new PatientIdentifier("EDIPI", "D123401");
		Medications medications = new Medications();
		
		Medication medication = new Medication();
		medication.setDrugName("LISINOPRIL TAB 10MG");
		medication.setEndDate(DateHelper.parseDate("12/31/2020"));
		medication.setLastFilledDate(DateHelper.parseDate("09/09/2012"));
		medication.setExpiredDate(DateHelper.parseDate("12/31/2020"));
		medication.setSig("TAKE ONE TABLET BY MOUTH THREE TIMES A DAY");
		medication.setRefills("3");
		medication.setQuantity("270");
		medication.setDaysSupply("90");
		medication.setStatus("ACTIVE");
		medication.setOrderNumber("12345");
		medication.setPrescriptionId("789101112");
		medication.setDataIdentifier(new DataIdentifier("mock", UUID.randomUUID().toString()));
		medication.setPatientIdentifier(gallow);
		medications.add(medication);
		
		medication = new Medication();
		medication.setDrugName("BUPROPION HCL 100MG TAB");
		medication.setEndDate(DateHelper.parseDate("12/31/2020"));
		medication.setLastFilledDate(DateHelper.parseDate("06/01/2012"));
		medication.setExpiredDate(DateHelper.parseDate("12/31/2020"));
		medication.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		medication.setRefills("3");
		medication.setQuantity("30");
		medication.setDaysSupply("30");
		medication.setStatus("ACTIVE");
		medication.setOrderNumber("67890");
		medication.setPrescriptionId("789101113");
		medication.setDataIdentifier(new DataIdentifier("mock", UUID.randomUUID().toString()));
		medication.setPatientIdentifier(gallow);
		medications.add(medication);
		
		medication = new Medication();
		medication.setDrugName("MEMANTINE HCL 10MG TAB");
		medication.setEndDate(DateHelper.parseDate("12/31/2020"));
		medication.setLastFilledDate(DateHelper.parseDate("08/08/2012"));
		medication.setExpiredDate(DateHelper.parseDate("12/31/2020"));
		medication.setSig("TAKE ONE TABLET BY MOUTH EVERY 8 HOURS");
		medication.setRefills("2");
		medication.setQuantity("90");
		medication.setDaysSupply("30");
		medication.setStatus("ACTIVE");
		medication.setOrderNumber("67891");
		medication.setPrescriptionId("789101114");
		medication.setDataIdentifier(new DataIdentifier("mock", UUID.randomUUID().toString()));
		medication.setPatientIdentifier(gallow);
		medications.add(medication);
		
		medication = new Medication();
		medication.setDrugName("DOCUSATE SODIUM 100MG CAP");
		medication.setEndDate(DateHelper.parseDate("12/31/2020"));
		medication.setLastFilledDate(DateHelper.getToday()); // Medication that is not refillable
		medication.setExpiredDate(DateHelper.parseDate("12/31/2020"));
		medication.setSig("TAKE ONE CAPSULE BY MOUTH EVERY 12 HOURS");
		medication.setRefills("3");
		medication.setQuantity("60");
		medication.setDaysSupply("30");
		medication.setStatus("ACTIVE");
		medication.setOrderNumber("67892");
		medication.setPrescriptionId("789101115");
		medication.setDataIdentifier(new DataIdentifier("mock", UUID.randomUUID().toString()));
		medication.setPatientIdentifier(gallow);
		medications.add(medication);
		
		medicationStorage.put(gallow.getUniqueId(), medications);
		
                PatientIdentifier icnGallow = new PatientIdentifier("icn#688", "1008593069V747998");
                medications = new Medications();
                
                medication = new Medication();
                medication.setDrugName("LISINOPRIL TAB 10MG");
                medication.setEndDate(DateHelper.parseDate("12/31/2020"));
                medication.setLastFilledDate(DateHelper.parseDate("09/09/2012"));
                medication.setExpiredDate(DateHelper.parseDate("12/31/2020"));
                medication.setSig("TAKE ONE TABLET BY MOUTH THREE TIMES A DAY");
                medication.setRefills("3");
                medication.setQuantity("270");
                medication.setDaysSupply("90");
                medication.setStatus("ACTIVE");
                medication.setOrderNumber("12345");
                medication.setPrescriptionId("789101112");
                medication.setDataIdentifier(new DataIdentifier("mock", UUID.randomUUID().toString()));
                medication.setPatientIdentifier(gallow);
                medications.add(medication);
                
                medication = new Medication();
                medication.setDrugName("BUPROPION HCL 100MG TAB");
                medication.setEndDate(DateHelper.parseDate("12/31/2020"));
                medication.setLastFilledDate(DateHelper.parseDate("06/01/2012"));
                medication.setExpiredDate(DateHelper.parseDate("12/31/2020"));
                medication.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
                medication.setRefills("3");
                medication.setQuantity("30");
                medication.setDaysSupply("30");
                medication.setStatus("ACTIVE");
                medication.setOrderNumber("67890");
                medication.setPrescriptionId("789101113");
                medication.setDataIdentifier(new DataIdentifier("mock", UUID.randomUUID().toString()));
                medication.setPatientIdentifier(gallow);
                medications.add(medication);
                
                medication = new Medication();
                medication.setDrugName("MEMANTINE HCL 10MG TAB");
                medication.setEndDate(DateHelper.parseDate("12/31/2020"));
                medication.setLastFilledDate(DateHelper.parseDate("08/08/2012"));
                medication.setExpiredDate(DateHelper.parseDate("12/31/2020"));
                medication.setSig("TAKE ONE TABLET BY MOUTH EVERY 8 HOURS");
                medication.setRefills("2");
                medication.setQuantity("90");
                medication.setDaysSupply("30");
                medication.setStatus("ACTIVE");
                medication.setOrderNumber("67891");
                medication.setPrescriptionId("789101114");
                medication.setDataIdentifier(new DataIdentifier("mock", UUID.randomUUID().toString()));
                medication.setPatientIdentifier(gallow);
                medications.add(medication);
                
                medication = new Medication();
                medication.setDrugName("DOCUSATE SODIUM 100MG CAP");
                medication.setEndDate(DateHelper.parseDate("12/31/2020"));
                medication.setLastFilledDate(DateHelper.getToday()); // Medication that is not refillable
                medication.setExpiredDate(DateHelper.parseDate("12/31/2020"));
                medication.setSig("TAKE ONE CAPSULE BY MOUTH EVERY 12 HOURS");
                medication.setRefills("3");
                medication.setQuantity("60");
                medication.setDaysSupply("30");
                medication.setStatus("ACTIVE");
                medication.setOrderNumber("67892");
                medication.setPrescriptionId("789101115");
                medication.setDataIdentifier(new DataIdentifier("mock", UUID.randomUUID().toString()));
                medication.setPatientIdentifier(gallow);
                medications.add(medication);
                
                medicationStorage.put(icnGallow.getUniqueId(), medications);
		
	}
	
	public Medications fetchMedications(String patientId) {
		Medications retrievedMedications = fetchFromMedicationStorage(patientId);
		if (NullChecker.isNotNullish(retrievedMedications)) {
			for (Medication medication : retrievedMedications) {
				logicHelper.determineRefillAction(medication);
			}
		}
		return retrievedMedications;
	}

	@Override
	public Medication refillMedication(Medication medication) {
		logicHelper.determineRefillAction(medication);
		if (!medication.getRefillAction().equals(MedicationRefillCode.REFILL_ACTION_ELIGIBLE)) {
			generateValidationException(medication);
		}
//		medication.setLastFilledDate(new Date()); removing - this doesn't happen in the real system
		determineRefillAction(medication);
		updateMedicationInStorage(medication);
		return medication;
	}
	
	private ValidationErrors<Medication> generateValidationException(Medication medication) {
		ValidationError validationError = new ValidationError(ERROR_MESSAGE, "Status");
		ValidationErrors<Medication> validationErrors = new ValidationErrors<Medication>();
		validationErrors.add(validationError);

		throw new MedicationRefillException(validationErrors);
	}
	
	void determineRefillAction(Medication medication) {
		logicHelper.determineRefillAction(medication);
	}
	
	Medications fetchFromMedicationStorage(String patientId) {
		Medications medications = medicationStorage.get(patientId);
		if(medications == null) {
			init();
			medications = medicationStorage.get(patientId);
		}
		
		return medications;
	}
	
	void updateMedicationInStorage(Medication updatedMedication) {
		Medication medicationToUpdate = null;
		Medications medications = medicationStorage.get(updatedMedication.getPatientId()); 
		for(Medication medication : medications) {
			if(NullSafeStringComparer.areEqual(updatedMedication.getOrderNumber(), medication.getOrderNumber())) {
				medicationToUpdate = medication;
			}
		}
		
		if(medicationToUpdate != null) {
			medications.remove(medicationToUpdate);
			medications.add(updatedMedication);
		}
	}

	@Override
	public Medications fetchMedications(PatientIdentifier patientIdentifier) {
		return fetchMedications(patientIdentifier.getUniqueId());
	}
}
