package com.agilex.healthcare.mobilehealthplatform.datalayer.medication;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.StreamHelper;

public class MedicationDataLayerMock implements MedicationDataLayer {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(MedicationDataLayerMock.class);

	private Map<String, Medications> medicationStore = new ConcurrentHashMap<String, Medications>();
	
	//private Medications medicationStore;
	public static final String PHARM_CVS = "CVS";
	public static final String PHARM_WEGMANS = "WEGMANS";
	public static final String CATEGORY_RX = "Rx";
	public static final String CATEGORY_OTC = "OTC";
	public static final String CATEGORY_SUPPLEMENTAL = "OTC";
	
	// todo: move this to common library
	public static final String STATUS_ACTIVE = "ACTIVE";
	public static final String STATUS_ACTIVESUSPENDED = "ACTIVE/SUSP";
	public static final String STATUS_EXPIRED = "EXPIRED";
	public static final int MAX_NUMBER_DAYS_EXPIRED_TO_TREAT_AS_ACTIVE = 120;

	public MedicationDataLayerMock() {
		try {
			initMedicationStore("D123401");
			initMedicationStore("PATID65");
			initMedicationStore("EDIPI-ONE");
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
	}

	private void initMedicationStore(String patientId) throws ParseException {
		SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");

		Medications medications = new Medications();
		Medication m = null;

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setOrderNumber("1");
		m.setPatientId(patientId);
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("AMITRIPTYLINE HCL 50 MG TAB");
		m.setPharmacy(PHARM_CVS);
		m.setCategory(CATEGORY_RX);
		m.setStartDate(df.parse("01/01/2008"));
		m.setEndDate(null);
		m.setMedicationSource("OUTPATIENT");
		m.setSourceSystem("VA");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setOrderNumber("2");
		m.setPatientId(patientId);
		m.setStatus(STATUS_EXPIRED);
		m.setDrugName("Aspirin");
		m.setPharmacy(PHARM_CVS);
		m.setCategory(CATEGORY_OTC);
		m.setStartDate(df.parse("01/01/2007"));
		m.setEndDate(df.parse("01/01/2009"));
		m.setEndDate(null);
		m.setMedicationSource("OUTPATIENT");
		m.setSourceSystem("DoD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setOrderNumber("nonva");
		m.setPatientId(patientId);
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("Flintstones Vitamins");
		m.setPharmacy(PHARM_CVS);
		m.setCategory(CATEGORY_OTC);
		m.setStartDate(df.parse("01/01/1990"));
		m.setEndDate(null);
		m.setMedicationSource("OTHER");
		m.setSourceSystem("OTHER");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setOrderNumber("3");
		m.setPatientId(patientId);
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("LISINOPRIL TAB 10MG");
		m.setPharmacy(PHARM_WEGMANS);
		m.setCategory(CATEGORY_RX);
		m.setStartDate(df.parse("01/19/2011"));
		m.setEndDate(null);
		m.setMedicationSource("OUTPATIENT");
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setLastFilledDate(DateHelper.parseDate("1/30/2011"));
		m.setRefills("3");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setOrderNumber("4");
		m.setPatientId(patientId);
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("my iv");
		m.setStartDate(df.parse("03/20/2011"));
		m.setEndDate(null);
		m.setMedicationSource("INPATIENT");
		m.setSig("GIVE 50 ml every day");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setOrderNumber("5");
		m.setPatientId(patientId);
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("my second iv");
		m.setStartDate(df.parse("01/15/2011"));
		m.setEndDate(df.parse("02/15/2011"));
		m.setMedicationSource("INPATIENT");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setOrderNumber("6");
		m.setPatientId(patientId);
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("my third iv");
		m.setStartDate(df.parse("02/20/2011"));
		m.setEndDate(df.parse("04/20/2011"));
		m.setMedicationSource("INPATIENT");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setOrderNumber("7");
		m.setPatientId(patientId);
		m.setStatus(STATUS_EXPIRED);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("02/10/2011"));
		m.setEndDate(df.parse("12/02/2011"));
		m.setMedicationSource("OUTPATIENT");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setOrderNumber("7B");
		m.setPatientId(patientId);
		m.setStatus(STATUS_EXPIRED);
		m.setDrugName("GLYBURIDE 5MG TAB");
		m.setStartDate(df.parse("01/10/2011"));
		m.setEndDate(df.parse("07/02/2011"));
		m.setMedicationSource("OUTPATIENT");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setOrderNumber("8");
		m.setPatientId(patientId);
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("drip");
		m.setStartDate(df.parse("03/10/2010"));
		m.setEndDate(df.parse("07/02/2010"));
		m.setMedicationSource("INPATIENT");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setOrderNumber("9");
		m.setPatientId(patientId);
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("ASPIRIN 81MG EC TAB");
		m.setStartDate(df.parse("01/10/200"));
		m.setEndDate(df.parse("03/02/2000"));
		m.setMedicationSource("OUTPATIENT");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setOrderNumber("10");
		m.setPatientId(patientId);
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("ATENOLOL 50MG TAB UD");
		m.setStartDate(df.parse("02/10/2000"));
		m.setEndDate(df.parse("04/02/2000"));
		m.setMedicationSource("OUTPATIENT");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID26");
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2011"));
		m.setOrderNumber("1058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2010"));
		m.setEndDate(DateHelper.parseDate("06/07/2012"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID26");
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2011"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("1057");
		m.setEndDate(DateHelper.parseDate("6/7/2012"));
		m.setStartDate(df.parse("6/7/2011"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID26");
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("1056");
		m.setEndDate(DateHelper.parseDate("6/7/2012"));
		m.setStartDate(df.parse("6/7/2011"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID26");
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("1055");
		m.setEndDate(DateHelper.parseDate("6/7/2012"));
		m.setStartDate(DateHelper.parseDate("6/7/2011"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID26");
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("1054");
		m.setEndDate(DateHelper.parseDate("6/1/2012"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID26");
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2011"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("1049");
		m.setEndDate(DateHelper.parseDate("05/20/2011"));
		m.setStartDate(df.parse("08/18/2011"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID26");
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("1048");
		m.setEndDate(DateHelper.parseDate("8/18/2011"));
		m.setStartDate(df.parse("5/20/2011"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID26");
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("1");
		m.setEndDate(DateHelper.parseDate("1/18/2011"));
		m.setStartDate(df.parse("4/18/2011"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID59");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("12/01/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH TRES A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("INPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("1");
		m.setEndDate(DateHelper.parseDate("1/18/2012"));
		m.setStartDate(df.parse("12/01/2011"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID60");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("12/01/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH FOUR TIMES A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("INPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("2");
		m.setEndDate(DateHelper.parseDate("1/18/2012"));
		m.setStartDate(df.parse("12/01/2011"));
		m.setDrugName("ACETAMINEPHINE 800MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID60");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("12/01/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH TRES A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("INPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("3");
		m.setEndDate(DateHelper.parseDate("1/18/2012"));
		m.setStartDate(df.parse("12/01/2011"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID60");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("12/01/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH ONCE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("INPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("4");
		m.setEndDate(DateHelper.parseDate("1/18/2012"));
		m.setStartDate(df.parse("12/01/2011"));
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID62");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("12/01/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH TRES A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("1");
		m.setEndDate(DateHelper.parseDate("1/18/2012"));
		m.setStartDate(df.parse("12/01/2011"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID62");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("11/01/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH ONCE A DAY");
		m.setStatus(STATUS_EXPIRED);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("2");
		m.setEndDate(DateHelper.parseDate("11/18/2011"));
		m.setStartDate(df.parse("11/01/2011"));
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID63");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("12/01/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH FOUR TIMES A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("3");
		m.setEndDate(DateHelper.parseDate("1/18/2012"));
		m.setStartDate(df.parse("12/01/2011"));
		m.setDrugName("Med C");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID63");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("12/01/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH TRES A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("4");
		m.setEndDate(DateHelper.parseDate("1/18/2012"));
		m.setStartDate(df.parse("12/01/2011"));
		m.setDrugName("Med B");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID63");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("12/01/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH ONCE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("5");
		m.setEndDate(DateHelper.parseDate("1/18/2012"));
		m.setStartDate(df.parse("12/01/2011"));
		m.setDrugName("Med A");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID63");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("12/01/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH FOUR TIMES A DAY");
		m.setStatus(STATUS_EXPIRED);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("6");
		m.setEndDate(DateHelper.parseDate("11/18/2011"));
		m.setStartDate(df.parse("11/01/2011"));
		m.setDrugName("Med N");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID63");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("12/01/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH TRES A DAY");
		m.setStatus(STATUS_EXPIRED);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("7");
		m.setEndDate(DateHelper.parseDate("11/18/2011"));
		m.setStartDate(df.parse("11/01/2011"));
		m.setDrugName("Med P");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID63");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("12/01/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH ONCE A DAY");
		m.setStatus(STATUS_EXPIRED);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("8");
		m.setEndDate(DateHelper.parseDate("11/18/2011"));
		m.setStartDate(df.parse("11/01/2011"));
		m.setDrugName("Med G");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID63");
		m.setDaysSupply("5");
		m.setQuantity("15");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("12/01/2011"));
		m.setSig("As you feel like it");
		m.setStatus(STATUS_EXPIRED);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("9");
		m.setEndDate(DateHelper.parseDate("11/18/2011"));
		m.setStartDate(df.parse("11/01/2011"));
		m.setDrugName("Non-VA Med");
		m.setMedicationSource("OTHER");
		m.setSourceSystem("Other");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID56");
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("1056");
		m.setEndDate(DateHelper.parseDate("6/7/2012"));
		m.setStartDate(df.parse("6/7/2011"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2011"));
		m.setOrderNumber("1058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2010"));
		m.setEndDate(DateHelper.parseDate("06/07/2012"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2011"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("1057");
		m.setEndDate(DateHelper.parseDate("6/7/2012"));
		m.setStartDate(df.parse("6/7/2011"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("1056");
		m.setEndDate(DateHelper.parseDate("6/7/2012"));
		m.setStartDate(df.parse("6/7/2011"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("1055");
		m.setEndDate(DateHelper.parseDate("6/7/2012"));
		m.setStartDate(DateHelper.parseDate("6/7/2011"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("1054");
		m.setEndDate(DateHelper.parseDate("6/1/2012"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2011"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("1049");
		m.setEndDate(DateHelper.parseDate("05/20/2011"));
		m.setStartDate(df.parse("08/18/2011"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("1048");
		m.setEndDate(DateHelper.parseDate("8/18/2011"));
		m.setStartDate(df.parse("5/20/2011"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId("PATID64");
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2011"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("1");
		m.setEndDate(DateHelper.parseDate("1/18/2011"));
		m.setStartDate(df.parse("4/18/2011"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2010"));
		m.setOrderNumber("11058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2010"));
		m.setEndDate(DateHelper.parseDate("06/07/2011"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2010"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("11057");
		m.setEndDate(DateHelper.parseDate("6/7/2011"));
		m.setStartDate(df.parse("6/7/2010"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2010"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("11056");
		m.setEndDate(DateHelper.parseDate("6/7/2011"));
		m.setStartDate(df.parse("6/7/2010"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2010"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("11055");
		m.setEndDate(DateHelper.parseDate("6/7/2011"));
		m.setStartDate(DateHelper.parseDate("6/7/2010"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2010"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("11054");
		m.setEndDate(DateHelper.parseDate("6/1/2011"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2010"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("11049");
		m.setEndDate(DateHelper.parseDate("05/20/2010"));
		m.setStartDate(df.parse("08/18/2010"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2010"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("11048");
		m.setEndDate(DateHelper.parseDate("8/18/2010"));
		m.setStartDate(df.parse("5/20/2010"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2010"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("11");
		m.setEndDate(DateHelper.parseDate("1/18/2010"));
		m.setStartDate(df.parse("4/18/2010"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2009"));
		m.setOrderNumber("21058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2009"));
		m.setEndDate(DateHelper.parseDate("06/07/2010"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2009"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("21057");
		m.setEndDate(DateHelper.parseDate("6/7/2010"));
		m.setStartDate(df.parse("6/7/2009"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2009"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("21056");
		m.setEndDate(DateHelper.parseDate("6/7/2010"));
		m.setStartDate(df.parse("6/7/2009"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2009"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("21055");
		m.setEndDate(DateHelper.parseDate("6/7/2010"));
		m.setStartDate(DateHelper.parseDate("6/7/2009"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2009"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("21054");
		m.setEndDate(DateHelper.parseDate("6/1/2010"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2009"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("21049");
		m.setEndDate(DateHelper.parseDate("05/20/2009"));
		m.setStartDate(df.parse("08/18/2009"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2009"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("21048");
		m.setEndDate(DateHelper.parseDate("8/18/2009"));
		m.setStartDate(df.parse("5/20/2009"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2009"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("21");
		m.setEndDate(DateHelper.parseDate("1/18/2009"));
		m.setStartDate(df.parse("4/18/2009"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2008"));
		m.setOrderNumber("31058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2008"));
		m.setEndDate(DateHelper.parseDate("06/07/2009"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2008"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("31057");
		m.setEndDate(DateHelper.parseDate("6/7/2009"));
		m.setStartDate(df.parse("6/7/2008"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2008"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("31056");
		m.setEndDate(DateHelper.parseDate("6/7/2009"));
		m.setStartDate(df.parse("6/7/2008"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2008"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("31055");
		m.setEndDate(DateHelper.parseDate("6/7/2009"));
		m.setStartDate(DateHelper.parseDate("6/7/2008"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2008"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("31054");
		m.setEndDate(DateHelper.parseDate("6/1/2009"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2008"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("31049");
		m.setEndDate(DateHelper.parseDate("05/20/2008"));
		m.setStartDate(df.parse("08/18/2008"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2008"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("31048");
		m.setEndDate(DateHelper.parseDate("8/18/2008"));
		m.setStartDate(df.parse("5/20/2008"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2008"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("31");
		m.setEndDate(DateHelper.parseDate("1/18/2008"));
		m.setStartDate(df.parse("4/18/2008"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2007"));
		m.setOrderNumber("41058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2007"));
		m.setEndDate(DateHelper.parseDate("06/07/2008"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2007"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("41057");
		m.setEndDate(DateHelper.parseDate("6/7/2008"));
		m.setStartDate(df.parse("6/7/2007"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2007"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("41056");
		m.setEndDate(DateHelper.parseDate("6/7/2008"));
		m.setStartDate(df.parse("6/7/2007"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2007"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("41055");
		m.setEndDate(DateHelper.parseDate("6/7/2008"));
		m.setStartDate(DateHelper.parseDate("6/7/2007"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2007"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("41054");
		m.setEndDate(DateHelper.parseDate("6/1/2008"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2007"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("41049");
		m.setEndDate(DateHelper.parseDate("05/20/2007"));
		m.setStartDate(df.parse("08/18/2007"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2007"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("41048");
		m.setEndDate(DateHelper.parseDate("8/18/2007"));
		m.setStartDate(df.parse("5/20/2007"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2007"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("41");
		m.setEndDate(DateHelper.parseDate("1/18/2007"));
		m.setStartDate(df.parse("4/18/2007"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2006"));
		m.setOrderNumber("51058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2006"));
		m.setEndDate(DateHelper.parseDate("06/07/2007"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2006"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("51057");
		m.setEndDate(DateHelper.parseDate("6/7/2007"));
		m.setStartDate(df.parse("6/7/2006"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2006"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("51056");
		m.setEndDate(DateHelper.parseDate("6/7/2007"));
		m.setStartDate(df.parse("6/7/2006"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2006"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("51055");
		m.setEndDate(DateHelper.parseDate("6/7/2007"));
		m.setStartDate(DateHelper.parseDate("6/7/2006"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2006"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("51054");
		m.setEndDate(DateHelper.parseDate("6/1/2007"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2006"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("51049");
		m.setEndDate(DateHelper.parseDate("05/20/2006"));
		m.setStartDate(df.parse("08/18/2006"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2006"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("51048");
		m.setEndDate(DateHelper.parseDate("8/18/2006"));
		m.setStartDate(df.parse("5/20/2006"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2006"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("51");
		m.setEndDate(DateHelper.parseDate("1/18/2006"));
		m.setStartDate(df.parse("4/18/2006"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2005"));
		m.setOrderNumber("61058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2005"));
		m.setEndDate(DateHelper.parseDate("06/07/2006"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2005"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("61057");
		m.setEndDate(DateHelper.parseDate("6/7/2006"));
		m.setStartDate(df.parse("6/7/2005"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2005"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("61056");
		m.setEndDate(DateHelper.parseDate("6/7/2006"));
		m.setStartDate(df.parse("6/7/2005"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2005"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("61055");
		m.setEndDate(DateHelper.parseDate("6/7/2006"));
		m.setStartDate(DateHelper.parseDate("6/7/2005"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2005"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("61054");
		m.setEndDate(DateHelper.parseDate("6/1/2006"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2005"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("61049");
		m.setEndDate(DateHelper.parseDate("05/20/2005"));
		m.setStartDate(df.parse("08/18/2005"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2005"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("61048");
		m.setEndDate(DateHelper.parseDate("8/18/2005"));
		m.setStartDate(df.parse("5/20/2005"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2005"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("61");
		m.setEndDate(DateHelper.parseDate("1/18/2005"));
		m.setStartDate(df.parse("4/18/2005"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2004"));
		m.setOrderNumber("71058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2004"));
		m.setEndDate(DateHelper.parseDate("06/07/2005"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2004"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("71057");
		m.setEndDate(DateHelper.parseDate("6/7/2005"));
		m.setStartDate(df.parse("6/7/2004"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2004"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("71056");
		m.setEndDate(DateHelper.parseDate("6/7/2005"));
		m.setStartDate(df.parse("6/7/2004"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2004"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("71055");
		m.setEndDate(DateHelper.parseDate("6/7/2005"));
		m.setStartDate(DateHelper.parseDate("6/7/2004"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2004"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("71054");
		m.setEndDate(DateHelper.parseDate("6/1/2005"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2004"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("71049");
		m.setEndDate(DateHelper.parseDate("05/20/2004"));
		m.setStartDate(df.parse("08/18/2004"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2004"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("71048");
		m.setEndDate(DateHelper.parseDate("8/18/2004"));
		m.setStartDate(df.parse("5/20/2004"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2004"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("71");
		m.setEndDate(DateHelper.parseDate("1/18/2004"));
		m.setStartDate(df.parse("4/18/2004"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2003"));
		m.setOrderNumber("81058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2003"));
		m.setEndDate(DateHelper.parseDate("06/07/2004"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2003"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("81057");
		m.setEndDate(DateHelper.parseDate("6/7/2004"));
		m.setStartDate(df.parse("6/7/2003"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2003"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("81056");
		m.setEndDate(DateHelper.parseDate("6/7/2004"));
		m.setStartDate(df.parse("6/7/2003"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2003"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("81055");
		m.setEndDate(DateHelper.parseDate("6/7/2004"));
		m.setStartDate(DateHelper.parseDate("6/7/2003"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2003"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("81054");
		m.setEndDate(DateHelper.parseDate("6/1/2004"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2003"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("81049");
		m.setEndDate(DateHelper.parseDate("05/20/2003"));
		m.setStartDate(df.parse("08/18/2003"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2003"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("81048");
		m.setEndDate(DateHelper.parseDate("8/18/2003"));
		m.setStartDate(df.parse("5/20/2003"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2003"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("81");
		m.setEndDate(DateHelper.parseDate("1/18/2003"));
		m.setStartDate(df.parse("4/18/2003"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2002"));
		m.setOrderNumber("91058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2002"));
		m.setEndDate(DateHelper.parseDate("06/07/2003"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2002"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("91057");
		m.setEndDate(DateHelper.parseDate("6/7/2003"));
		m.setStartDate(df.parse("6/7/2002"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2002"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("91056");
		m.setEndDate(DateHelper.parseDate("6/7/2003"));
		m.setStartDate(df.parse("6/7/2002"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2002"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("91055");
		m.setEndDate(DateHelper.parseDate("6/7/2003"));
		m.setStartDate(DateHelper.parseDate("6/7/2002"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2002"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("91054");
		m.setEndDate(DateHelper.parseDate("6/1/2003"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2002"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("91049");
		m.setEndDate(DateHelper.parseDate("05/20/2002"));
		m.setStartDate(df.parse("08/18/2002"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2002"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("91048");
		m.setEndDate(DateHelper.parseDate("8/18/2002"));
		m.setStartDate(df.parse("5/20/2002"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2002"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("91");
		m.setEndDate(DateHelper.parseDate("1/18/2002"));
		m.setStartDate(df.parse("4/18/2002"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2001"));
		m.setOrderNumber("101058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2001"));
		m.setEndDate(DateHelper.parseDate("06/07/2002"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2001"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("101057");
		m.setEndDate(DateHelper.parseDate("6/7/2002"));
		m.setStartDate(df.parse("6/7/2001"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2001"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("101056");
		m.setEndDate(DateHelper.parseDate("6/7/2002"));
		m.setStartDate(df.parse("6/7/2001"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2001"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("101055");
		m.setEndDate(DateHelper.parseDate("6/7/2002"));
		m.setStartDate(DateHelper.parseDate("6/7/2001"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2001"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("101054");
		m.setEndDate(DateHelper.parseDate("6/1/2002"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2001"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("101049");
		m.setEndDate(DateHelper.parseDate("05/20/2001"));
		m.setStartDate(df.parse("08/18/2001"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2001"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("101048");
		m.setEndDate(DateHelper.parseDate("8/18/2001"));
		m.setStartDate(df.parse("5/20/2001"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2001"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("101");
		m.setEndDate(DateHelper.parseDate("1/18/2001"));
		m.setStartDate(df.parse("4/18/2001"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2000"));
		m.setOrderNumber("111058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/2000"));
		m.setEndDate(DateHelper.parseDate("06/07/2001"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2000"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("111057");
		m.setEndDate(DateHelper.parseDate("6/7/2001"));
		m.setStartDate(df.parse("6/7/2000"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2000"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("111056");
		m.setEndDate(DateHelper.parseDate("6/7/2001"));
		m.setStartDate(df.parse("6/7/2000"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/2000"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("111055");
		m.setEndDate(DateHelper.parseDate("6/7/2001"));
		m.setStartDate(DateHelper.parseDate("6/7/2000"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/2000"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("111054");
		m.setEndDate(DateHelper.parseDate("6/1/2001"));
		m.setStartDate(df.parse("6/1/2000"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2000"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("111049");
		m.setEndDate(DateHelper.parseDate("05/20/2000"));
		m.setStartDate(df.parse("08/18/2000"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/2000"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("111048");
		m.setEndDate(DateHelper.parseDate("8/18/2000"));
		m.setStartDate(df.parse("5/20/2000"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/2000"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("111");
		m.setEndDate(DateHelper.parseDate("1/18/2000"));
		m.setStartDate(df.parse("4/18/2000"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		
		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/1999"));
		m.setOrderNumber("121058");
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setDrugName("RABEPRAZOLE NA 20MG EC TAB");
		m.setStartDate(df.parse("03/10/1999"));
		m.setEndDate(DateHelper.parseDate("06/07/2000"));
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("34R;O");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/1999"));
		m.setSig("TAKE TWO TABLETS BY MOUTH QDAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("33R;O");
		m.setOrderNumber("121057");
		m.setEndDate(DateHelper.parseDate("6/7/2000"));
		m.setStartDate(df.parse("6/7/1999"));
		m.setDrugName("GLYBURIDE 5MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/1999"));
		m.setSig("TAKE ONE TABLET BY MOUTH QD");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("32R");
		m.setOrderNumber("121056");
		m.setEndDate(DateHelper.parseDate("6/7/2000"));
		m.setStartDate(df.parse("6/7/1999"));
		m.setDrugName("ASPIRIN 81MG EC TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/7/1999"));
		m.setSig("TAKE ONE TABLET BY MOUTH EVERY MORNING");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("21R");
		m.setOrderNumber("121055");
		m.setEndDate(DateHelper.parseDate("6/7/2000"));
		m.setStartDate(DateHelper.parseDate("6/7/1999"));
		m.setDrugName("ATENOLOL 50MG TAB UD");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("30");
		m.setQuantity("30");
		m.setRefills("3");
		m.setLastFilledDate(DateHelper.parseDate("6/1/1999"));
		m.setSig("TAKE ONE TABLET BY MOUTH AT BEDTIME");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("30R");
		m.setOrderNumber("121054");
		m.setEndDate(DateHelper.parseDate("6/1/2000"));
		m.setStartDate(df.parse("6/1/1999"));
		m.setDrugName("LISINOPRIL 10MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/1999"));
		m.setSig("TAKE ONE CAPSULE BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("26R");
		m.setOrderNumber("121049");
		m.setEndDate(DateHelper.parseDate("05/20/1999"));
		m.setStartDate(df.parse("08/18/1999"));
		m.setDrugName("RAMIPRIL 2.5MG CAP");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("5/20/1999"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("121048");
		m.setEndDate(DateHelper.parseDate("8/18/1999"));
		m.setStartDate(df.parse("5/20/1999"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		m = new Medication();
		m.setUniqueId(UUID.randomUUID().toString());
		m.setPatientId(patientId);
		m.setDaysSupply("90");
		m.setQuantity("180");
		m.setRefills("0");
		m.setLastFilledDate(DateHelper.parseDate("3/16/1999"));
		m.setSig("TAKE ONE TABLET BY MOUTH TWICE A DAY");
		m.setStatus(STATUS_ACTIVE);
		m.setMedicationSource("OUTPATIENT");
		m.setPrescriptionId("25R");
		m.setOrderNumber("121");
		m.setEndDate(DateHelper.parseDate("1/18/1999"));
		m.setStartDate(df.parse("4/18/1999"));
		m.setDrugName("HYDROCHLOROTHIAZIDE 25MG TAB");
		medications.add(m);

		for (Medication medication : medications) {
			if (NullChecker.isNullish(medication.getSourceSystem())) {
				medication.setSourceSystem("VA");
			}
		}
		
		medicationStore.put(patientId, medications);
	}

	private void fillMedicationDetail(Medication medication) {
		String detail = getMedicationDetailResource(medication.getPatientId(), medication.getOrderNumber());
		if (NullChecker.isNotNullish(detail)) {
			medication.setMedicationDetail(detail);
		}

	}

	private String getMedicationDetailResource(String patientId, String orderNumber) {
		LOGGER.debug("filling medication detail for " + patientId + ";" + orderNumber);
		String resourceName = String.format("med.%s.%s.detail.txt", patientId, orderNumber);
		InputStream resourceStream = this.getClass().getResourceAsStream(resourceName);
		String detail = null;
		if (resourceStream != null) {
			boolean closeStreamWhenComplete = true;
			detail = StreamHelper.streamToString(resourceStream, closeStreamWhenComplete);
			LOGGER.debug("found medication detail => " + detail);

		}
		return detail;
	}

	@Override
	public Medications getMedications(PatientIdentifier patientId, boolean activeOnly) {
		Medications medMatches = new Medications();
		Medications patientMedications = getMedicationsNotNull(patientId.getUniqueId());
		for (Medication medication : patientMedications) {
			if (medication.getPatientId().equals(patientId)) {
				if (!activeOnly || medication.isActive() || isRecentlyExpired(medication)) {
					medMatches.add(medication);
				}
			}
		}
		return medMatches;
	}

	private boolean isRecentlyExpired(Medication medication) {
		boolean isRecentlyExpired;
		if (medication.isActive()) {
			isRecentlyExpired = false;
		} else {
			final Date now = DateHelper.getToday();
			final Date medicationStopDate = medication.getEndDate();
			if (NullChecker.isNotNullish(medicationStopDate)) {
				int numberOfDaysExpired = DateHelper.calculateDeltaInDays(medicationStopDate, now);
				isRecentlyExpired = (numberOfDaysExpired <= MAX_NUMBER_DAYS_EXPIRED_TO_TREAT_AS_ACTIVE);
			} else {
				isRecentlyExpired = false;
			}
		}
		return isRecentlyExpired;
	}

	@Override
	public Medication getMedicationLite(PatientIdentifier patientId, String orderNumber) {
		Medication matchingMedication = findMedication(patientId.getUniqueId(), orderNumber);
		return matchingMedication;
	}

	@Override
	public Medication getMedicationDetail(PatientIdentifier patientId, String orderNumber) {
		Medication matchingMedication = findMedication(patientId.getUniqueId(), orderNumber);
		if (matchingMedication != null) {

			if (NullChecker.isNullish(matchingMedication.getMedicationDetail())) {
				fillMedicationDetail(matchingMedication);
			}
			if (NullChecker.isNullish(matchingMedication.getMedicationDetail())) {
				matchingMedication.setMedicationDetail("Med detail: " + matchingMedication.getDrugName());
			}
		}

		return matchingMedication;
	}

	private Medication findMedication(String patientId, String orderNumber) {
		Medication matchingMedication = null;
		Medications medications = getMedicationsNotNull(patientId);
		for (Medication medication : medications) {
			if (medication.getPatientId().equalsIgnoreCase(patientId) && medication.getOrderNumber().equalsIgnoreCase(orderNumber)) {
				matchingMedication = medication;
			}
		}

		if (matchingMedication != null) {
			matchingMedication = cloneMedication(matchingMedication);
		}
		return matchingMedication;
	}

	private Medication cloneMedication(Medication medication) {
		Medication clonedMed = new Medication();

		clonedMed.setOrderNumber(medication.getOrderNumber());
		clonedMed.setPatientId(medication.getPatientId());
		clonedMed.setDrugName(medication.getDrugName());
		clonedMed.setStartDate(medication.getStartDate());
		clonedMed.setEndDate(medication.getEndDate());
		clonedMed.setMedicationSource(medication.getMedicationSource());
		clonedMed.setDaysSupply(medication.getDaysSupply());
		clonedMed.setQuantity(medication.getQuantity());
		clonedMed.setSig(medication.getSig());
		clonedMed.setLastFilledDate(medication.getLastFilledDate());
		clonedMed.setRefills(medication.getRefills());
		clonedMed.setStatus(medication.getStatus());
		clonedMed.setCategory(medication.getCategory());
		clonedMed.setPharmacy(medication.getPharmacy());

		return clonedMed;
	}

	@Override
	public Medications getMedications(PatientIdentifier patientId, MedicationFilter medicationFilter) {
		Medications patientMeds = new Medications();
		Medications medications = getMedicationsNotNull(patientId.getUniqueId());
		for (Medication medication : medications) {
			if (medication.getPatientId().equals(patientId.getUniqueId()))
				patientMeds.add(medication);
		}
		return patientMeds;
	}

	
	Medications getMedicationsNotNull(String patientId) {
		if(patientId == null) 
			return new Medications();
		
		Medications medications = medicationStore.get(patientId);
		if(medications == null) {
			return new Medications();
		}
		return medications;
	}
	
}
