package com.agilex.healthcare.mobilehealthplatform.datalayer.learn;

import com.agilex.healthcare.mobilehealthplatform.domain.LearnArticle;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategory;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCondition;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnConditions;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnSubCategory;

public class LearnDataLayerMock implements LearnDataLayer {

	public LearnDataLayerMock() {
	}

	@Override
	public LearnConditions fetchLearnConditions() {
		LearnConditions conditions = new LearnConditions();

		LearnCondition condition1 = new LearnCondition();
		condition1.setId("condition1");
		condition1.setTitle("First Condition");
		conditions.add(condition1);

		LearnCondition condition2 = new LearnCondition();
		condition2.setId("condition2");
		condition2.setTitle("Second Condition");
		conditions.add(condition2);

		return conditions;
	}

	@Override
	public LearnCategories fetchLearnCategories(LearnCondition condition) {
		LearnCategories categories = new LearnCategories();

		LearnCategory categoryA = new LearnCategory();
		categoryA.setId("categoryA");
		categoryA.setTitle("Learn about Category A");
		categories.add(categoryA);

		LearnCategory categoryB = new LearnCategory();
		categoryB.setId("categoryB");
		categoryB.setTitle("Learn about Category B");
		categories.add(categoryB);

		LearnCategory categoryC = new LearnCategory();
		categoryC.setId("categoryC");
		categoryC.setTitle("Learn about Category C");
		categories.add(categoryC);

		return categories;
	}

	@Override
	public LearnCategory fetchLearnCategory(String categoryId) {
		LearnCategory categoryA = new LearnCategory();
		categoryA.setId("categoryA");
		categoryA.setTitle("Learn about Category A");

		LearnSubCategory subCategory1 = new LearnSubCategory();
		subCategory1.setId("subcat1");
		subCategory1.setTitle("SubCategory 1");

		LearnArticle articleA = new LearnArticle();
		articleA.setId("articleA");
		articleA.setTitle("What is Article A about?");
		subCategory1.getArticles().add(articleA);

		LearnArticle articleB = new LearnArticle();
		articleB.setId("articleB");
		articleB.setTitle("What is Article B about?");
		subCategory1.getArticles().add(articleB);

		categoryA.getSubCategories().add(subCategory1);

		LearnSubCategory subCategory2 = new LearnSubCategory();
		subCategory2.setId("subcat2");
		subCategory2.setTitle("SubCategory 2");

		LearnArticle articleC = new LearnArticle();
		articleC.setId("articleC");
		articleC.setTitle("What is Article C about?");
		subCategory2.getArticles().add(articleC);

		LearnArticle articleD = new LearnArticle();
		articleD.setId("articleD");
		articleD.setTitle("What is Article D about?");
		subCategory2.getArticles().add(articleB);

		categoryA.getSubCategories().add(subCategory2);

		return categoryA;
	}

	@Override
	public LearnArticle fetchLearnArticle(String articleId) {
		LearnArticle articleA = new LearnArticle();
		articleA.setId("articleA");
		articleA.setTitle("What is Article A about?");
		articleA.setContent("Article A provides information about the letter A.");
		return articleA;
	}
}