package com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro;

import java.util.List;
import java.util.Map;

import com.agilex.healthcare.mobilehealthplatform.MHPConstants;
import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.LabDataExcelRetriever;
import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.LabFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

public class MicrobiologyLabDataLayerExcel implements MicrobiologyLabDataLayer {

	@Override
	public LabResults getLabResults(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		LabDataExcelRetriever retriever = new LabDataExcelRetriever();
		LabResults labResults = retriever.getLabResults(patientIdentifier, dateFilter);
		for (LabResult labResult : labResults) {
			labResult.setUniqueId(labResult.getAccessionNumber());
			labResult.setSourceSystem("VA");
		}
		return LabFilter.filterByType(labResults, MHPConstants.LABTYPE_MICROBIOLOGY);
	}

	@Override
	public LabResults getLabResultsLite(String patientId, DateFilter dateFilter) {
		LabDataExcelRetriever retriever = new LabDataExcelRetriever();
		LabResults labResults = retriever.getLabResultsLite(patientId, dateFilter);
		for (LabResult labResult : labResults) {
			labResult.setUniqueId(labResult.getAccessionNumber());
			labResult.setSourceSystem("VA");
		}
		return LabFilter.filterByType(labResults, MHPConstants.LABTYPE_MICROBIOLOGY);
	}

	@Override
	public LabResults getLabResultsByTestId(PatientIdentifier patientIdentifier, String testId) {
		LabDataExcelRetriever retriever = new LabDataExcelRetriever();
		LabResults labResults = retriever.getLabResults(patientIdentifier, null);
		LabResults labsForTestId = new LabResults();
		for (LabResult result : labResults) {
			if (testId.equalsIgnoreCase(result.getTestId())) {
				labsForTestId.add(result);
			}
		}

		return labsForTestId;
	}

	@Override
	public LabTestGroups lookupLabGroupsByTestId(String labTestId) {
		return null;
	}

	@Override
	public Map<String, LabTestGroups> lookupLabGroupsByTestIds(List<String> labTestIds) {
		return null;
	}

}
