package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.utility.NullSafeStringComparer;

public class LabFilter {
	public static LabResults filterByType(LabResults results, String... labTypes) {
		if (results == null)
			return null;

		LabResults filteredResults = new LabResults();
		for (String labType : labTypes) {
			for (LabResult possibleMatch : results) {
				if (isMatch(possibleMatch, labType)) {
					filteredResults.add(possibleMatch);
				}
			}
		}
		return filteredResults;
	}

	private static boolean isMatch(LabResult possibleMatch, String labType) {
		return NullSafeStringComparer.areEqual(possibleMatch.getLabType(), labType);
	}

}
