package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import java.util.List;
import java.util.Map;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import com.agilex.healthcare.utility.DateHelper;

public class ChemistryLabDataLayerMock implements LabDataLayer {
	private LabResults resultStore = createDataStore();

	private static void createTestPatientALabs(LabResults results) {
		String labPatientId = "D123401";
		String dateformat = "MM/dd/yyyy HH:mm:ss";
		String testA_name = "K";
		String testA_id = "1";
		String valueUnits = "mEq/L";
		String referenceHigh = "5.0";
		String referenceLow = "3.5";
		String specimen = "70"; // id for BLOOD = 70
		String specimenName = "BLOOD";
		LabResult r;

		r = new LabResult();
		r.setPatientId(labPatientId);
		r.setTestname(testA_name);
		r.setTestId(testA_id);
		r.setReferenceHigh(referenceHigh);
		r.setReferenceLow(referenceLow);
		r.setValueUnits(valueUnits);
		r.setAccessionNumber("1");
		r.setValue("3.6");
		r.setIndicator("");
		r.setResultedDate(DateHelper.parse("02/01/2011 13:01:01", dateformat));
		results.add(r);

		r = new LabResult();
		r.setPatientId(labPatientId);
		r.setTestname(testA_name);
		r.setTestId(testA_id);
		r.setReferenceHigh(referenceHigh);
		r.setReferenceLow(referenceLow);
		r.setValueUnits(valueUnits);
		r.setAccessionNumber("2");
		r.setValue("5.1");
		r.setIndicator("H");
		r.setResultedDate(DateHelper.parse("02/02/2011 14:02:02", dateformat));
		results.add(r);

		r = new LabResult();
		r.setPatientId(labPatientId);
		r.setTestname(testA_name);
		r.setTestId(testA_id);
		r.setReferenceHigh(referenceHigh);
		r.setReferenceLow(referenceLow);
		r.setValueUnits(valueUnits);
		r.setAccessionNumber("3");
		r.setValue("2.0");
		r.setIndicator("L");
		r.setResultedDate(DateHelper.parse("02/03/2011 15:03:03", dateformat));
		results.add(r);

		r = new LabResult();
		r.setPatientId(labPatientId);
		r.setTestname(testA_name);
		r.setTestId(testA_id);
		r.setReferenceHigh(referenceHigh);
		r.setReferenceLow(referenceLow);
		r.setValueUnits(valueUnits);
		r.setAccessionNumber("100");
		r.setValue("4.5");
		r.setIndicator("");
		r.setResultedDate(DateHelper.parse("02/05/2011 00:00:00", dateformat));
		results.add(r);

		r = new LabResult();
		r.setPatientId(labPatientId);
		r.setTestname("NA");
		r.setTestId("2");
		r.setReferenceHigh("1");
		r.setReferenceLow("1.1");
		r.setValueUnits(valueUnits);
		r.setAccessionNumber("NA1");
		r.setValue("0.6");
		r.setIndicator("normal");
		r.setResultedDate(DateHelper.parse("02/10/2010 13:01:01", dateformat));
		r.setSpecimenId(specimen);
		r.setSpecimenName(specimenName);
		results.add(r);

		r = new LabResult();
		r.setPatientId(labPatientId);
		r.setTestname("NA");
		r.setTestId("2");
		r.setReferenceHigh("1");
		r.setReferenceLow("1.1");
		r.setValueUnits(valueUnits);
		r.setAccessionNumber("NA1");
		r.setValue("1.0");
		r.setIndicator("normal");
		r.setResultedDate(DateHelper.parse("07/23/2010 15:01:01", dateformat));
		r.setSpecimenId(specimen);
		r.setSpecimenName(specimenName);
		results.add(r);

		r = new LabResult();
		r.setPatientId(labPatientId);
		r.setTestname("NA");
		r.setTestId("2");
		r.setReferenceHigh("1");
		r.setReferenceLow("1.1");
		r.setValueUnits(valueUnits);
		r.setAccessionNumber("NA1");
		r.setValue("0.8");
		r.setIndicator("normal");
		r.setResultedDate(DateHelper.parse("11/23/2010 05:01:01", dateformat));
		r.setSpecimenId(specimen);
		r.setSpecimenName(specimenName);
		results.add(r);

	}

	private static LabResults createDataStore() {
		LabResults results = new LabResults();
		createTestPatientALabs(results);
		return results;
	}

	@Override
	public LabResults getLabResults(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		String patientId = patientIdentifier.getUniqueId();
		LabResults results = new LabResults();
		for (LabResult result : resultStore) {
			if (patientId.contentEquals(result.getPatientId())) {
				results.add(result);
			}
		}

		LabResults filteredResults = DateFilterer.filterByDate(results, dateFilter);
		return filteredResults;
	}

	@Override
	public LabTestGroups lookupLabGroupsByTestId(String labTestId) {
		return null;
	}

	@Override
	public Map<String, LabTestGroups> lookupLabGroupsByTestIds(List<String> labTestIds) {
		return null;
	}

	@Override
	public LabResults getLabResultsByTestId(PatientIdentifier patientIdentifier, String testId) {
		return null;
	}

	@Override
	public LabResults getLabResultsLite(String patientId, DateFilter dateFilter) {
		return null;
	}

}
