package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import java.util.List;
import java.util.Map;

import com.agilex.healthcare.mobilehealthplatform.MHPConstants;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

public class ChemistryLabDataLayerExcel implements ChemistryLabDataLayer {

	@Override
	public LabResults getLabResults(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		LabDataExcelRetriever retriever = new LabDataExcelRetriever();
		LabResults labResults = retriever.getLabResults(patientIdentifier, dateFilter);
		for (LabResult labResult : labResults)
			labResult.setSourceSystem("VA");
		return LabFilter.filterByType(labResults, MHPConstants.LABTYPE_CHEMISTRY);
	}

	@Override
	public LabResults getLabResultsByTestId(PatientIdentifier patientIdentifier, String testId) {
		return null;
	}

	@Override
	public LabTestGroups lookupLabGroupsByTestId(String labTestId) {
		return null;
	}

	@Override
	public Map<String, LabTestGroups> lookupLabGroupsByTestIds(List<String> labTestIds) {
		return null;
	}

	@Override
	public LabResults getLabResultsLite(String patientId, DateFilter dateFilter) {
		return null;
	}
}
