package com.agilex.healthcare.mobilehealthplatform.datalayer.healthadvocaterequest;

import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequest;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequestForm;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequests;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateStatusCode;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;

public class HealthAdvocateRequestDataLayerMock implements HealthAdvocateRequestDataLayer {
	private HealthAdvocateRequests healthAdvocateRequestDataStore = null;
	
	public HealthAdvocateRequestDataLayerMock() {
		healthAdvocateRequestDataStore = initializeHealthAdvocateRequestDataStore();
	}
	
	private HealthAdvocateRequest cloneHealthAdvocateRequest(HealthAdvocateRequest request){
		HealthAdvocateRequest newRequest = new HealthAdvocateRequest();
		newRequest.setLastActionDate(request.getLastActionDate());
		newRequest.setAddressFirstLine(request.getAddressFirstLine());
		newRequest.setAddressSecondLine(request.getAddressSecondLine());
		newRequest.setCity(request.getCity());
		newRequest.setEmail(request.getEmail());
		newRequest.setFirstName(request.getFirstName());
		newRequest.setHealthAdvocateEDIPI(request.getHealthAdvocateEDIPI());
		newRequest.setLastName(request.getLastName());
		newRequest.setPatientId(request.getPatientId());
		newRequest.setUniqueId(request.getUniqueId());
		newRequest.setRequestDate(request.getRequestDate());
		newRequest.setStatus(request.getStatus());
		newRequest.setState(request.getState());
		newRequest.setUriLinkKey(request.getUriLinkKey());
		newRequest.setZipCode(request.getZipCode());
		newRequest.setPatientName(request.getPatientName());
		newRequest.setDriversLicenseNumber(request.getDriversLicenseNumber());
		newRequest.setDriversLicenseState(request.getDriversLicenseState());
		newRequest.setPatientDisplayName(request.getPatientDisplayName());
		newRequest.setSsn(request.getSsn());
		return newRequest;
	}
	
	private HealthAdvocateRequests initializeHealthAdvocateRequestDataStore() {
		HealthAdvocateRequests healthAdvocateRequests = new HealthAdvocateRequests();
		HealthAdvocateRequest r;

	
	
		r = new HealthAdvocateRequest();
		r.setLastActionDate(DateHelper.get6MonthsAgo());
		r.setAddressFirstLine("0 East North Street");
		r.setAddressSecondLine("Apt 0");
		r.setCity("Chantilly");
		r.setEmail("testEmail6@testEmail.com");
		r.setFirstName("Declined");
		r.setHealthAdvocateEDIPI("8888");
		r.setLastName("Test");
		r.setPatientId("D123401");
		r.setUniqueId("10");
		r.setRequestDate(DateHelper.get6MonthsAgo());
		r.setStatus(HealthAdvocateStatusCode.DECLINED);
		r.setState("VA");
		r.setUriLinkKey("secret9");
		r.setZipCode("22222");
		r.setPatientName("Demopatient One");
		r.setDriversLicenseNumber("987654331");
		r.setDriversLicenseState("NY");
		r.setSsn("999-99-9999");
		healthAdvocateRequests.add(r);
		
		r = new HealthAdvocateRequest();
		r.setLastActionDate(DateHelper.get3MonthsAgo());
		r.setAddressFirstLine("00 Fallen St");
		r.setAddressSecondLine("Apt 0");
		r.setCity("Chantilly");
		r.setEmail("testEmail3@testEmail.com");
		r.setFirstName("User");
		r.setHealthAdvocateEDIPI("3333");
		r.setLastName("Test");
		r.setPatientId("D123401");
		r.setUniqueId("5");
		r.setRequestDate(DateHelper.get3MonthsAgo());
		r.setStatus(HealthAdvocateStatusCode.DECLINED);
		r.setState("VA");
		r.setUriLinkKey("secret4");
		r.setZipCode("22222");
		r.setPatientName("Demopatient One");
		r.setDriversLicenseNumber("987654325");
		r.setDriversLicenseState("NY");
		r.setSsn("999-99-9999");

		healthAdvocateRequests.add(r);
		
		r = new HealthAdvocateRequest();
		r.setLastActionDate(DateHelper.get6MonthsAgo());
		r.setAddressFirstLine("00 Main Street");
		r.setAddressSecondLine("Apt 0");
		r.setCity("Chantilly");
		r.setEmail("testEmail2@testEmail.com");
		r.setFirstName("User");
		r.setHealthAdvocateEDIPI("2222");
		r.setLastName("Test");
		r.setPatientId("D123401");
		r.setUniqueId("2");
		r.setRequestDate(DateHelper.get6MonthsAgo());
		r.setStatus(HealthAdvocateStatusCode.REVOKED);
		r.setState("VA");
		r.setUriLinkKey("secret2");
		r.setZipCode("22222");
		r.setPatientName("Demopatient One");
		r.setDriversLicenseNumber("987654322");
		r.setDriversLicenseState("NY");
		r.setSsn("999-99-9999");

		healthAdvocateRequests.add(r);
		
		r = new HealthAdvocateRequest();
		r.setLastActionDate(DateHelper.get3MonthsAgo());
		r.setAddressFirstLine("00 Main Street");
		r.setAddressSecondLine("Apt 0");
		r.setCity("Chantilly");
		r.setEmail("testEmail2@testEmail.com");
		r.setFirstName("User");
		r.setHealthAdvocateEDIPI("2222");
		r.setLastName("Test");
		r.setPatientId("D123401");
		r.setUniqueId("3");
		r.setRequestDate(DateHelper.get3MonthsAgo());
		r.setStatus(HealthAdvocateStatusCode.REVOKED);
		r.setState("VA");
		r.setUriLinkKey("secret3");
		r.setZipCode("22222");
		r.setPatientName("Demopatient One");
		r.setDriversLicenseNumber("987654323");
		r.setDriversLicenseState("NY");		
		healthAdvocateRequests.add(r);
		r.setSsn("999-99-9999");


		return healthAdvocateRequests;
	}

	@Override
	public HealthAdvocateRequests fetchHealthAdvocateRequests(String patientId) {
	
		HealthAdvocateRequests processedHealthAdvocateRequests = new HealthAdvocateRequests();
		
		for (HealthAdvocateRequest r : healthAdvocateRequestDataStore) {
			if (r.getStatus() != null && r.getPatientId().equalsIgnoreCase(patientId)) {
				processedHealthAdvocateRequests.add(r);
			}
		}
		
		return processedHealthAdvocateRequests;
	
	}

	@Override
	public HealthAdvocateRequest getHealthAdvocate(String patientId, String dataId) {
		HealthAdvocateRequest match = new HealthAdvocateRequest();

		for (HealthAdvocateRequest healthAdvocateRequest : healthAdvocateRequestDataStore) {
			if (healthAdvocateRequest.getPatientId().contentEquals(patientId) && healthAdvocateRequest.getUniqueId().contentEquals(dataId)) {
				match = healthAdvocateRequest;
				break;
			}
		}
		
		return cloneHealthAdvocateRequest(match);

	}

	@Override
	public HealthAdvocateRequest createNewHealthAdvocateRequest(HealthAdvocateRequest data) {
		if (NullChecker.isNullish(data.getUniqueId())) {
			setRequestIds(data);
		}
		
		healthAdvocateRequestDataStore.add(data);
		
		return cloneHealthAdvocateRequest(data);
	}

	private void setRequestIds(HealthAdvocateRequest data) {
		data.setHealthAdvocateEDIPI(UUID.randomUUID().toString());
		data.setLastActionDate(DateHelper.getToday());
		data.setRequestDate(DateHelper.getToday());
		data.setUriLinkKey(UUID.randomUUID().toString());
		data.setUniqueId(UUID.randomUUID().toString());
	}

	@Override
	public HealthAdvocateRequest updateHealthAdvocateRequest(HealthAdvocateRequest data) {
		HealthAdvocateRequest match = null ;

		for (HealthAdvocateRequest r :healthAdvocateRequestDataStore) {
			if (r.getUniqueId().equalsIgnoreCase(data.getUniqueId())) {
				match = r;
				break;
			}
		}
		
		if (match != null) {
			data.setLastActionDate(DateHelper.getToday());
			healthAdvocateRequestDataStore.remove(match);
			healthAdvocateRequestDataStore.add(data);
		}
		
		return cloneHealthAdvocateRequest(data);
	}

    @Override
    public HealthAdvocateRequestForm saveHealthAdvocateRequestForm(HealthAdvocateRequestForm form) {
		return null; // To change body of implemented methods use File |
						// Settings | File Templates.

	}
}
