package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import java.util.Iterator;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElement;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElementDataStorage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.xls.DataElements;
import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;
import com.agilex.healthcare.utility.NullChecker;

public class FacilityInternalDataLayerExcel implements FacilityInternalDataLayer{
	
	private static final String domain = "Facilities";
	private static final String COLUMN_NAME = "Name";
	private static final String COLUMN_TYPE = "Type";
	private static final String COLUMN_FACILITYCODE = "FacilityCode";
	private static final String COLUMN_STATE = "State";
	private static final String COLUMN_CITY = "City";
	private static final String COLUMN_ADDRESS = "Address";
	private static final String COLUMN_PARENTSITECODE = "ParentSiteCode";

	private static Facilities facilities;

	public FacilityInternalDataLayerExcel() {
		synchronized (this) {
			if (facilities == null) {
				facilities = new Facilities();
				DataElementDataStorage storage = DataElementDataStorage.getInstance();;
				DataElements dataElements = storage.getData(domain, domain);
				createFacilities(dataElements);
			}
		}
	}

	private void createFacilities(DataElements dataElements) {
		for (DataElement dataElement : dataElements) {
			facilities.add(createFacility(dataElement));
		}
	}
	
	private Facility createFacility(DataElement dataElement){
		Facility facility = new Facility();
		facility.setName(dataElement.getValue(COLUMN_NAME));
		facility.setType(dataElement.getValue(COLUMN_TYPE));
		facility.setFacilityCode(dataElement.getValue(COLUMN_FACILITYCODE));
		facility.setState(dataElement.getValue(COLUMN_STATE));
		facility.setCity(dataElement.getValue(COLUMN_CITY));
		facility.setAddress(dataElement.getValue(COLUMN_ADDRESS));
		facility.setParentSiteCode(dataElement.getValue(COLUMN_PARENTSITECODE));
		return facility;
	}

	@Override
	public Facilities fetchFacilities() {
		return facilities;
	}

	@Override
	public Facility fetchFacilityByCode(String code) {
		Facility match = null;
		
		for (Facility facility : facilities) {
			if (facility.getFacilityCode().equals(code)) {
				match = facility;
			}
		}
		
		if (match == null) {
			throw new WebApplicationException(Status.NOT_FOUND);
		}
		
		return match;
	}
	
	@Override
	public Facility saveFacility(Facility facility) {
		if (facility != null) {
			try {
				Facility facilityToUpdate = fetchFacilityByCode(facility.getFacilityCode());
				facilityToUpdate.setName(facility.getName());
				facilityToUpdate.setAddress(facility.getAddress());
				facilityToUpdate.setCity(facility.getCity());
				facilityToUpdate.setState(facility.getState());
				facilityToUpdate.setParentSiteCode(facility.getParentSiteCode());
				facilityToUpdate.setType(facility.getType());
			} catch (WebApplicationException e) {
				facilities.add(facility);
			}
		}
		
		return facility;
	}

	@Override
	public void removeFacility(String facilityCode) {
		if (NullChecker.isNotNullish(facilityCode)) {
			Iterator<Facility> iterator = facilities.iterator();
			
			while (iterator.hasNext()) {
				Facility facility = iterator.next();
				
				if (facilityCode.equals(facility.getFacilityCode())) {
					iterator.remove();
					break;
				}
			}
		}
	}
}
