package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;

public class FacilityDataLayerMock implements FacilityDataLayer {

	Map<String, Facilities> facilityStorage = new HashMap<String, Facilities>();
    final String CHANTILLY_TEST_SITE_CODE_1 = "500";
    final String CHANTILLY_TEST_SITE_CODE_2 = "200";
    final String CHANTILLY_TEST_SITE_CODE_3 = "777";
    final String CHANTILLY_TEST_SITE_CODE_4 = "888";
	final String DC_SITE_CODE = "688";
	final String CHICAGO_SITE_CODE = "537";
	final String NORTH_CHICAGO_SITE_CODE = "556";
	final String OHIO_SITE_CODE = "538";
	final String PALO_ALTO_SITE_CODE = "640";
	final String GREATER_LA_SITE_CODE = "691";
	final String MARTINSBURG_SITE_CODE = "613";
	final String BALTIMORE_SITE_CODE = "512";
	final String NASHVILLE_SITE_CODE = "626";
	final String ORLANDO_SITE_CODE = "675";
	final String VANJHCS_SITE_CODE = "561";
	final String FAYETTEVILLE_SITE_CODE = "565";
	final String DENVER_SITE_CODE = "554";
	final String SALISBURY_SITE_CODE = "659";
	final String COLUMBIA_SITE_CODE = "544";
	final String DALLAS_SITE_CODE = "549";

	public FacilityDataLayerMock() {
		init();
	}

	private void init() {
		Facilities facilities = new Facilities();
		Facility facility = new Facility();

        facility.setAddress("5155 Parkstone Dr\nChantilly, VA 20120");
        facility.setFacilityCode(CHANTILLY_TEST_SITE_CODE_1);
        facility.setName("TEST VAMC");
        facility.setState("VA");
        facility.setType("VAMC");
        facility.setCity("Chantilly");
        facility.setParentSiteCode(CHANTILLY_TEST_SITE_CODE_1);
        facilities.add(facility);

        facility = new Facility();

        facility.setAddress("5154 Parkstone Dr\nChantilly, VA 20120");
        facility.setFacilityCode(CHANTILLY_TEST_SITE_CODE_2);
        facility.setName("TEST VAMC 2");
        facility.setState("VA");
        facility.setType("VAMC");
        facility.setCity("Chantilly");
        facility.setParentSiteCode(CHANTILLY_TEST_SITE_CODE_2);
        facilities.add(facility);

        facility = new Facility();

        facility.setAddress("5154 Parkstone Dr\nChantilly, VA 20120");
        facility.setFacilityCode(CHANTILLY_TEST_SITE_CODE_3);
        facility.setName("TEST VAMC 3");
        facility.setState("VA");
        facility.setType("VAMC");
        facility.setCity("Chantilly");
        facility.setParentSiteCode(CHANTILLY_TEST_SITE_CODE_3);
        facilities.add(facility);

        facility = new Facility();



        facility.setAddress("5154 Parkstone Dr\nChantilly, VA 20120");
        facility.setFacilityCode(CHANTILLY_TEST_SITE_CODE_4);
        facility.setName("TEST VAMC 4");
        facility.setState("VA");
        facility.setType("VAMC");
        facility.setCity("Chantilly");
        facility.setParentSiteCode(CHANTILLY_TEST_SITE_CODE_4);
        facilities.add(facility);

        facility = new Facility();
		
		facility.setAddress("50 Irving St. NW\nWashington, DC 20422");
		facility.setFacilityCode(DC_SITE_CODE);
		facility.setName("DC VAMC");
		facility.setState("DC");
		facility.setType("VAMC");
		facility.setCity("Washington");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);
		
		facility = new Facility();
		facility.setAddress("123 Fake St. \nWashington, DC 20422");
		facility.setFacilityCode(DC_SITE_CODE+"CBOC");
		facility.setName("Washington DC CBOC");
		facility.setState("DC");
		facility.setType("CBOC");
		facility.setCity("Washington");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("8796-D Sacramento Drive\nAlexandria, VA 22042");
		facility.setFacilityCode("ABC");
		facility.setName("Alexandria CBOC");
		facility.setState("VA");
		facility.setType("VAMC");
		facility.setCity("Alexandria");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("100 Emancipation Drive\nHampton, VA 23667");
		facility.setFacilityCode("590");
		facility.setName("Hampton (VAMC)");
		facility.setState("VA");
		facility.setType("VAMC");
		facility.setCity("Alexandria");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("244 Clearfield Ave #401\nVirginia Beach, VA 23462");
		facility.setFacilityCode("590GB");
		facility.setName("Norfolk Virginia Beach CBOC");
		facility.setState("VA");
		facility.setType("CBOC");
		facility.setCity("Virginia Beach");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("170 Prosperity Drive\nWinchester, VA 22602");
		facility.setFacilityCode("613GC");
		facility.setName("       s City");
		facility.setState("VA");
		facility.setType("CBOC");
		facility.setCity("Winchester");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("847 Cantrell Ave\nHarrisonburg, VA 22801");
		facility.setFacilityCode("613GF");
		facility.setName("Harrisonburg");
		facility.setState("VA");
		facility.setType("CBOC");
		facility.setCity("Harrisonburg");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("654 Highway 58 East\nNorton, VA 24273");
		facility.setFacilityCode("621GC");
		facility.setName("Norton CBOC");
		facility.setState("VA");
		facility.setType("CBOC");
		facility.setCity("Norton");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("1201 Broad Block Blvd\nRichmond, VA 23249");
		facility.setFacilityCode("652");
		facility.setName("Richmond VAMC");
		facility.setState("VA");
		facility.setType("VAMC");
		facility.setCity("Richmond");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("1965 Jefferson Davis Hwy\nFredericksburg, VA 23249");
		facility.setFacilityCode("653");
		facility.setName("Fredericksburg CBOC");
		facility.setState("VA");
		facility.setType("CBOC");
		facility.setCity("Fredericksburg");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("1970 Roanoke Blvd\nSalem, VA 24153");
		facility.setFacilityCode("658");
		facility.setName("Salem VAMC");
		facility.setState("VA");
		facility.setType("VAMC");
		facility.setCity("Salem");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("123 Ben Bolt Ave\nTazewell, VA 24651");
		facility.setFacilityCode("658GA");
		facility.setName("Tazewell CBOC");
		facility.setState("VA");
		facility.setType("CBOC");
		facility.setCity("Tazewell");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("705 Piney Forest Road\nDanville, VA 24540");
		facility.setFacilityCode("658GB");
		facility.setName("Danville CBOC");
		facility.setState("VA");
		facility.setType("CBOC");
		facility.setCity("Danville");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("3251 Stuarts Draft Hwy\nVFW Post #9339\nStuarts Draft, VA 24651");
		facility.setFacilityCode("658GA");
		facility.setName("Stuarts Draft");
		facility.setState("VA");
		facility.setType("CBOC");
		facility.setCity("Stuarts Draft");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("3251 Stuarts Draft Hwy\nVFW Post #9339\nStuarts Draft, VA 24651");
		facility.setFacilityCode("658GA");
		facility.setName("Stuarts Draft");
		facility.setState("VA");
		facility.setType("CBOC");
		facility.setCity("Stuarts Draft");
		facility.setParentSiteCode(DC_SITE_CODE);
		facilities.add(facility);

        //Need this Atlanta facility to demonstrate retrieving mental health providers for zztest.patient01
        facility = new Facility();
        facility.setAddress("123 Main St\\nAtlanta, GA 30332");
        facility.setFacilityCode("508");
        facility.setName("Atlanta VAMC");
        facility.setState("GA");
        facility.setType("VAMC");
        facility.setCity("Atlanta");
        facility.setParentSiteCode(DC_SITE_CODE);
        facilities.add(facility);

        facilityStorage.put("DC", facilities);

		facilities = new Facilities();

		facility = new Facility();
		facility.setAddress("820 S. Damen Ave.\nChicago, IL 60612");
		facility.setFacilityCode("537");
		facility.setName("Jesse Brown VAMC");
		facility.setState("IL");
		facility.setType("VAMC");
		facility.setCity("Chicago");
		facility.setParentSiteCode(CHICAGO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("30 East 15th Street\nChicago Heights, IL 60411");
		facility.setFacilityCode("537GA");
		facility.setName("Chicago Heights, IL");
		facility.setState("IL");
		facility.setType("CBOC");
		facility.setCity("Chicago");
		facility.setParentSiteCode(CHICAGO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("2038 W 95th St\nChicago, IL 60643");
		facility.setFacilityCode("537HA");
		facility.setName("Lakeside CBOC");
		facility.setState("IL");
		facility.setType("CBOC");
		facility.setCity("Chicago");
		facility.setParentSiteCode(CHICAGO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("1900 E Main St\nDanville, IL 61832");
		facility.setFacilityCode("550");
		facility.setName("Illiana HCS");
		facility.setState("IL");
		facility.setType("VAMC");
		facility.setCity("Danville");
		facility.setParentSiteCode(CHICAGO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("3001 Greenbay Road\nChicago, IL 60064");
		facility.setFacilityCode(NORTH_CHICAGO_SITE_CODE);
		facility.setName("North Chicago VAMC");
		facility.setState("IL");
		facility.setType("VAMC");
		facility.setCity("Chicago");
		facility.setParentSiteCode(NORTH_CHICAGO_SITE_CODE);
		facilities.add(facility);
		
		facilityStorage.put("IL", facilities);

		facilities = new Facilities();

		facility = new Facility();
		facility.setAddress("3333 Glendale Ave\nToledo, OH 43614");
		facility.setFacilityCode("506GA");
		facility.setName("Toledo CBOC");
		facility.setState("OH");
		facility.setType("CBOC");
		facility.setCity("Toledo");
		facility.setParentSiteCode(OHIO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("17273 Main St.\nRt 104\nChillicothe, OH 43614");
		//facility.setFacilityCode("538");
		facility.setFacilityCode(OHIO_SITE_CODE);
		facility.setName("Chillicothe VAMC");
		facility.setState("OH");
		facility.setType("VAMC");
		facility.setCity("Chillicothe");
		facility.setParentSiteCode(OHIO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("510 W Union St\nAthens, OH 43614");
		facility.setFacilityCode("538GA");
		facility.setName("Athens CBOC");
		facility.setState("OH");
		facility.setType("CBOC");
		facility.setCity("Athens");
		facility.setParentSiteCode(OHIO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("840 Gallia St\nPortsmouth, OH 45662");
		facility.setFacilityCode("538GB");
		facility.setName("Portsmouth CBOC");
		facility.setState("OH");
		facility.setType("CBOC");
		facility.setCity("Portsmouth");
		facility.setParentSiteCode(OHIO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("418 Colgate\nMarietta 45750");
		facility.setFacilityCode("538GC");
		facility.setName("Marietta CBOC");
		facility.setState("OH");
		facility.setType("CBOC");
		facility.setCity("Marietta");
		facility.setParentSiteCode(OHIO_SITE_CODE);
		facilities.add(facility);

		facilityStorage.put("OH", facilities);

		facilities = new Facilities();

		facility = new Facility();
		facility.setAddress("3801 Miranda Avenue\nPalo Alto, CA 94304");
		facility.setFacilityCode(PALO_ALTO_SITE_CODE);
		facility.setName("VA Palo Alto HCS");
		facility.setState("CA");
		facility.setType("VAMC");
		facility.setCity("Palo Alto");
		facility.setParentSiteCode(PALO_ALTO_SITE_CODE);
		facilities.add(facility);
		
		facility = new Facility();
		facility.setAddress("2615 East      on Ave\nFresno, CA 93703");
		facility.setFacilityCode("570");
		facility.setName("Central California HCS");
		facility.setState("CA");
		facility.setType("VAMC");
		facility.setCity("Fresno");
		facility.setParentSiteCode(PALO_ALTO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("340 E. Yosemite Ave\nMerced, CA 95340");
		facility.setFacilityCode("570GA");
		facility.setName("Merced CBOC");
		facility.setState("CA");
		facility.setType("CBOC");
		facility.setCity("Merced");
		facility.setParentSiteCode(PALO_ALTO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("1050 N Cherry St\nTulare, CA 93703");
		facility.setFacilityCode("570GB");
		facility.setName("Tulare CBOC");
		facility.setState("CA");
		facility.setType("CBOC");
		facility.setCity("Tulare");
		facility.setParentSiteCode(PALO_ALTO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("5901 East 7th St\nLong Beach, CA 93703");
		facility.setFacilityCode("600");
		facility.setName("Long Beach VAMC");
		facility.setState("CA");
		facility.setType("VAMC");
		facility.setCity("Long Beach");
		facility.setParentSiteCode(PALO_ALTO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("5901 East 7th St\nAnaheim, CA 93703");
		facility.setFacilityCode("600GA");
		facility.setName("Anaheim CBOC");
		facility.setState("CA");
		facility.setType("CBOC");
		facility.setCity("Anaheim");
		facility.setParentSiteCode(PALO_ALTO_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("11301 Wilshire Blvd.\nW. Los Angeles, CA 90073");
		facility.setFacilityCode(GREATER_LA_SITE_CODE);
		facility.setName("VA Greater Los Angeles HCS");
		facility.setState("CA");
		facility.setType("VAMC");
		facility.setCity("W. Los Angeles");
		facility.setParentSiteCode(GREATER_LA_SITE_CODE);
		facilities.add(facility);
		
		facilityStorage.put("CA", facilities);
        
        facilities = new Facilities();
        
		facility = new Facility();
		facility.setAddress("        Town Road, Route 9\nMartinsburg, WV 25401");
		facility.setFacilityCode(MARTINSBURG_SITE_CODE);
		facility.setName("Martinsburg VAMC");
		facility.setState("WV");
		facility.setType("VAMC");
		facility.setCity("Martinsburg");
		facility.setParentSiteCode(MARTINSBURG_SITE_CODE);
		facilities.add(facility);
		
		facility = new Facility();
		facility.setAddress("912 Market St.\nParkersburg, WV 26101");
		facility.setFacilityCode("540GB");
		facility.setName("Wood County Veterans Center");
		facility.setState("WV");
		facility.setType("CBOC");
		facility.setCity("Parkersburg");
		facility.setParentSiteCode(MARTINSBURG_SITE_CODE);
		facilities.add(facility);
		
		facilityStorage.put("WV", facilities);
        
        facilities = new Facilities();
        
		facility = new Facility();
		facility.setAddress("10 North        St.\nBaltimore, MD 21201");
		facility.setFacilityCode(BALTIMORE_SITE_CODE);
		facility.setName("VA Maryland HCS");
		facility.setState("MD");
		facility.setType("VAMC");
		facility.setCity("Baltimore");
		facility.setParentSiteCode(BALTIMORE_SITE_CODE);
		facilities.add(facility);
		
		facilityStorage.put("MD", facilities);
        
        facilities = new Facilities();
        
		facility = new Facility();
		facility.setAddress("1310 24th Avenue South\nNashville, TN 37212");
		facility.setFacilityCode(NASHVILLE_SITE_CODE);
		facility.setName("Middle Tennessee HCS");
		facility.setState("TN");
		facility.setType("VAMC");
		facility.setCity("Nashville");
		facility.setParentSiteCode(NASHVILLE_SITE_CODE);
		facilities.add(facility);
		
		facilityStorage.put("TN", facilities);
        
        facilities = new Facilities();
        
		facility = new Facility();
		facility.setAddress("5201         Street\nOrlando, FL 32803");
		facility.setFacilityCode(ORLANDO_SITE_CODE);
		facility.setName("Orlando VAMC");
		facility.setState("FL");
		facility.setType("VAMC");
		facility.setCity("Orlando");
		facility.setParentSiteCode(ORLANDO_SITE_CODE);
		facilities.add(facility);
		
		facilityStorage.put("FL", facilities);
        
        facilities = new Facilities();
        
		facility = new Facility();
		facility.setAddress("383 Tremont Avenue\nEast Orange, NJ 07018");
		facility.setFacilityCode(VANJHCS_SITE_CODE);
		facility.setName("VA New Jersey HCS");
		facility.setState("NJ");
		facility.setType("VAMC");
		facility.setCity("East Orange");
		facility.setParentSiteCode(VANJHCS_SITE_CODE);
		facilities.add(facility);
		
		facilityStorage.put("NJ", facilities);
        
        facilities = new Facilities();
        
		facility = new Facility();
		facility.setAddress("2300 Ramsey St.\nFayetteville, NC 28301");
		facility.setFacilityCode(FAYETTEVILLE_SITE_CODE);
		facility.setName("Fayetteville VAMC");
		facility.setState("NC");
		facility.setType("VAMC");
		facility.setCity("Fayetteville");
		facility.setParentSiteCode(FAYETTEVILLE_SITE_CODE);
		facilities.add(facility);

		facility = new Facility();
		facility.setAddress("1601 Brenner Avenue\nSalisbury, NC 28144");
		facility.setFacilityCode(SALISBURY_SITE_CODE);
		facility.setName("W. G. (Bill) Hefner VAMC");
		facility.setState("NC");
		facility.setType("VAMC");
		facility.setCity("Salisbury");
		facility.setParentSiteCode(SALISBURY_SITE_CODE);
		facilities.add(facility);
		
		facilityStorage.put("NC", facilities);
        
        facilities = new Facilities();
        
		facility = new Facility();
		facility.setAddress("1055 Clermont St.\nDenver, CO 80220");
		facility.setFacilityCode(DENVER_SITE_CODE);
		facility.setName("Eastern Colorado HCS");
		facility.setState("CO");
		facility.setType("VAMC");
		facility.setCity("Denver");
		facility.setParentSiteCode(DENVER_SITE_CODE);
		facilities.add(facility);
		
		facilityStorage.put("CO", facilities);
        
        facilities = new Facilities();
        
		facility = new Facility();
		facility.setAddress("6439 Garners Ferry Road\nColumbia, SC 29201");
		facility.setFacilityCode(COLUMBIA_SITE_CODE);
		facility.setName("         Jennings Bryan Dorn VAMC");
		facility.setState("SC");
		facility.setType("VAMC");
		facility.setCity("Columbia");
		facility.setParentSiteCode(COLUMBIA_SITE_CODE);
		facilities.add(facility);
		
		facilityStorage.put("SC", facilities);
        
        facilities = new Facilities();
        
		facility = new Facility();
		facility.setAddress("4500 South Lancaster Rd.\nDallas, TX 75216");
		facility.setFacilityCode(DALLAS_SITE_CODE);
		facility.setName("Dallas VAMC");
		facility.setState("TX");
		facility.setType("VAMC");
		facility.setCity("Dallas");
		facility.setParentSiteCode(DALLAS_SITE_CODE);
		facilities.add(facility);
		
		facilityStorage.put("TX", facilities);

		facility = new Facility();
		facility.setAddress("Innovations Sandbox");
		facility.setFacilityCode("777");
		facility.setName("IAE VAMC");
		facility.setState("IAE");
		facility.setType("VAMC");
		facility.setCity("Chantilly");
		facility.setParentSiteCode("777");
		facilities.add(facility);
		
		facilityStorage.put("IAE", facilities);
		
	}

	private Facilities fetchFacilities() {
		Collection<Facilities> facilityCollection = facilityStorage.values();
		Facilities consolidated = new Facilities();
		
		for(Facilities facilities : facilityCollection) {
			for(Facility facility : facilities) {
				consolidated.add(facility);
			}
		}
		
		return consolidated;
	}

	@Override
	public Facilities fetchFacilities(FacilityFilter filter) {
		Facilities facilities = fetchFacilities();
		FacilityFilterer filterer = new FacilityFilterer();
		
		return filterer.filter(facilities, filter);
	}

}
